/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class ConsulEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":apiEndpoint";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "consul".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "apiEndpoint", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(31);
        props.add("basicPropertyBinding");
        props.add("nearNode");
        props.add("synchronous");
        props.add("sslContextParameters");
        props.add("writeTimeout");
        props.add("nodeMeta");
        props.add("recursive");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("connectTimeout");
        props.add("consulClient");
        props.add("action");
        props.add("writeTimeoutMillis");
        props.add("key");
        props.add("readTimeoutMillis");
        props.add("valueAsString");
        props.add("exchangePattern");
        props.add("pingInstance");
        props.add("datacenter");
        props.add("userName");
        props.add("url");
        props.add("tags");
        props.add("lazyStartProducer");
        props.add("apiEndpoint");
        props.add("firstIndex");
        props.add("aclToken");
        props.add("consistencyMode");
        props.add("readTimeout");
        props.add("connectTimeoutMillis");
        props.add("exceptionHandler");
        props.add("blockSeconds");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("password");
        secretProps.add("aclToken");
        secretProps.add("userName");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

