/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.WorkdayEndpoint;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class WorkdayEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        WorkdayEndpoint target = (WorkdayEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)WorkdayEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "clientid": 
            case "clientId": {
                target.getWorkdayConfiguration().setClientId((String)WorkdayEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "clientsecret": 
            case "clientSecret": {
                target.getWorkdayConfiguration().setClientSecret((String)WorkdayEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "host": {
                target.getWorkdayConfiguration().setHost((String)WorkdayEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "httpconnectionmanager": 
            case "httpConnectionManager": {
                target.getWorkdayConfiguration().setHttpConnectionManager((PoolingHttpClientConnectionManager)WorkdayEndpointConfigurer.property((CamelContext)camelContext, PoolingHttpClientConnectionManager.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)WorkdayEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "reportformat": 
            case "reportFormat": {
                target.getWorkdayConfiguration().setReportFormat((String)WorkdayEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)WorkdayEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "tenant": {
                target.getWorkdayConfiguration().setTenant((String)WorkdayEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "tokenrefresh": 
            case "tokenRefresh": {
                target.getWorkdayConfiguration().setTokenRefresh((String)WorkdayEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        WorkdayEndpoint target = (WorkdayEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "clientid": 
            case "clientId": {
                return target.getWorkdayConfiguration().getClientId();
            }
            case "clientsecret": 
            case "clientSecret": {
                return target.getWorkdayConfiguration().getClientSecret();
            }
            case "host": {
                return target.getWorkdayConfiguration().getHost();
            }
            case "httpconnectionmanager": 
            case "httpConnectionManager": {
                return target.getWorkdayConfiguration().getHttpConnectionManager();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "reportformat": 
            case "reportFormat": {
                return target.getWorkdayConfiguration().getReportFormat();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "tenant": {
                return target.getWorkdayConfiguration().getTenant();
            }
            case "tokenrefresh": 
            case "tokenRefresh": {
                return target.getWorkdayConfiguration().getTokenRefresh();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("entity", WorkdayConfiguration.Entity.class);
        map.put("path", String.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("httpConnectionManager", PoolingHttpClientConnectionManager.class);
        map.put("synchronous", Boolean.TYPE);
        map.put("reportFormat", String.class);
        map.put("host", String.class);
        map.put("clientId", String.class);
        map.put("clientSecret", String.class);
        map.put("tokenRefresh", String.class);
        map.put("tenant", String.class);
        ALL_OPTIONS = map;
    }
}

