/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.infinispan;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class InfinispanEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":cacheName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "infinispan".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "cacheName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(32);
        props.add("basicPropertyBinding");
        props.add("defaultValue");
        props.add("synchronous");
        props.add("flags");
        props.add("secure");
        props.add("resultHeader");
        props.add("configurationUri");
        props.add("clusteredListener");
        props.add("password");
        props.add("cacheName");
        props.add("bridgeErrorHandler");
        props.add("oldValue");
        props.add("configurationProperties");
        props.add("value");
        props.add("key");
        props.add("securityServerName");
        props.add("customListener");
        props.add("hosts");
        props.add("securityRealm");
        props.add("exchangePattern");
        props.add("saslMechanism");
        props.add("eventTypes");
        props.add("cacheContainer");
        props.add("sync");
        props.add("command");
        props.add("lazyStartProducer");
        props.add("remappingFunction");
        props.add("cacheContainerConfiguration");
        props.add("exceptionHandler");
        props.add("operation");
        props.add("queryBuilder");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("password");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

