/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.avro.AvroEndpoint;
import org.apache.camel.component.avro.AvroTransport;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class AvroEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AvroEndpoint target = (AvroEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)AvroEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)AvroEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "protocol": {
                target.getConfiguration().setProtocol((Protocol)AvroEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "protocolclassname": 
            case "protocolClassName": {
                target.getConfiguration().setProtocolClassName((String)AvroEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "protocollocation": 
            case "protocolLocation": {
                target.getConfiguration().setProtocolLocation((String)AvroEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                target.getConfiguration().setReflectionProtocol((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "singleparameter": 
            case "singleParameter": {
                target.getConfiguration().setSingleParameter((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)AvroEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "uriauthority": 
            case "uriAuthority": {
                target.getConfiguration().setUriAuthority((String)AvroEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AvroEndpoint target = (AvroEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "protocol": {
                return target.getConfiguration().getProtocol();
            }
            case "protocolclassname": 
            case "protocolClassName": {
                return target.getConfiguration().getProtocolClassName();
            }
            case "protocollocation": 
            case "protocolLocation": {
                return target.getConfiguration().getProtocolLocation();
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                return target.getConfiguration().isReflectionProtocol();
            }
            case "singleparameter": 
            case "singleParameter": {
                return target.getConfiguration().isSingleParameter();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "uriauthority": 
            case "uriAuthority": {
                return target.getConfiguration().getUriAuthority();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("transport", AvroTransport.class);
        map.put("port", Integer.TYPE);
        map.put("host", String.class);
        map.put("messageName", String.class);
        map.put("protocol", Protocol.class);
        map.put("protocolClassName", String.class);
        map.put("protocolLocation", String.class);
        map.put("reflectionProtocol", Boolean.TYPE);
        map.put("singleParameter", Boolean.TYPE);
        map.put("uriAuthority", String.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

