/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.avro;

import java.util.Map;
import org.apache.avro.Protocol;
import org.apache.camel.CamelContext;
import org.apache.camel.component.avro.AvroComponent;
import org.apache.camel.component.avro.AvroConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class AvroComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private AvroConfiguration getOrCreateConfiguration(AvroComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new AvroConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        AvroComponent target = (AvroComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)AvroComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)AvroComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((AvroConfiguration)AvroComponentConfigurer.property((CamelContext)camelContext, AvroConfiguration.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)AvroComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "protocol": {
                this.getOrCreateConfiguration(target).setProtocol((Protocol)AvroComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "protocolclassname": 
            case "protocolClassName": {
                this.getOrCreateConfiguration(target).setProtocolClassName((String)AvroComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "protocollocation": 
            case "protocolLocation": {
                this.getOrCreateConfiguration(target).setProtocolLocation((String)AvroComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                this.getOrCreateConfiguration(target).setReflectionProtocol((Boolean)AvroComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "singleparameter": 
            case "singleParameter": {
                this.getOrCreateConfiguration(target).setSingleParameter((Boolean)AvroComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "uriauthority": 
            case "uriAuthority": {
                this.getOrCreateConfiguration(target).setUriAuthority((String)AvroComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        AvroComponent target = (AvroComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "protocol": {
                return this.getOrCreateConfiguration(target).getProtocol();
            }
            case "protocolclassname": 
            case "protocolClassName": {
                return this.getOrCreateConfiguration(target).getProtocolClassName();
            }
            case "protocollocation": 
            case "protocolLocation": {
                return this.getOrCreateConfiguration(target).getProtocolLocation();
            }
            case "reflectionprotocol": 
            case "reflectionProtocol": {
                return this.getOrCreateConfiguration(target).isReflectionProtocol();
            }
            case "singleparameter": 
            case "singleParameter": {
                return this.getOrCreateConfiguration(target).isSingleParameter();
            }
            case "uriauthority": 
            case "uriAuthority": {
                return this.getOrCreateConfiguration(target).getUriAuthority();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("protocol", Protocol.class);
        map.put("protocolClassName", String.class);
        map.put("protocolLocation", String.class);
        map.put("reflectionProtocol", Boolean.TYPE);
        map.put("singleParameter", Boolean.TYPE);
        map.put("uriAuthority", String.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("configuration", AvroConfiguration.class);
        ALL_OPTIONS = map;
    }
}

