/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.bigquery;

import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.googleapis.javanet.GoogleNetHttpTransport;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.client.util.Base64;
import com.google.api.client.util.Strings;
import com.google.api.services.bigquery.Bigquery;
import com.google.api.services.bigquery.BigqueryScopes;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleBigQueryConnectionFactory {
    private static final JsonFactory JSON_FACTORY = new JacksonFactory();
    private final Logger logger = LoggerFactory.getLogger(GoogleBigQueryConnectionFactory.class);
    private String serviceAccount;
    private String serviceAccountKey;
    private String credentialsFileLocation;
    private String serviceURL;
    private Bigquery client;

    public synchronized Bigquery getDefaultClient() throws Exception {
        if (this.client == null) {
            this.client = this.buildClient();
        }
        return this.client;
    }

    public Bigquery getMultiThreadClient(int parallelThreads) throws Exception {
        PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
        cm.setDefaultMaxPerRoute(parallelThreads);
        cm.setMaxTotal(parallelThreads);
        CloseableHttpClient httpClient = HttpClients.createMinimal((HttpClientConnectionManager)cm);
        return this.buildClient((HttpTransport)new ApacheHttpTransport((HttpClient)httpClient));
    }

    private Bigquery buildClient() throws Exception {
        return this.buildClient((HttpTransport)GoogleNetHttpTransport.newTrustedTransport());
    }

    private Bigquery buildClient(HttpTransport httpTransport) throws Exception {
        GoogleCredential credential = null;
        if (!Strings.isNullOrEmpty((String)this.serviceAccount) && !Strings.isNullOrEmpty((String)this.serviceAccountKey)) {
            this.logger.debug("Service Account and Key have been set explicitly. Initialising BigQuery using Service Account {}", (Object)this.serviceAccount);
            credential = this.createFromAccountKeyPair(httpTransport);
        }
        if (credential == null && !Strings.isNullOrEmpty((String)this.credentialsFileLocation)) {
            this.logger.debug("Key File Name has been set explicitly. Initialising BigQuery using Key File {}", (Object)this.credentialsFileLocation);
            credential = this.createFromFile();
        }
        if (credential == null) {
            this.logger.debug("No explicit Service Account or Key File Name have been provided. Initialising BigQuery using defaults");
            credential = this.createDefault();
        }
        Bigquery.Builder builder = new Bigquery.Builder(httpTransport, JSON_FACTORY, credential).setApplicationName("camel-google-bigquery");
        if (this.serviceURL != null) {
            builder.setRootUrl(this.serviceURL);
        }
        return builder.build();
    }

    private GoogleCredential createFromFile() throws Exception {
        try (FileInputStream is = new FileInputStream(this.credentialsFileLocation);){
            GoogleCredential credential = GoogleCredential.fromStream((InputStream)is);
            if (credential.createScopedRequired()) {
                credential = credential.createScoped((Collection)BigqueryScopes.all());
            }
            GoogleCredential googleCredential = credential;
            return googleCredential;
        }
    }

    private GoogleCredential createDefault() throws Exception {
        GoogleCredential credential = GoogleCredential.getApplicationDefault();
        List<String> scopes = Collections.singletonList("https://www.googleapis.com/auth/bigquery");
        if (credential.createScopedRequired()) {
            credential = credential.createScoped(scopes);
        }
        return credential;
    }

    private GoogleCredential createFromAccountKeyPair(HttpTransport httpTransport) {
        try {
            return new GoogleCredential.Builder().setTransport(httpTransport).setJsonFactory(JSON_FACTORY).setServiceAccountId(this.serviceAccount).setServiceAccountScopes((Collection)BigqueryScopes.all()).setServiceAccountPrivateKey(this.getPrivateKeyFromString(this.serviceAccountKey)).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private PrivateKey getPrivateKeyFromString(String serviceKeyPem) {
        PrivateKey privateKey;
        try {
            String privKeyPEM = serviceKeyPem.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("\r", "").replace("\n", "");
            byte[] encoded = Base64.decodeBase64((String)privKeyPEM);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encoded);
            privateKey = KeyFactory.getInstance("RSA").generatePrivate(keySpec);
        }
        catch (Exception e) {
            String error = "Constructing Private Key from PEM string failed: " + e.getMessage();
            this.logger.error(error, (Throwable)e);
            throw new RuntimeException(e);
        }
        return privateKey;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public GoogleBigQueryConnectionFactory setServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        this.resetClient();
        return this;
    }

    public String getServiceAccountKey() {
        return this.serviceAccountKey;
    }

    public GoogleBigQueryConnectionFactory setServiceAccountKey(String serviceAccountKey) {
        this.serviceAccountKey = serviceAccountKey;
        this.resetClient();
        return this;
    }

    public String getCredentialsFileLocation() {
        return this.credentialsFileLocation;
    }

    public GoogleBigQueryConnectionFactory setCredentialsFileLocation(String credentialsFileLocation) {
        this.credentialsFileLocation = credentialsFileLocation;
        this.resetClient();
        return this;
    }

    public String getServiceURL() {
        return this.serviceURL;
    }

    public GoogleBigQueryConnectionFactory setServiceURL(String serviceURL) {
        this.serviceURL = serviceURL;
        this.resetClient();
        return this;
    }

    private synchronized void resetClient() {
        this.client = null;
    }
}

