/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.util;

import java.util.LinkedList;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.support.AsyncProcessorSupport;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class UnwrapStreamProcessor
extends AsyncProcessorSupport {
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Object content = exchange.getIn().getBody();
        if (content instanceof Publisher) {
            Publisher pub = (Publisher)Publisher.class.cast(content);
            final LinkedList data = new LinkedList();
            pub.subscribe((Subscriber)new Subscriber<Object>(){

                public void onSubscribe(Subscription subscription) {
                    subscription.request(Long.MAX_VALUE);
                }

                public void onNext(Object o) {
                    data.add(o);
                }

                public void onError(Throwable throwable) {
                    this.addData();
                    exchange.setException(throwable);
                    callback.done(false);
                }

                public void onComplete() {
                    this.addData();
                    callback.done(false);
                }

                private void addData() {
                    Object body = data.size() == 0 ? null : (data.size() == 1 ? data.get(0) : data);
                    if (body instanceof Exchange && !exchange.equals(body)) {
                        Exchange copy = (Exchange)body;
                        exchange.setException((Throwable)copy.getException());
                        exchange.setIn(copy.getIn());
                        if (copy.hasOut()) {
                            exchange.setOut(copy.getOut());
                        }
                        exchange.getProperties().clear();
                        exchange.getProperties().putAll(copy.getProperties());
                    } else {
                        exchange.getMessage().setBody(body);
                    }
                }
            });
            return false;
        }
        callback.done(true);
        return true;
    }
}

