/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xquery;

import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.component.xquery.XQueryBuilder;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.component.PropertyConfigurerSupport;

@Language(value="xquery")
public class XQueryLanguage
extends LanguageSupport
implements PropertyConfigurer {
    private Class<?> resultType;
    private String headerName;

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public Predicate createPredicate(String expression) {
        expression = this.loadResource(expression);
        XQueryBuilder builder = XQueryBuilder.xquery(expression);
        this.configureBuilder(builder);
        return builder;
    }

    public Expression createExpression(String expression) {
        expression = this.loadResource(expression);
        XQueryBuilder builder = XQueryBuilder.xquery(expression);
        this.configureBuilder(builder);
        return builder;
    }

    public Predicate createPredicate(String expression, Object[] properties) {
        return (Predicate)this.createExpression(expression, properties);
    }

    public Expression createExpression(String expression, Object[] properties) {
        expression = this.loadResource(expression);
        Class clazz = (Class)this.property(Class.class, properties, 0, null);
        if (clazz != null) {
            this.setResultType(clazz);
        }
        this.setHeaderName((String)this.property(String.class, properties, 1, this.headerName));
        XQueryBuilder builder = XQueryBuilder.xquery(expression);
        this.configureBuilder(builder);
        return builder;
    }

    protected void configureBuilder(XQueryBuilder builder) {
        if (this.resultType != null) {
            builder.setResultType(this.resultType);
        }
        if (this.headerName != null) {
            builder.setHeaderName(this.headerName);
        }
    }

    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "resulttype": 
            case "resultType": {
                this.setResultType((Class)PropertyConfigurerSupport.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
            case "headername": 
            case "headerName": {
                this.setHeaderName((String)PropertyConfigurerSupport.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }
}

