/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.zendesk.ZendeskEndpointConfiguration;
import org.apache.camel.component.zendesk.internal.ZendeskApiMethod;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.Audit;
import org.zendesk.client.v2.model.Automation;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.Field;
import org.zendesk.client.v2.model.Forum;
import org.zendesk.client.v2.model.Group;
import org.zendesk.client.v2.model.GroupMembership;
import org.zendesk.client.v2.model.Identity;
import org.zendesk.client.v2.model.JobStatus;
import org.zendesk.client.v2.model.Macro;
import org.zendesk.client.v2.model.Organization;
import org.zendesk.client.v2.model.OrganizationMembership;
import org.zendesk.client.v2.model.Request;
import org.zendesk.client.v2.model.SatisfactionRating;
import org.zendesk.client.v2.model.SearchResultEntity;
import org.zendesk.client.v2.model.SortOrder;
import org.zendesk.client.v2.model.SuspendedTicket;
import org.zendesk.client.v2.model.Ticket;
import org.zendesk.client.v2.model.TicketForm;
import org.zendesk.client.v2.model.TicketImport;
import org.zendesk.client.v2.model.Topic;
import org.zendesk.client.v2.model.Trigger;
import org.zendesk.client.v2.model.User;
import org.zendesk.client.v2.model.dynamic.DynamicContentItem;
import org.zendesk.client.v2.model.dynamic.DynamicContentItemVariant;
import org.zendesk.client.v2.model.hc.Article;
import org.zendesk.client.v2.model.hc.ArticleAttachments;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.PermissionGroup;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.Translation;
import org.zendesk.client.v2.model.hc.UserSegment;
import org.zendesk.client.v2.model.schedules.Schedule;
import org.zendesk.client.v2.model.targets.Target;

public class ZendeskEndpointConfigurationConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ZendeskEndpointConfiguration target = (ZendeskEndpointConfiguration)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "article": 
            case "Article": {
                target.setArticle((Article)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Article.class, (Object)value));
                return true;
            }
            case "articleattachments": 
            case "ArticleAttachments": {
                target.setArticleAttachments((ArticleAttachments)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, ArticleAttachments.class, (Object)value));
                return true;
            }
            case "articleid": 
            case "ArticleId": {
                target.setArticleId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "articleid0": 
            case "ArticleId0": {
                target.setArticleId0((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "attachment": 
            case "Attachment": {
                target.setAttachment((Attachment)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Attachment.class, (Object)value));
                return true;
            }
            case "attachments": 
            case "Attachments": {
                target.setAttachments((List)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "audit": 
            case "Audit": {
                target.setAudit((Audit)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Audit.class, (Object)value));
                return true;
            }
            case "auditid": 
            case "AuditId": {
                target.setAuditId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "automation": 
            case "Automation": {
                target.setAutomation((Automation)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Automation.class, (Object)value));
                return true;
            }
            case "automationid": 
            case "AutomationId": {
                target.setAutomationId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "automationid0": 
            case "AutomationId0": {
                target.setAutomationId0((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "category": 
            case "Category": {
                target.setCategory((Category)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Category.class, (Object)value));
                return true;
            }
            case "categoryid": 
            case "CategoryId": {
                target.setCategoryId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "category_id": 
            case "Category_id": {
                target.setCategory_id((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "comment": 
            case "Comment": {
                target.setComment((Comment)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Comment.class, (Object)value));
                return true;
            }
            case "commentid": 
            case "CommentId": {
                target.setCommentId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "content": 
            case "Content": {
                target.setContent((byte[])ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, byte[].class, (Object)value));
                return true;
            }
            case "contenttype": 
            case "ContentType": {
                target.setContentType((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "email": 
            case "Email": {
                target.setEmail((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "endtime": 
            case "EndTime": {
                target.setEndTime((Date)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Date.class, (Object)value));
                return true;
            }
            case "externalid": 
            case "ExternalId": {
                target.setExternalId((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "field": 
            case "Field": {
                target.setField((Field)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Field.class, (Object)value));
                return true;
            }
            case "file": 
            case "File": {
                target.setFile((File)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, File.class, (Object)value));
                return true;
            }
            case "filename": 
            case "FileName": {
                target.setFileName((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "forum": 
            case "Forum": {
                target.setForum((Forum)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Forum.class, (Object)value));
                return true;
            }
            case "forum_id": 
            case "Forum_id": {
                target.setForum_id((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "group": 
            case "Group": {
                target.setGroup((Group)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Group.class, (Object)value));
                return true;
            }
            case "groupmembership": 
            case "GroupMembership": {
                target.setGroupMembership((GroupMembership)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, GroupMembership.class, (Object)value));
                return true;
            }
            case "group_id": 
            case "Group_id": {
                target.setGroup_id((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "group_membership_id": 
            case "Group_membership_id": {
                target.setGroup_membership_id((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "id": 
            case "Id": {
                target.setId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "idarticle": 
            case "IdArticle": {
                target.setIdArticle((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "identity": 
            case "Identity": {
                target.setIdentity((Identity)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Identity.class, (Object)value));
                return true;
            }
            case "identityid": 
            case "IdentityId": {
                target.setIdentityId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "ids": 
            case "Ids": {
                target.setIds((long[])ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, long[].class, (Object)value));
                return true;
            }
            case "includearchived": 
            case "IncludeArchived": {
                target.setIncludeArchived((Boolean)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "inline": 
            case "Inline": {
                target.setInline((Boolean)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "installationid": 
            case "InstallationId": {
                target.setInstallationId((Integer)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "item": 
            case "Item": {
                target.setItem((DynamicContentItem)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, DynamicContentItem.class, (Object)value));
                return true;
            }
            case "itemid": 
            case "ItemId": {
                target.setItemId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "json": 
            case "Json": {
                target.setJson((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "labels": 
            case "Labels": {
                target.setLabels((List)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "locale": 
            case "Locale": {
                target.setLocale((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "macro": 
            case "Macro": {
                target.setMacro((Macro)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Macro.class, (Object)value));
                return true;
            }
            case "macroid": 
            case "MacroId": {
                target.setMacroId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "macroid0": 
            case "MacroId0": {
                target.setMacroId0((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "methodname": 
            case "MethodName": {
                target.setMethodName((ZendeskApiMethod)((Object)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, ZendeskApiMethod.class, (Object)value)));
                return true;
            }
            case "monitorid": 
            case "MonitorId": {
                target.setMonitorId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "name": 
            case "Name": {
                target.setName((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "newpassword": 
            case "NewPassword": {
                target.setNewPassword((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "notifysubscribers": 
            case "NotifySubscribers": {
                target.setNotifySubscribers((Boolean)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Boolean.class, (Object)value));
                return true;
            }
            case "oauthtoken": 
            case "OauthToken": {
                target.setOauthToken((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "oldpassword": 
            case "OldPassword": {
                target.setOldPassword((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "order": 
            case "Order": {
                target.setOrder((SortOrder)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, SortOrder.class, (Object)value));
                return true;
            }
            case "organization": 
            case "Organization": {
                target.setOrganization((Organization)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Organization.class, (Object)value));
                return true;
            }
            case "organizationid": 
            case "OrganizationId": {
                target.setOrganizationId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "organizationlist": 
            case "OrganizationList": {
                target.setOrganizationList((List)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "organizationmembership": 
            case "OrganizationMembership": {
                target.setOrganizationMembership((OrganizationMembership)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, OrganizationMembership.class, (Object)value));
                return true;
            }
            case "organizationmembershiplist": 
            case "OrganizationMembershipList": {
                target.setOrganizationMembershipList((List)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "organizationmemberships": 
            case "OrganizationMemberships": {
                target.setOrganizationMemberships((OrganizationMembership[])ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, OrganizationMembership[].class, (Object)value));
                return true;
            }
            case "organization_id": 
            case "Organization_id": {
                target.setOrganization_id((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "organization_membership_id": 
            case "Organization_membership_id": {
                target.setOrganization_membership_id((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "organizations": 
            case "Organizations": {
                target.setOrganizations((Organization[])ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Organization[].class, (Object)value));
                return true;
            }
            case "page": 
            case "Page": {
                target.setPage((Integer)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "parameters": 
            case "Parameters": {
                target.setParameters((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "params": 
            case "Params": {
                target.setParams((Map)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "password": 
            case "Password": {
                target.setPassword((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "permissiongroup": 
            case "PermissionGroup": {
                target.setPermissionGroup((PermissionGroup)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, PermissionGroup.class, (Object)value));
                return true;
            }
            case "query": 
            case "Query": {
                target.setQuery((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "request": 
            case "Request": {
                target.setRequest((Request)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Request.class, (Object)value));
                return true;
            }
            case "requestid": 
            case "RequestId": {
                target.setRequestId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "role": 
            case "Role": {
                target.setRole((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "roles": 
            case "Roles": {
                target.setRoles((String[])ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String[].class, (Object)value));
                return true;
            }
            case "satisfactionrating": 
            case "SatisfactionRating": {
                target.setSatisfactionRating((SatisfactionRating)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, SatisfactionRating.class, (Object)value));
                return true;
            }
            case "schedule": 
            case "Schedule": {
                target.setSchedule((Schedule)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Schedule.class, (Object)value));
                return true;
            }
            case "scheduleid": 
            case "ScheduleId": {
                target.setScheduleId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "searchterm": 
            case "SearchTerm": {
                target.setSearchTerm((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "section": 
            case "Section": {
                target.setSection((Section)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Section.class, (Object)value));
                return true;
            }
            case "sectionid": 
            case "SectionId": {
                target.setSectionId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "serverurl": 
            case "ServerUrl": {
                target.setServerUrl((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sortby": 
            case "SortBy": {
                target.setSortBy((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "sortorder": 
            case "SortOrder": {
                target.setSortOrder((SortOrder)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, SortOrder.class, (Object)value));
                return true;
            }
            case "starttime": 
            case "StartTime": {
                target.setStartTime((Date)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Date.class, (Object)value));
                return true;
            }
            case "status": 
            case "Status": {
                target.setStatus((JobStatus)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, JobStatus.class, (Object)value));
                return true;
            }
            case "statuses": 
            case "Statuses": {
                target.setStatuses((List)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "suspendedticket": 
            case "SuspendedTicket": {
                target.setSuspendedTicket((SuspendedTicket)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, SuspendedTicket.class, (Object)value));
                return true;
            }
            case "tags": 
            case "Tags": {
                target.setTags((String[])ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String[].class, (Object)value));
                return true;
            }
            case "target": 
            case "Target": {
                target.setTarget((Target)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Target.class, (Object)value));
                return true;
            }
            case "targetid": 
            case "TargetId": {
                target.setTargetId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "ticket": 
            case "Ticket": {
                target.setTicket((Ticket)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Ticket.class, (Object)value));
                return true;
            }
            case "ticketform": 
            case "TicketForm": {
                target.setTicketForm((TicketForm)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, TicketForm.class, (Object)value));
                return true;
            }
            case "ticketid": 
            case "TicketId": {
                target.setTicketId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "ticketid0": 
            case "TicketId0": {
                target.setTicketId0((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "ticketimport": 
            case "TicketImport": {
                target.setTicketImport((TicketImport)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, TicketImport.class, (Object)value));
                return true;
            }
            case "ticketlist": 
            case "TicketList": {
                target.setTicketList((List)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "tickets": 
            case "Tickets": {
                target.setTickets((Ticket[])ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Ticket[].class, (Object)value));
                return true;
            }
            case "token": 
            case "Token": {
                target.setToken((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "topic": 
            case "Topic": {
                target.setTopic((Topic)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Topic.class, (Object)value));
                return true;
            }
            case "translation": 
            case "Translation": {
                target.setTranslation((Translation)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Translation.class, (Object)value));
                return true;
            }
            case "translationid": 
            case "TranslationId": {
                target.setTranslationId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "trigger": 
            case "Trigger": {
                target.setTrigger((Trigger)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Trigger.class, (Object)value));
                return true;
            }
            case "triggerid": 
            case "TriggerId": {
                target.setTriggerId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "triggerid0": 
            case "TriggerId0": {
                target.setTriggerId0((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "tweetid": 
            case "TweetId": {
                target.setTweetId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "type": 
            case "Type": {
                target.setType((Class)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Class.class, (Object)value));
                return true;
            }
            case "unixepochtime": 
            case "UnixEpochTime": {
                target.setUnixEpochTime((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "upload": 
            case "Upload": {
                target.setUpload((Attachment.Upload)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Attachment.Upload.class, (Object)value));
                return true;
            }
            case "user": 
            case "User": {
                target.setUser((User)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, User.class, (Object)value));
                return true;
            }
            case "userid": 
            case "UserId": {
                target.setUserId((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "userid0": 
            case "UserId0": {
                target.setUserId0((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "useridthatwillbemerged": 
            case "UserIdThatWillBeMerged": {
                target.setUserIdThatWillBeMerged((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "useridthatwillremain": 
            case "UserIdThatWillRemain": {
                target.setUserIdThatWillRemain((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "userlist": 
            case "UserList": {
                target.setUserList((List)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "usersegment": 
            case "UserSegment": {
                target.setUserSegment((UserSegment)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, UserSegment.class, (Object)value));
                return true;
            }
            case "user_id": 
            case "User_id": {
                target.setUser_id((Long)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, Long.class, (Object)value));
                return true;
            }
            case "username": 
            case "Username": {
                target.setUsername((String)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "users": 
            case "Users": {
                target.setUsers((User[])ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, User[].class, (Object)value));
                return true;
            }
            case "userslist": 
            case "UsersList": {
                target.setUsersList((List)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, List.class, (Object)value));
                return true;
            }
            case "variant": 
            case "Variant": {
                target.setVariant((DynamicContentItemVariant)ZendeskEndpointConfigurationConfigurer.property((CamelContext)camelContext, DynamicContentItemVariant.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ZendeskEndpointConfiguration target = (ZendeskEndpointConfiguration)obj;
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "article": 
            case "Article": {
                return target.getArticle();
            }
            case "articleattachments": 
            case "ArticleAttachments": {
                return target.getArticleAttachments();
            }
            case "articleid": 
            case "ArticleId": {
                return target.getArticleId();
            }
            case "articleid0": 
            case "ArticleId0": {
                return target.getArticleId0();
            }
            case "attachment": 
            case "Attachment": {
                return target.getAttachment();
            }
            case "attachments": 
            case "Attachments": {
                return target.getAttachments();
            }
            case "audit": 
            case "Audit": {
                return target.getAudit();
            }
            case "auditid": 
            case "AuditId": {
                return target.getAuditId();
            }
            case "automation": 
            case "Automation": {
                return target.getAutomation();
            }
            case "automationid": 
            case "AutomationId": {
                return target.getAutomationId();
            }
            case "automationid0": 
            case "AutomationId0": {
                return target.getAutomationId0();
            }
            case "category": 
            case "Category": {
                return target.getCategory();
            }
            case "categoryid": 
            case "CategoryId": {
                return target.getCategoryId();
            }
            case "category_id": 
            case "Category_id": {
                return target.getCategory_id();
            }
            case "comment": 
            case "Comment": {
                return target.getComment();
            }
            case "commentid": 
            case "CommentId": {
                return target.getCommentId();
            }
            case "content": 
            case "Content": {
                return target.getContent();
            }
            case "contenttype": 
            case "ContentType": {
                return target.getContentType();
            }
            case "email": 
            case "Email": {
                return target.getEmail();
            }
            case "endtime": 
            case "EndTime": {
                return target.getEndTime();
            }
            case "externalid": 
            case "ExternalId": {
                return target.getExternalId();
            }
            case "field": 
            case "Field": {
                return target.getField();
            }
            case "file": 
            case "File": {
                return target.getFile();
            }
            case "filename": 
            case "FileName": {
                return target.getFileName();
            }
            case "forum": 
            case "Forum": {
                return target.getForum();
            }
            case "forum_id": 
            case "Forum_id": {
                return target.getForum_id();
            }
            case "group": 
            case "Group": {
                return target.getGroup();
            }
            case "groupmembership": 
            case "GroupMembership": {
                return target.getGroupMembership();
            }
            case "group_id": 
            case "Group_id": {
                return target.getGroup_id();
            }
            case "group_membership_id": 
            case "Group_membership_id": {
                return target.getGroup_membership_id();
            }
            case "id": 
            case "Id": {
                return target.getId();
            }
            case "idarticle": 
            case "IdArticle": {
                return target.getIdArticle();
            }
            case "identity": 
            case "Identity": {
                return target.getIdentity();
            }
            case "identityid": 
            case "IdentityId": {
                return target.getIdentityId();
            }
            case "ids": 
            case "Ids": {
                return target.getIds();
            }
            case "includearchived": 
            case "IncludeArchived": {
                return target.getIncludeArchived();
            }
            case "inline": 
            case "Inline": {
                return target.getInline();
            }
            case "installationid": 
            case "InstallationId": {
                return target.getInstallationId();
            }
            case "item": 
            case "Item": {
                return target.getItem();
            }
            case "itemid": 
            case "ItemId": {
                return target.getItemId();
            }
            case "json": 
            case "Json": {
                return target.getJson();
            }
            case "labels": 
            case "Labels": {
                return target.getLabels();
            }
            case "locale": 
            case "Locale": {
                return target.getLocale();
            }
            case "macro": 
            case "Macro": {
                return target.getMacro();
            }
            case "macroid": 
            case "MacroId": {
                return target.getMacroId();
            }
            case "macroid0": 
            case "MacroId0": {
                return target.getMacroId0();
            }
            case "methodname": 
            case "MethodName": {
                return target.getMethodName();
            }
            case "monitorid": 
            case "MonitorId": {
                return target.getMonitorId();
            }
            case "name": 
            case "Name": {
                return target.getName();
            }
            case "newpassword": 
            case "NewPassword": {
                return target.getNewPassword();
            }
            case "notifysubscribers": 
            case "NotifySubscribers": {
                return target.getNotifySubscribers();
            }
            case "oauthtoken": 
            case "OauthToken": {
                return target.getOauthToken();
            }
            case "oldpassword": 
            case "OldPassword": {
                return target.getOldPassword();
            }
            case "order": 
            case "Order": {
                return target.getOrder();
            }
            case "organization": 
            case "Organization": {
                return target.getOrganization();
            }
            case "organizationid": 
            case "OrganizationId": {
                return target.getOrganizationId();
            }
            case "organizationlist": 
            case "OrganizationList": {
                return target.getOrganizationList();
            }
            case "organizationmembership": 
            case "OrganizationMembership": {
                return target.getOrganizationMembership();
            }
            case "organizationmembershiplist": 
            case "OrganizationMembershipList": {
                return target.getOrganizationMembershipList();
            }
            case "organizationmemberships": 
            case "OrganizationMemberships": {
                return target.getOrganizationMemberships();
            }
            case "organization_id": 
            case "Organization_id": {
                return target.getOrganization_id();
            }
            case "organization_membership_id": 
            case "Organization_membership_id": {
                return target.getOrganization_membership_id();
            }
            case "organizations": 
            case "Organizations": {
                return target.getOrganizations();
            }
            case "page": 
            case "Page": {
                return target.getPage();
            }
            case "parameters": 
            case "Parameters": {
                return target.getParameters();
            }
            case "params": 
            case "Params": {
                return target.getParams();
            }
            case "password": 
            case "Password": {
                return target.getPassword();
            }
            case "permissiongroup": 
            case "PermissionGroup": {
                return target.getPermissionGroup();
            }
            case "query": 
            case "Query": {
                return target.getQuery();
            }
            case "request": 
            case "Request": {
                return target.getRequest();
            }
            case "requestid": 
            case "RequestId": {
                return target.getRequestId();
            }
            case "role": 
            case "Role": {
                return target.getRole();
            }
            case "roles": 
            case "Roles": {
                return target.getRoles();
            }
            case "satisfactionrating": 
            case "SatisfactionRating": {
                return target.getSatisfactionRating();
            }
            case "schedule": 
            case "Schedule": {
                return target.getSchedule();
            }
            case "scheduleid": 
            case "ScheduleId": {
                return target.getScheduleId();
            }
            case "searchterm": 
            case "SearchTerm": {
                return target.getSearchTerm();
            }
            case "section": 
            case "Section": {
                return target.getSection();
            }
            case "sectionid": 
            case "SectionId": {
                return target.getSectionId();
            }
            case "serverurl": 
            case "ServerUrl": {
                return target.getServerUrl();
            }
            case "sortby": 
            case "SortBy": {
                return target.getSortBy();
            }
            case "sortorder": 
            case "SortOrder": {
                return target.getSortOrder();
            }
            case "starttime": 
            case "StartTime": {
                return target.getStartTime();
            }
            case "status": 
            case "Status": {
                return target.getStatus();
            }
            case "statuses": 
            case "Statuses": {
                return target.getStatuses();
            }
            case "suspendedticket": 
            case "SuspendedTicket": {
                return target.getSuspendedTicket();
            }
            case "tags": 
            case "Tags": {
                return target.getTags();
            }
            case "target": 
            case "Target": {
                return target.getTarget();
            }
            case "targetid": 
            case "TargetId": {
                return target.getTargetId();
            }
            case "ticket": 
            case "Ticket": {
                return target.getTicket();
            }
            case "ticketform": 
            case "TicketForm": {
                return target.getTicketForm();
            }
            case "ticketid": 
            case "TicketId": {
                return target.getTicketId();
            }
            case "ticketid0": 
            case "TicketId0": {
                return target.getTicketId0();
            }
            case "ticketimport": 
            case "TicketImport": {
                return target.getTicketImport();
            }
            case "ticketlist": 
            case "TicketList": {
                return target.getTicketList();
            }
            case "tickets": 
            case "Tickets": {
                return target.getTickets();
            }
            case "token": 
            case "Token": {
                return target.getToken();
            }
            case "topic": 
            case "Topic": {
                return target.getTopic();
            }
            case "translation": 
            case "Translation": {
                return target.getTranslation();
            }
            case "translationid": 
            case "TranslationId": {
                return target.getTranslationId();
            }
            case "trigger": 
            case "Trigger": {
                return target.getTrigger();
            }
            case "triggerid": 
            case "TriggerId": {
                return target.getTriggerId();
            }
            case "triggerid0": 
            case "TriggerId0": {
                return target.getTriggerId0();
            }
            case "tweetid": 
            case "TweetId": {
                return target.getTweetId();
            }
            case "type": 
            case "Type": {
                return target.getType();
            }
            case "unixepochtime": 
            case "UnixEpochTime": {
                return target.getUnixEpochTime();
            }
            case "upload": 
            case "Upload": {
                return target.getUpload();
            }
            case "user": 
            case "User": {
                return target.getUser();
            }
            case "userid": 
            case "UserId": {
                return target.getUserId();
            }
            case "userid0": 
            case "UserId0": {
                return target.getUserId0();
            }
            case "useridthatwillbemerged": 
            case "UserIdThatWillBeMerged": {
                return target.getUserIdThatWillBeMerged();
            }
            case "useridthatwillremain": 
            case "UserIdThatWillRemain": {
                return target.getUserIdThatWillRemain();
            }
            case "userlist": 
            case "UserList": {
                return target.getUserList();
            }
            case "usersegment": 
            case "UserSegment": {
                return target.getUserSegment();
            }
            case "user_id": 
            case "User_id": {
                return target.getUser_id();
            }
            case "username": 
            case "Username": {
                return target.getUsername();
            }
            case "users": 
            case "Users": {
                return target.getUsers();
            }
            case "userslist": 
            case "UsersList": {
                return target.getUsersList();
            }
            case "variant": 
            case "Variant": {
                return target.getVariant();
            }
        }
        return null;
    }

    public Object getCollectionValueType(Object target, String name, boolean ignoreCase) {
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "attachments": 
            case "Attachments": {
                return Attachment.class;
            }
            case "labels": 
            case "Labels": {
                return String.class;
            }
            case "organizationlist": 
            case "OrganizationList": {
                return Organization.class;
            }
            case "organizationmembershiplist": 
            case "OrganizationMembershipList": {
                return OrganizationMembership.class;
            }
            case "params": 
            case "Params": {
                return Object.class;
            }
            case "statuses": 
            case "Statuses": {
                return JobStatus.class;
            }
            case "ticketlist": 
            case "TicketList": {
                return Ticket.class;
            }
            case "type": 
            case "Type": {
                return SearchResultEntity.class;
            }
            case "userlist": 
            case "UserList": {
                return User.class;
            }
            case "userslist": 
            case "UsersList": {
                return User.class;
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("Article", Article.class);
        map.put("ArticleAttachments", ArticleAttachments.class);
        map.put("ArticleId", Long.class);
        map.put("ArticleId0", Long.class);
        map.put("Attachment", Attachment.class);
        map.put("Attachments", List.class);
        map.put("Audit", Audit.class);
        map.put("AuditId", Long.class);
        map.put("Automation", Automation.class);
        map.put("AutomationId", Long.class);
        map.put("AutomationId0", Long.class);
        map.put("Category", Category.class);
        map.put("CategoryId", Long.class);
        map.put("Category_id", Long.class);
        map.put("Comment", Comment.class);
        map.put("CommentId", Long.class);
        map.put("Content", byte[].class);
        map.put("ContentType", String.class);
        map.put("Email", String.class);
        map.put("EndTime", Date.class);
        map.put("ExternalId", String.class);
        map.put("Field", Field.class);
        map.put("File", File.class);
        map.put("FileName", String.class);
        map.put("Forum", Forum.class);
        map.put("Forum_id", Long.class);
        map.put("Group", Group.class);
        map.put("GroupMembership", GroupMembership.class);
        map.put("Group_id", Long.class);
        map.put("Group_membership_id", Long.class);
        map.put("Id", Long.class);
        map.put("IdArticle", String.class);
        map.put("Identity", Identity.class);
        map.put("IdentityId", Long.class);
        map.put("Ids", long[].class);
        map.put("IncludeArchived", Boolean.class);
        map.put("Inline", Boolean.class);
        map.put("InstallationId", Integer.class);
        map.put("Item", DynamicContentItem.class);
        map.put("ItemId", Long.class);
        map.put("Json", String.class);
        map.put("Labels", List.class);
        map.put("Locale", String.class);
        map.put("Macro", Macro.class);
        map.put("MacroId", Long.class);
        map.put("MacroId0", Long.class);
        map.put("MethodName", ZendeskApiMethod.class);
        map.put("MonitorId", Long.class);
        map.put("Name", String.class);
        map.put("NewPassword", String.class);
        map.put("NotifySubscribers", Boolean.class);
        map.put("OauthToken", String.class);
        map.put("OldPassword", String.class);
        map.put("Order", SortOrder.class);
        map.put("Organization", Organization.class);
        map.put("OrganizationId", Long.class);
        map.put("OrganizationList", List.class);
        map.put("OrganizationMembership", OrganizationMembership.class);
        map.put("OrganizationMembershipList", List.class);
        map.put("OrganizationMemberships", OrganizationMembership[].class);
        map.put("Organization_id", Long.class);
        map.put("Organization_membership_id", Long.class);
        map.put("Organizations", Organization[].class);
        map.put("Page", Integer.class);
        map.put("Parameters", String.class);
        map.put("Params", Map.class);
        map.put("Password", String.class);
        map.put("PermissionGroup", PermissionGroup.class);
        map.put("Query", String.class);
        map.put("Request", Request.class);
        map.put("RequestId", Long.class);
        map.put("Role", String.class);
        map.put("Roles", String[].class);
        map.put("SatisfactionRating", SatisfactionRating.class);
        map.put("Schedule", Schedule.class);
        map.put("ScheduleId", Long.class);
        map.put("SearchTerm", String.class);
        map.put("Section", Section.class);
        map.put("SectionId", Long.class);
        map.put("ServerUrl", String.class);
        map.put("SortBy", String.class);
        map.put("SortOrder", SortOrder.class);
        map.put("StartTime", Date.class);
        map.put("Status", JobStatus.class);
        map.put("Statuses", List.class);
        map.put("SuspendedTicket", SuspendedTicket.class);
        map.put("Tags", String[].class);
        map.put("Target", Target.class);
        map.put("TargetId", Long.class);
        map.put("Ticket", Ticket.class);
        map.put("TicketForm", TicketForm.class);
        map.put("TicketId", Long.class);
        map.put("TicketId0", Long.class);
        map.put("TicketImport", TicketImport.class);
        map.put("TicketList", List.class);
        map.put("Tickets", Ticket[].class);
        map.put("Token", String.class);
        map.put("Topic", Topic.class);
        map.put("Translation", Translation.class);
        map.put("TranslationId", Long.class);
        map.put("Trigger", Trigger.class);
        map.put("TriggerId", Long.class);
        map.put("TriggerId0", Long.class);
        map.put("TweetId", Long.class);
        map.put("Type", Class.class);
        map.put("UnixEpochTime", Long.class);
        map.put("Upload", Attachment.Upload.class);
        map.put("User", User.class);
        map.put("UserId", Long.class);
        map.put("UserId0", Long.class);
        map.put("UserIdThatWillBeMerged", Long.class);
        map.put("UserIdThatWillRemain", Long.class);
        map.put("UserList", List.class);
        map.put("UserSegment", UserSegment.class);
        map.put("User_id", Long.class);
        map.put("Username", String.class);
        map.put("Users", User[].class);
        map.put("UsersList", List.class);
        map.put("Variant", DynamicContentItemVariant.class);
        ALL_OPTIONS = map;
    }
}

