/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.rest.api.PreferReturnEnum;
import java.util.Map;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.hl7.fhir.instance.model.api.IIdType;

@ApiParams(apiName="patch", description="API for the patch operation, which performs a logical patch on a server resource", apiMethods={@ApiMethod(methodName="patchById", description="Applies the patch to the given resource ID", signatures={"ca.uhn.fhir.rest.api.MethodOutcome patchById(String patchBody, org.hl7.fhir.instance.model.api.IIdType id, ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)", "ca.uhn.fhir.rest.api.MethodOutcome patchById(String patchBody, String stringId, ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="patchByUrl", description="Specifies that the update should be performed as a conditional create against a given search URL", signatures={"ca.uhn.fhir.rest.api.MethodOutcome patchByUrl(String patchBody, String url, ca.uhn.fhir.rest.api.PreferReturnEnum preferReturn, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"})}, aliases={})
@UriParams
@Configurer
public final class FhirPatchEndpointConfiguration
extends FhirConfiguration {
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="patchById", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="patchById", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="patchByUrl", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL")})
    private Map<ExtraParameters, Object> extraParameters;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="patchById", description="The resource ID to patch")})
    private IIdType id;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="patchById", description="The body of the patch document serialized in either XML or JSON which conforms to http://jsonpatch.com/ or http://tools.ietf.org/html/rfc5261"), @ApiMethod(methodName="patchById", description="The body of the patch document serialized in either XML or JSON which conforms to http://jsonpatch.com/ or http://tools.ietf.org/html/rfc5261"), @ApiMethod(methodName="patchByUrl", description="The body of the patch document serialized in either XML or JSON which conforms to http://jsonpatch.com/ or http://tools.ietf.org/html/rfc5261")})
    private String patchBody;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="patchById", description="Add a Prefer header to the request, which requests that the server include or suppress the resource body as a part of the result. If a resource is returned by the server it will be parsed an accessible to the client via MethodOutcome#getResource()"), @ApiMethod(methodName="patchById", description="Add a Prefer header to the request, which requests that the server include or suppress the resource body as a part of the result. If a resource is returned by the server it will be parsed an accessible to the client via MethodOutcome#getResource()"), @ApiMethod(methodName="patchByUrl", description="Add a Prefer header to the request, which requests that the server include or suppress the resource body as a part of the result. If a resource is returned by the server it will be parsed an accessible to the client via MethodOutcome#getResource()")})
    private PreferReturnEnum preferReturn;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="patchById", description="The resource ID to patch")})
    private String stringId;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="patchByUrl", description="The search URL to use. The format of this URL should be of the form ResourceTypeParameters, for example: Patientname=Smith&amp;identifier=13.2.4.11.4%7C847366")})
    private String url;

    public Map<ExtraParameters, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public void setExtraParameters(Map<ExtraParameters, Object> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public IIdType getId() {
        return this.id;
    }

    public void setId(IIdType id) {
        this.id = id;
    }

    public String getPatchBody() {
        return this.patchBody;
    }

    public void setPatchBody(String patchBody) {
        this.patchBody = patchBody;
    }

    public PreferReturnEnum getPreferReturn() {
        return this.preferReturn;
    }

    public void setPreferReturn(PreferReturnEnum preferReturn) {
        this.preferReturn = preferReturn;
    }

    public String getStringId() {
        return this.stringId;
    }

    public void setStringId(String stringId) {
        this.stringId = stringId;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

