/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import java.util.Date;
import java.util.Map;
import org.apache.camel.component.fhir.FhirConfiguration;
import org.apache.camel.component.fhir.api.ExtraParameters;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

@ApiParams(apiName="history", description="API for the history method", apiMethods={@ApiMethod(methodName="onInstance", description="Perform the operation across all versions of a specific resource (by ID and type) on the server", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle onInstance(org.hl7.fhir.instance.model.api.IIdType id, Class<org.hl7.fhir.instance.model.api.IBaseBundle> returnType, Integer count, java.util.Date cutoff, org.hl7.fhir.instance.model.api.IPrimitiveType<java.util.Date> iCutoff, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="onServer", description="Perform the operation across all versions of all resources of all types on the server", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle onServer(Class<org.hl7.fhir.instance.model.api.IBaseBundle> returnType, Integer count, java.util.Date cutoff, org.hl7.fhir.instance.model.api.IPrimitiveType<java.util.Date> iCutoff, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"}), @ApiMethod(methodName="onType", description="Perform the operation across all versions of all resources of the given type on the server", signatures={"org.hl7.fhir.instance.model.api.IBaseBundle onType(Class<org.hl7.fhir.instance.model.api.IBaseResource> resourceType, Class<org.hl7.fhir.instance.model.api.IBaseBundle> returnType, Integer count, java.util.Date cutoff, org.hl7.fhir.instance.model.api.IPrimitiveType<java.util.Date> iCutoff, java.util.Map<org.apache.camel.component.fhir.api.ExtraParameters, Object> extraParameters)"})}, aliases={})
@UriParams
@Configurer
public final class FhirHistoryEndpointConfiguration
extends FhirConfiguration {
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="onInstance", description="Request that the server return only up to theCount number of resources, may be NULL"), @ApiMethod(methodName="onServer", description="Request that the server return only up to theCount number of resources, may be NULL"), @ApiMethod(methodName="onType", description="Request that the server return only up to theCount number of resources, may be NULL")})
    private Integer count;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="onInstance", description="Request that the server return only resource versions that were created at or after the given time (inclusive), may be NULL"), @ApiMethod(methodName="onServer", description="Request that the server return only resource versions that were created at or after the given time (inclusive), may be NULL"), @ApiMethod(methodName="onType", description="Request that the server return only resource versions that were created at or after the given time (inclusive), may be NULL")})
    private Date cutoff;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="onInstance", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="onServer", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL"), @ApiMethod(methodName="onType", description="See ExtraParameters for a full list of parameters that can be passed, may be NULL")})
    private Map<ExtraParameters, Object> extraParameters;
    @UriParam
    @ApiParam(optional=true, apiMethods={@ApiMethod(methodName="onInstance", description="Request that the server return only resource versions that were created at or after the given time (inclusive), may be NULL"), @ApiMethod(methodName="onServer", description="Request that the server return only resource versions that were created at or after the given time (inclusive), may be NULL"), @ApiMethod(methodName="onType", description="Request that the server return only resource versions that were created at or after the given time (inclusive), may be NULL")})
    private IPrimitiveType<Date> iCutoff;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="onInstance", description="The IIdType which must be populated with both a resource type and a resource ID at")})
    private IIdType id;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="onType", description="The resource type to search for")})
    private Class<IBaseResource> resourceType;
    @UriParam
    @ApiParam(optional=false, apiMethods={@ApiMethod(methodName="onInstance", description="Request that the method return a Bundle resource (such as ca.uhn.fhir.model.dstu2.resource.Bundle). Use this method if you are accessing a DSTU2 server."), @ApiMethod(methodName="onServer", description="Request that the method return a Bundle resource (such as ca.uhn.fhir.model.dstu2.resource.Bundle). Use this method if you are accessing a DSTU2 server."), @ApiMethod(methodName="onType", description="Request that the method return a Bundle resource (such as ca.uhn.fhir.model.dstu2.resource.Bundle). Use this method if you are accessing a DSTU2 server.")})
    private Class<IBaseBundle> returnType;

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Date getCutoff() {
        return this.cutoff;
    }

    public void setCutoff(Date cutoff) {
        this.cutoff = cutoff;
    }

    public Map<ExtraParameters, Object> getExtraParameters() {
        return this.extraParameters;
    }

    public void setExtraParameters(Map<ExtraParameters, Object> extraParameters) {
        this.extraParameters = extraParameters;
    }

    public IPrimitiveType<Date> getICutoff() {
        return this.iCutoff;
    }

    public void setICutoff(IPrimitiveType<Date> iCutoff) {
        this.iCutoff = iCutoff;
    }

    public IIdType getId() {
        return this.id;
    }

    public void setId(IIdType id) {
        this.id = id;
    }

    public Class<IBaseResource> getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(Class<IBaseResource> resourceType) {
        this.resourceType = resourceType;
    }

    public Class<IBaseBundle> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<IBaseBundle> returnType) {
        this.returnType = returnType;
    }
}

