/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.api.SummaryEnum;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.api.ServerValidationModeEnum;
import org.apache.camel.component.fhir.internal.FhirApiName;
import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriParams
@Configurer
public class FhirConfiguration {
    @UriPath
    @Metadata(required=true)
    private FhirApiName apiName;
    @UriPath
    @Metadata(required=true)
    private String methodName;
    @UriParam(description="The FHIR server base URL")
    private String serverUrl;
    @UriParam(description="The FHIR Version to use", defaultValue="R4", javaType="java.lang.String")
    private FhirVersionEnum fhirVersion = FhirVersionEnum.R4;
    @UriParam(description="Pretty print all request")
    private boolean prettyPrint;
    @UriParam(description="Encoding to use for all request", enums="JSON, XML", javaType="java.lang.String")
    private EncodingEnum encoding;
    @UriParam(description="Username to use for basic authentication", label="security", secret=true)
    private String username;
    @UriParam(description="Username to use for basic authentication", label="security", secret=true)
    private String password;
    @UriParam(description="OAuth access token", label="security", secret=true)
    private String accessToken;
    @UriParam(description="Will log every requests and responses")
    private boolean log;
    @UriParam(description="Compresses outgoing (POST/PUT) contents to the GZIP format", label="advanced")
    private boolean compress;
    @UriParam(description="Request that the server modify the response using the <code>_summary</code> param", label="advanced", javaType="java.lang.String")
    private SummaryEnum summary;
    @UriParam(description="HTTP session cookie to add to every request", label="advanced")
    private String sessionCookie;
    @UriParam(description="FhirContext is an expensive object to create. To avoid creating multiple instances, it can be set directly.", label="advanced")
    private FhirContext fhirContext;
    @UriParam(description="Force conformance check", label="advanced")
    private boolean forceConformanceCheck;
    @UriParam(description="When should Camel validate the FHIR Server's conformance statement", defaultValue="ONCE", label="advanced", javaType="java.lang.String")
    private ServerValidationModeEnum validationMode;
    @UriParam(description="When this option is set, model classes will not be scanned for children until the child list for the given type is actually accessed.", defaultValue="false", label="advanced")
    private boolean deferModelScanning;
    @UriParam(description="How long to try and establish the initial TCP connection (in ms)", label="advanced", defaultValue="10000")
    private Integer connectionTimeout;
    @UriParam(description="How long to block for individual read/write operations (in ms)", label="advanced", defaultValue="10000")
    private Integer socketTimeout;
    @UriParam(label="proxy", description="The proxy host")
    private String proxyHost;
    @UriParam(label="proxy", description="The proxy port")
    private Integer proxyPort;
    @UriParam(label="proxy", description="The proxy username", secret=true)
    private String proxyUser;
    @UriParam(label="proxy", description="The proxy password", secret=true)
    private String proxyPassword;
    @UriParam(label="advanced", description="To use the custom client")
    private IGenericClient client;
    @UriParam(label="advanced", description="To use the custom client factory")
    private IRestfulClientFactory clientFactory;

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public FhirVersionEnum getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(String fhirVersion) {
        this.fhirVersion = FhirVersionEnum.valueOf((String)fhirVersion);
    }

    public EncodingEnum getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = EncodingEnum.valueOf((String)encoding);
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public SummaryEnum getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = SummaryEnum.valueOf((String)summary);
    }

    public FhirApiName getApiName() {
        return this.apiName;
    }

    public void setApiName(FhirApiName apiName) {
        this.apiName = apiName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    public void setFhirContext(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
    }

    public boolean isForceConformanceCheck() {
        return this.forceConformanceCheck;
    }

    public void setForceConformanceCheck(boolean forceConformanceCheck) {
        this.forceConformanceCheck = forceConformanceCheck;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        this.log = log;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public String getSessionCookie() {
        return this.sessionCookie;
    }

    public void setSessionCookie(String sessionCookie) {
        this.sessionCookie = sessionCookie;
    }

    public ServerValidationModeEnum getValidationMode() {
        return this.validationMode;
    }

    public void setValidationMode(String validationMode) {
        this.validationMode = ServerValidationModeEnum.valueOf((String)validationMode);
    }

    public boolean isDeferModelScanning() {
        return this.deferModelScanning;
    }

    public void setDeferModelScanning(boolean deferModelScanning) {
        this.deferModelScanning = deferModelScanning;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public IGenericClient getClient() {
        return this.client;
    }

    public void setClient(IGenericClient client) {
        this.client = client;
    }

    public IRestfulClientFactory getClientFactory() {
        return this.clientFactory;
    }

    public void setClientFactory(IRestfulClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    public boolean equals(Object other) {
        if (other instanceof FhirConfiguration) {
            FhirConfiguration otherFhirConfiguration = (FhirConfiguration)other;
            return ObjectHelper.equal((Object)this.prettyPrint, (Object)otherFhirConfiguration.isPrettyPrint()) && ObjectHelper.equal((Object)this.log, (Object)otherFhirConfiguration.isLog()) && ObjectHelper.equal((Object)this.compress, (Object)otherFhirConfiguration.isCompress()) && ObjectHelper.equal((Object)this.forceConformanceCheck, (Object)otherFhirConfiguration.isForceConformanceCheck()) && ObjectHelper.equal((Object)this.fhirVersion, (Object)otherFhirConfiguration.getFhirVersion()) && ObjectHelper.equal((Object)this.deferModelScanning, (Object)otherFhirConfiguration.isDeferModelScanning()) && ObjectHelper.equal((Object)this.encoding, (Object)otherFhirConfiguration.getEncoding()) && ObjectHelper.equal((Object)this.username, (Object)otherFhirConfiguration.getUsername()) && ObjectHelper.equal((Object)this.password, (Object)otherFhirConfiguration.getPassword()) && ObjectHelper.equal((Object)this.accessToken, (Object)otherFhirConfiguration.getAccessToken()) && ObjectHelper.equal((Object)this.summary, (Object)otherFhirConfiguration.getSummary()) && ObjectHelper.equal((Object)this.sessionCookie, (Object)otherFhirConfiguration.getSessionCookie()) && ObjectHelper.equal((Object)this.validationMode, (Object)otherFhirConfiguration.getValidationMode()) && ObjectHelper.equal((Object)this.connectionTimeout, (Object)otherFhirConfiguration.getConnectionTimeout()) && ObjectHelper.equal((Object)this.socketTimeout, (Object)otherFhirConfiguration.getSocketTimeout()) && ObjectHelper.equal((Object)this.proxyHost, (Object)otherFhirConfiguration.getProxyHost()) && ObjectHelper.equal((Object)this.proxyPort, (Object)otherFhirConfiguration.getProxyPort()) && ObjectHelper.equal((Object)this.proxyUser, (Object)otherFhirConfiguration.getProxyUser()) && ObjectHelper.equal((Object)this.proxyPassword, (Object)otherFhirConfiguration.getProxyPassword()) && ObjectHelper.equal((Object)this.client, (Object)otherFhirConfiguration.getClient()) && ObjectHelper.equal((Object)this.clientFactory, (Object)otherFhirConfiguration.getClientFactory()) && ObjectHelper.equal((Object)this.serverUrl, (Object)otherFhirConfiguration.getServerUrl());
        }
        return false;
    }

    public int hashCode() {
        int result = this.serverUrl != null ? this.serverUrl.hashCode() : 0;
        result = 31 * result + (this.fhirVersion != null ? this.fhirVersion.hashCode() : 0);
        result = 31 * result + (this.prettyPrint ? 1 : 0);
        result = 31 * result + (this.encoding != null ? this.encoding.hashCode() : 0);
        result = 31 * result + (this.username != null ? this.username.hashCode() : 0);
        result = 31 * result + (this.password != null ? this.password.hashCode() : 0);
        result = 31 * result + (this.accessToken != null ? this.accessToken.hashCode() : 0);
        result = 31 * result + (this.log ? 1 : 0);
        result = 31 * result + (this.compress ? 1 : 0);
        result = 31 * result + (this.summary != null ? this.summary.hashCode() : 0);
        result = 31 * result + (this.sessionCookie != null ? this.sessionCookie.hashCode() : 0);
        result = 31 * result + (this.forceConformanceCheck ? 1 : 0);
        result = 31 * result + (this.validationMode != null ? this.validationMode.hashCode() : 0);
        result = 31 * result + (this.deferModelScanning ? 1 : 0);
        result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
        result = 31 * result + (this.socketTimeout != null ? this.socketTimeout.hashCode() : 0);
        result = 31 * result + (this.proxyHost != null ? this.proxyHost.hashCode() : 0);
        result = 31 * result + (this.proxyPort != null ? this.proxyPort.hashCode() : 0);
        result = 31 * result + (this.proxyUser != null ? this.proxyUser.hashCode() : 0);
        result = 31 * result + (this.proxyPassword != null ? this.proxyPassword.hashCode() : 0);
        return result;
    }
}

