/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.arangodb;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.arangodb.ArangoDbComponent;
import org.apache.camel.component.arangodb.ArangoDbConfiguration;
import org.apache.camel.component.arangodb.ArangoDbOperation;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class ArangoDbComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    private ArangoDbConfiguration getOrCreateConfiguration(ArangoDbComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new ArangoDbConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ArangoDbComponent target = (ArangoDbComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)ArangoDbComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((ArangoDbConfiguration)ArangoDbComponentConfigurer.property((CamelContext)camelContext, ArangoDbConfiguration.class, (Object)value));
                return true;
            }
            case "documentcollection": 
            case "documentCollection": {
                this.getOrCreateConfiguration(target).setDocumentCollection((String)ArangoDbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "edgecollection": 
            case "edgeCollection": {
                this.getOrCreateConfiguration(target).setEdgeCollection((String)ArangoDbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "graph": {
                this.getOrCreateConfiguration(target).setGraph((String)ArangoDbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "host": {
                this.getOrCreateConfiguration(target).setHost((String)ArangoDbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)ArangoDbComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((ArangoDbOperation)((Object)ArangoDbComponentConfigurer.property((CamelContext)camelContext, ArangoDbOperation.class, (Object)value)));
                return true;
            }
            case "password": {
                this.getOrCreateConfiguration(target).setPassword((String)ArangoDbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "port": {
                this.getOrCreateConfiguration(target).setPort((Integer)ArangoDbComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "user": {
                this.getOrCreateConfiguration(target).setUser((String)ArangoDbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "vertexcollection": 
            case "vertexCollection": {
                this.getOrCreateConfiguration(target).setVertexCollection((String)ArangoDbComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ArangoDbComponent target = (ArangoDbComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "documentcollection": 
            case "documentCollection": {
                return this.getOrCreateConfiguration(target).getDocumentCollection();
            }
            case "edgecollection": 
            case "edgeCollection": {
                return this.getOrCreateConfiguration(target).getEdgeCollection();
            }
            case "graph": {
                return this.getOrCreateConfiguration(target).getGraph();
            }
            case "host": {
                return this.getOrCreateConfiguration(target).getHost();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "password": {
                return this.getOrCreateConfiguration(target).getPassword();
            }
            case "port": {
                return this.getOrCreateConfiguration(target).getPort();
            }
            case "user": {
                return this.getOrCreateConfiguration(target).getUser();
            }
            case "vertexcollection": 
            case "vertexCollection": {
                return this.getOrCreateConfiguration(target).getVertexCollection();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("configuration", ArangoDbConfiguration.class);
        map.put("documentCollection", String.class);
        map.put("edgeCollection", String.class);
        map.put("graph", String.class);
        map.put("host", String.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("operation", ArangoDbOperation.class);
        map.put("port", Integer.TYPE);
        map.put("vertexCollection", String.class);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("password", String.class);
        map.put("user", String.class);
        ALL_OPTIONS = map;
    }
}

