/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo2;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Olingo2EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":apiName/methodName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "olingo2".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "apiName", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "methodName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(44);
        props.add("basicPropertyBinding");
        props.add("backoffMultiplier");
        props.add("apiName");
        props.add("data");
        props.add("serviceUri");
        props.add("queryParams");
        props.add("synchronous");
        props.add("resourcePath");
        props.add("sslContextParameters");
        props.add("splitResult");
        props.add("httpHeaders");
        props.add("initialDelay");
        props.add("scheduler");
        props.add("entityProviderWriteProperties");
        props.add("bridgeErrorHandler");
        props.add("useFixedDelay");
        props.add("responseHandler");
        props.add("runLoggingLevel");
        props.add("httpAsyncClientBuilder");
        props.add("backoffErrorThreshold");
        props.add("httpClientBuilder");
        props.add("connectTimeout");
        props.add("socketTimeout");
        props.add("greedy");
        props.add("scheduledExecutorService");
        props.add("contentType");
        props.add("repeatCount");
        props.add("timeUnit");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("exchangePattern");
        props.add("methodName");
        props.add("backoffIdleThreshold");
        props.add("edm");
        props.add("endpointHttpHeaders");
        props.add("entityProviderReadProperties");
        props.add("proxy");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("pollStrategy");
        props.add("filterAlreadySeen");
        props.add("startScheduler");
        props.add("inBody");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

