/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.telegram.model;

import java.util.Arrays;
import java.util.Objects;
import org.apache.camel.component.telegram.model.OutgoingMessage;

public final class OutgoingStickerMessage
extends OutgoingMessage {
    private static final long serialVersionUID = 5118405983382009364L;
    private String sticker;
    private byte[] stickerImage;
    private String filenameWithExtension;

    private OutgoingStickerMessage(String sticker, byte[] stickerImage, String filenameWithExtension, String chatId, Boolean disableNotification, Long replyToMessageId) {
        this.sticker = sticker;
        this.stickerImage = stickerImage;
        this.filenameWithExtension = filenameWithExtension;
        this.chatId = chatId;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
    }

    public static OutgoingStickerMessage createWithImage(byte[] image, String filenameWithExtension, String chatId, Boolean disableNotification, Long replyToMessageId) {
        Objects.requireNonNull(image);
        Objects.requireNonNull(filenameWithExtension);
        return new OutgoingStickerMessage(null, image, filenameWithExtension, chatId, disableNotification, replyToMessageId);
    }

    public static OutgoingStickerMessage createWithUrl(String url, String chatId, Boolean disableNotification, Long replyToMessageId) {
        Objects.requireNonNull(url);
        return OutgoingStickerMessage.createWithFileId(url, chatId, disableNotification, replyToMessageId);
    }

    public static OutgoingStickerMessage createWithFileId(String fileId, String chatId, Boolean disableNotification, Long replyToMessageId) {
        Objects.requireNonNull(fileId);
        return new OutgoingStickerMessage(fileId, null, null, chatId, disableNotification, replyToMessageId);
    }

    public String getSticker() {
        return this.sticker;
    }

    public byte[] getStickerImage() {
        return this.stickerImage;
    }

    public String getFilenameWithExtension() {
        return this.filenameWithExtension;
    }

    @Override
    public String toString() {
        return "OutgoingStickerMessage{sticker='" + this.sticker + '\'' + ", stickerImage=" + Arrays.toString(this.stickerImage) + ", filenameWithExtension='" + this.filenameWithExtension + '\'' + ", chatId='" + this.chatId + '\'' + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + '}';
    }
}

