/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.soroushbot.component;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SoroushBotEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":action";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "soroush".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "action", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(23);
        props.add("basicPropertyBinding");
        props.add("retryWaitingTime");
        props.add("queueCapacityPerThread");
        props.add("backOffStrategy");
        props.add("retryExponentialCoefficient");
        props.add("synchronous");
        props.add("maxConnectionRetry");
        props.add("exchangePattern");
        props.add("autoDownload");
        props.add("reconnectIdleConnectionTimeout");
        props.add("retryLinearIncrement");
        props.add("concurrentConsumers");
        props.add("autoUploadFile");
        props.add("downloadThumbnail");
        props.add("forceUpload");
        props.add("authorizationToken");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("action");
        props.add("connectionTimeout");
        props.add("exceptionHandler");
        props.add("forceDownload");
        props.add("maxRetryWaitingTime");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(1);
        secretProps.add("authorizationToken");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

