/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.calendar;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class GoogleCalendarEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":apiName/methodName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "google-calendar".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "apiName", null, true, copy);
        uri = this.buildPathParameter(syntax, uri, "methodName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(42);
        props.add("basicPropertyBinding");
        props.add("backoffMultiplier");
        props.add("apiName");
        props.add("synchronous");
        props.add("destination");
        props.add("initialDelay");
        props.add("content");
        props.add("setting");
        props.add("scheduler");
        props.add("emailAddress");
        props.add("bridgeErrorHandler");
        props.add("useFixedDelay");
        props.add("runLoggingLevel");
        props.add("backoffErrorThreshold");
        props.add("greedy");
        props.add("clientSecret");
        props.add("text");
        props.add("scheduledExecutorService");
        props.add("ruleId");
        props.add("applicationName");
        props.add("repeatCount");
        props.add("timeUnit");
        props.add("eventId");
        props.add("p12FileName");
        props.add("clientId");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("exchangePattern");
        props.add("methodName");
        props.add("accessToken");
        props.add("backoffIdleThreshold");
        props.add("lazyStartProducer");
        props.add("contentChannel");
        props.add("delay");
        props.add("pollStrategy");
        props.add("calendarId");
        props.add("startScheduler");
        props.add("scopes");
        props.add("inBody");
        props.add("user");
        props.add("exceptionHandler");
        props.add("refreshToken");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(3);
        secretProps.add("clientSecret");
        secretProps.add("accessToken");
        secretProps.add("refreshToken");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

