/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class SalesforceEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":operationName:topicName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "salesforce".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "operationName", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "topicName", null, false, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(47);
        props.add("initialReplayIdMap");
        props.add("basicPropertyBinding");
        props.add("notifyForOperations");
        props.add("synchronous");
        props.add("sObjectQuery");
        props.add("notifyForOperationCreate");
        props.add("batchId");
        props.add("notifyForOperationUndelete");
        props.add("sObjectClass");
        props.add("apexUrl");
        props.add("apexMethod");
        props.add("updateTopic");
        props.add("apiVersion");
        props.add("instanceId");
        props.add("bridgeErrorHandler");
        props.add("notifyForFields");
        props.add("sObjectIdValue");
        props.add("reportMetadata");
        props.add("limit");
        props.add("apexQueryParams");
        props.add("contentType");
        props.add("includeDetails");
        props.add("sObjectFields");
        props.add("sObjectName");
        props.add("httpClient");
        props.add("sObjectBlobFieldName");
        props.add("backoffIncrement");
        props.add("maxBackoff");
        props.add("rawPayload");
        props.add("reportId");
        props.add("resultId");
        props.add("format");
        props.add("exchangePattern");
        props.add("operationName");
        props.add("sObjectId");
        props.add("defaultReplayId");
        props.add("jobId");
        props.add("notFoundBehaviour");
        props.add("lazyStartProducer");
        props.add("objectMapper");
        props.add("sObjectSearch");
        props.add("notifyForOperationUpdate");
        props.add("topicName");
        props.add("sObjectIdName");
        props.add("replayId");
        props.add("exceptionHandler");
        props.add("notifyForOperationDelete");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

