/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms2;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class Sjms2EndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":destinationType:destinationName";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "sjms2".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "destinationType", "queue", false, copy);
        uri = this.buildPathParameter(syntax, uri, "destinationName", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(43);
        props.add("basicPropertyBinding");
        props.add("shared");
        props.add("reconnectBackOff");
        props.add("connectionCount");
        props.add("mapJmsMessage");
        props.add("synchronous");
        props.add("connectionResource");
        props.add("includeAllJMSXProperties");
        props.add("transacted");
        props.add("errorHandlerLogStackTrace");
        props.add("durable");
        props.add("bridgeErrorHandler");
        props.add("transactionBatchCount");
        props.add("jmsKeyFormatStrategy");
        props.add("headerFilterStrategy");
        props.add("exceptionListener");
        props.add("destinationName");
        props.add("messageCreatedStrategy");
        props.add("asyncStopListener");
        props.add("destinationType");
        props.add("asyncStartListener");
        props.add("persistent");
        props.add("allowNullBody");
        props.add("namedReplyTo");
        props.add("reconnectOnError");
        props.add("consumerCount");
        props.add("destinationCreationStrategy");
        props.add("exchangePattern");
        props.add("prefillPool");
        props.add("messageSelector");
        props.add("ttl");
        props.add("acknowledgementMode");
        props.add("transactionBatchTimeout");
        props.add("lazyStartProducer");
        props.add("transactionCommitStrategy");
        props.add("connectionFactory");
        props.add("producerCount");
        props.add("errorHandlerLoggingLevel");
        props.add("sharedJMSSession");
        props.add("durableSubscriptionId");
        props.add("subscriptionId");
        props.add("exceptionHandler");
        props.add("responseTimeOut");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

