/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paho;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class PahoEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":topic";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "paho".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "topic", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(34);
        props.add("serverURIs");
        props.add("basicPropertyBinding");
        props.add("customWebSocketHeaders");
        props.add("maxInflight");
        props.add("synchronous");
        props.add("automaticReconnect");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("sslClientProps");
        props.add("qos");
        props.add("willTopic");
        props.add("mqttVersion");
        props.add("filePersistenceDirectory");
        props.add("client");
        props.add("connectionTimeout");
        props.add("executorServiceTimeout");
        props.add("httpsHostnameVerificationEnabled");
        props.add("clientId");
        props.add("socketFactory");
        props.add("exchangePattern");
        props.add("userName");
        props.add("cleanSession");
        props.add("keepAliveInterval");
        props.add("maxReconnectDelay");
        props.add("brokerUrl");
        props.add("retained");
        props.add("lazyStartProducer");
        props.add("willQos");
        props.add("sslHostnameVerifier");
        props.add("topic");
        props.add("persistence");
        props.add("willPayload");
        props.add("willRetained");
        props.add("exceptionHandler");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("userName");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

