/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty.http;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.netty.ClientInitializerFactory;
import org.apache.camel.component.netty.NettyCamelStateCorrelationManager;
import org.apache.camel.component.netty.NettyComponentConfigurer;
import org.apache.camel.component.netty.NettyConfiguration;
import org.apache.camel.component.netty.NettyServerBootstrapFactory;
import org.apache.camel.component.netty.ServerInitializerFactory;
import org.apache.camel.component.netty.TextLineDelimiter;
import org.apache.camel.component.netty.http.NettyHttpBinding;
import org.apache.camel.component.netty.http.NettyHttpComponent;
import org.apache.camel.component.netty.http.NettyHttpSecurityConfiguration;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.CaseInsensitiveMap;

public class NettyHttpComponentConfigurer
extends NettyComponentConfigurer
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        NettyHttpComponent target = (NettyHttpComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                target.setHeaderFilterStrategy((HeaderFilterStrategy)NettyHttpComponentConfigurer.property((CamelContext)camelContext, HeaderFilterStrategy.class, (Object)value));
                return true;
            }
            case "nettyhttpbinding": 
            case "nettyHttpBinding": {
                target.setNettyHttpBinding((NettyHttpBinding)NettyHttpComponentConfigurer.property((CamelContext)camelContext, NettyHttpBinding.class, (Object)value));
                return true;
            }
            case "securityconfiguration": 
            case "securityConfiguration": {
                target.setSecurityConfiguration((NettyHttpSecurityConfiguration)NettyHttpComponentConfigurer.property((CamelContext)camelContext, NettyHttpSecurityConfiguration.class, (Object)value));
                return true;
            }
        }
        return super.configure(camelContext, obj, name, value, ignoreCase);
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        NettyHttpComponent target = (NettyHttpComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "headerfilterstrategy": 
            case "headerFilterStrategy": {
                return target.getHeaderFilterStrategy();
            }
            case "nettyhttpbinding": 
            case "nettyHttpBinding": {
                return target.getNettyHttpBinding();
            }
            case "securityconfiguration": 
            case "securityConfiguration": {
                return target.getSecurityConfiguration();
            }
        }
        return super.getOptionValue(obj, name, ignoreCase);
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("configuration", NettyConfiguration.class);
        map.put("disconnect", Boolean.TYPE);
        map.put("keepAlive", Boolean.TYPE);
        map.put("reuseAddress", Boolean.TYPE);
        map.put("reuseChannel", Boolean.TYPE);
        map.put("sync", Boolean.TYPE);
        map.put("tcpNoDelay", Boolean.TYPE);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("broadcast", Boolean.TYPE);
        map.put("clientMode", Boolean.TYPE);
        map.put("reconnect", Boolean.TYPE);
        map.put("reconnectInterval", Integer.TYPE);
        map.put("backlog", Integer.TYPE);
        map.put("bossCount", Integer.TYPE);
        map.put("bossGroup", EventLoopGroup.class);
        map.put("disconnectOnNoReply", Boolean.TYPE);
        map.put("executorService", EventExecutorGroup.class);
        map.put("maximumPoolSize", Integer.TYPE);
        map.put("nettyServerBootstrapFactory", NettyServerBootstrapFactory.class);
        map.put("networkInterface", String.class);
        map.put("noReplyLogLevel", LoggingLevel.class);
        map.put("serverClosedChannelExceptionCaughtLogLevel", LoggingLevel.class);
        map.put("serverExceptionCaughtLogLevel", LoggingLevel.class);
        map.put("serverInitializerFactory", ServerInitializerFactory.class);
        map.put("usingExecutorService", Boolean.TYPE);
        map.put("connectTimeout", Integer.TYPE);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("requestTimeout", Long.TYPE);
        map.put("clientInitializerFactory", ClientInitializerFactory.class);
        map.put("correlationManager", NettyCamelStateCorrelationManager.class);
        map.put("lazyChannelCreation", Boolean.TYPE);
        map.put("producerPoolEnabled", Boolean.TYPE);
        map.put("producerPoolMaxActive", Integer.TYPE);
        map.put("producerPoolMaxIdle", Integer.TYPE);
        map.put("producerPoolMinEvictableIdle", Long.TYPE);
        map.put("producerPoolMinIdle", Integer.TYPE);
        map.put("udpConnectionlessSending", Boolean.TYPE);
        map.put("useByteBuf", Boolean.TYPE);
        map.put("allowSerializedHeaders", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("channelGroup", ChannelGroup.class);
        map.put("headerFilterStrategy", HeaderFilterStrategy.class);
        map.put("nativeTransport", Boolean.TYPE);
        map.put("nettyHttpBinding", NettyHttpBinding.class);
        map.put("options", Map.class);
        map.put("receiveBufferSize", Integer.TYPE);
        map.put("receiveBufferSizePredictor", Integer.TYPE);
        map.put("sendBufferSize", Integer.TYPE);
        map.put("transferExchange", Boolean.TYPE);
        map.put("udpByteArrayCodec", Boolean.TYPE);
        map.put("workerCount", Integer.TYPE);
        map.put("workerGroup", EventLoopGroup.class);
        map.put("allowDefaultCodec", Boolean.TYPE);
        map.put("autoAppendDelimiter", Boolean.TYPE);
        map.put("decoderMaxLineLength", Integer.TYPE);
        map.put("decoders", List.class);
        map.put("delimiter", TextLineDelimiter.class);
        map.put("encoders", List.class);
        map.put("encoding", String.class);
        map.put("textline", Boolean.TYPE);
        map.put("enabledProtocols", String.class);
        map.put("keyStoreFile", File.class);
        map.put("keyStoreFormat", String.class);
        map.put("keyStoreResource", String.class);
        map.put("needClientAuth", Boolean.TYPE);
        map.put("passphrase", String.class);
        map.put("securityConfiguration", NettyHttpSecurityConfiguration.class);
        map.put("securityProvider", String.class);
        map.put("ssl", Boolean.TYPE);
        map.put("sslClientCertHeaders", Boolean.TYPE);
        map.put("sslContextParameters", SSLContextParameters.class);
        map.put("sslHandler", SslHandler.class);
        map.put("trustStoreFile", File.class);
        map.put("trustStoreResource", String.class);
        map.put("useGlobalSslContextParameters", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

