/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.redis;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.component.redis.Command;
import org.apache.camel.component.redis.RedisEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.serializer.RedisSerializer;

public class RedisEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private static final Map<String, Object> ALL_OPTIONS;

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        RedisEndpoint target = (RedisEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "channels": {
                target.getConfiguration().setChannels((String)RedisEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "command": {
                target.getConfiguration().setCommand((Command)((Object)RedisEndpointConfigurer.property((CamelContext)camelContext, Command.class, (Object)value)));
                return true;
            }
            case "connectionfactory": 
            case "connectionFactory": {
                target.getConfiguration().setConnectionFactory((RedisConnectionFactory)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisConnectionFactory.class, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)RedisEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)RedisEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "listenercontainer": 
            case "listenerContainer": {
                target.getConfiguration().setListenerContainer((RedisMessageListenerContainer)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisMessageListenerContainer.class, (Object)value));
                return true;
            }
            case "redistemplate": 
            case "redisTemplate": {
                target.getConfiguration().setRedisTemplate((RedisTemplate)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisTemplate.class, (Object)value));
                return true;
            }
            case "serializer": {
                target.getConfiguration().setSerializer((RedisSerializer)RedisEndpointConfigurer.property((CamelContext)camelContext, RedisSerializer.class, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)RedisEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        return ALL_OPTIONS;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        RedisEndpoint target = (RedisEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "channels": {
                return target.getConfiguration().getChannels();
            }
            case "command": {
                return target.getConfiguration().getCommand();
            }
            case "connectionfactory": 
            case "connectionFactory": {
                return target.getConfiguration().getConnectionFactory();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "listenercontainer": 
            case "listenerContainer": {
                return target.getConfiguration().getListenerContainer();
            }
            case "redistemplate": 
            case "redisTemplate": {
                return target.getConfiguration().getRedisTemplate();
            }
            case "serializer": {
                return target.getConfiguration().getSerializer();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
        }
        return null;
    }

    static {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        map.put("host", String.class);
        map.put("port", Integer.class);
        map.put("channels", String.class);
        map.put("command", Command.class);
        map.put("connectionFactory", RedisConnectionFactory.class);
        map.put("redisTemplate", RedisTemplate.class);
        map.put("serializer", RedisSerializer.class);
        map.put("bridgeErrorHandler", Boolean.TYPE);
        map.put("exceptionHandler", ExceptionHandler.class);
        map.put("exchangePattern", ExchangePattern.class);
        map.put("listenerContainer", RedisMessageListenerContainer.class);
        map.put("lazyStartProducer", Boolean.TYPE);
        map.put("basicPropertyBinding", Boolean.TYPE);
        map.put("synchronous", Boolean.TYPE);
        ALL_OPTIONS = map;
    }
}

