/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.google.pubsub.GooglePubsubComponent;

/**
 * Send and receive messages to/from Google Cloud Platform PubSub Service.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface GooglePubsubComponentBuilderFactory {

    /**
     * Google Pubsub (camel-google-pubsub)
     * Send and receive messages to/from Google Cloud Platform PubSub Service.
     * 
     * Category: cloud,messaging
     * Since: 2.19
     * Maven coordinates: org.apache.camel:camel-google-pubsub
     */
    static GooglePubsubComponentBuilder googlePubsub() {
        return new GooglePubsubComponentBuilderImpl();
    }

    /**
     * Builder for the Google Pubsub component.
     */
    interface GooglePubsubComponentBuilder
            extends
                ComponentBuilder<GooglePubsubComponent> {
        /**
         * Endpoint to use with local Pub/Sub emulator.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         */
        default GooglePubsubComponentBuilder endpoint(java.lang.String endpoint) {
            doSetProperty("endpoint", endpoint);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: consumer
         */
        default GooglePubsubComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer
         */
        default GooglePubsubComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Maximum number of producers to cache. This could be increased if you
         * have producers for lots of different topics.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default GooglePubsubComponentBuilder publisherCacheSize(
                int publisherCacheSize) {
            doSetProperty("publisherCacheSize", publisherCacheSize);
            return this;
        }
        /**
         * How many milliseconds should each producer stay alive in the cache.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: producer
         */
        default GooglePubsubComponentBuilder publisherCacheTimeout(
                int publisherCacheTimeout) {
            doSetProperty("publisherCacheTimeout", publisherCacheTimeout);
            return this;
        }
        /**
         * Whether the component should use basic property binding (Camel 2.x)
         * or the newer property binding with additional capabilities.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: advanced
         */
        @Deprecated
        default GooglePubsubComponentBuilder basicPropertyBinding(
                boolean basicPropertyBinding) {
            doSetProperty("basicPropertyBinding", basicPropertyBinding);
            return this;
        }
        /**
         * How many milliseconds should a producer be allowed to terminate.
         * 
         * The option is a: <code>int</code> type.
         * 
         * Group: advanced
         */
        default GooglePubsubComponentBuilder publisherTerminationTimeout(
                int publisherTerminationTimeout) {
            doSetProperty("publisherTerminationTimeout", publisherTerminationTimeout);
            return this;
        }
    }

    class GooglePubsubComponentBuilderImpl
            extends
                AbstractComponentBuilder<GooglePubsubComponent>
            implements
                GooglePubsubComponentBuilder {
        @Override
        protected GooglePubsubComponent buildConcreteComponent() {
            return new GooglePubsubComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "endpoint": ((GooglePubsubComponent) component).setEndpoint((java.lang.String) value); return true;
            case "bridgeErrorHandler": ((GooglePubsubComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "lazyStartProducer": ((GooglePubsubComponent) component).setLazyStartProducer((boolean) value); return true;
            case "publisherCacheSize": ((GooglePubsubComponent) component).setPublisherCacheSize((int) value); return true;
            case "publisherCacheTimeout": ((GooglePubsubComponent) component).setPublisherCacheTimeout((int) value); return true;
            case "basicPropertyBinding": ((GooglePubsubComponent) component).setBasicPropertyBinding((boolean) value); return true;
            case "publisherTerminationTimeout": ((GooglePubsubComponent) component).setPublisherTerminationTimeout((int) value); return true;
            default: return false;
            }
        }
    }
}