
/*
 * Camel EndpointConfiguration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.twilio;

import org.apache.camel.spi.Configurer;
import org.apache.camel.spi.ApiMethod;
import org.apache.camel.spi.ApiParam;
import org.apache.camel.spi.ApiParams;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

/**
 * Camel endpoint configuration for {@link com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddress}.
 */
@ApiParams(apiName = "sip-ip-access-control-list-ip-address", 
           description = "",
           apiMethods = {@ApiMethod(methodName = "creator", description="Create a IpAddressCreator to execute create", signatures={"com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressCreator creator(String pathIpAccessControlListSid, String friendlyName, String ipAddress)", "com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressCreator creator(String pathAccountSid, String pathIpAccessControlListSid, String friendlyName, String ipAddress)"}), @ApiMethod(methodName = "deleter", description="Create a IpAddressDeleter to execute delete", signatures={"com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressDeleter deleter(String pathIpAccessControlListSid, String pathSid)", "com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressDeleter deleter(String pathAccountSid, String pathIpAccessControlListSid, String pathSid)"}), @ApiMethod(methodName = "fetcher", description="Create a IpAddressFetcher to execute fetch", signatures={"com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressFetcher fetcher(String pathIpAccessControlListSid, String pathSid)", "com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressFetcher fetcher(String pathAccountSid, String pathIpAccessControlListSid, String pathSid)"}), @ApiMethod(methodName = "reader", description="Create a IpAddressReader to execute read", signatures={"com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressReader reader(String pathIpAccessControlListSid)", "com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressReader reader(String pathAccountSid, String pathIpAccessControlListSid)"}), @ApiMethod(methodName = "updater", description="Create a IpAddressUpdater to execute update", signatures={"com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressUpdater updater(String pathIpAccessControlListSid, String pathSid)", "com.twilio.rest.api.v2010.account.sip.ipaccesscontrollist.IpAddressUpdater updater(String pathAccountSid, String pathIpAccessControlListSid, String pathSid)"}), }, aliases = {"^creator$=create", "^deleter$=delete", "^fetcher$=fetch", "^reader$=read", "^updater$=update"})
@UriParams
@Configurer
public final class SipIpAccessControlListIpAddressEndpointConfiguration extends TwilioConfiguration {
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "creator", description="A human readable descriptive text for this resource, up to 64 characters long.")})
    private String friendlyName;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "creator", description="An IP address in dotted decimal notation from which you want to accept traffic. Any SIP requests from this IP address will be allowed by Twilio. IPv4 only supported today.")})
    private String ipAddress;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "creator", description="The unique sid that identifies this account"), @ApiMethod(methodName = "deleter", description="The unique sid that identifies this account"), @ApiMethod(methodName = "fetcher", description="The unique sid that identifies this account"), @ApiMethod(methodName = "reader", description="The unique sid that identifies this account"), @ApiMethod(methodName = "updater", description="The unique sid that identifies this account")})
    private String pathAccountSid;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "creator", description="The IpAccessControlList Sid with which to associate the created IpAddress resource"), @ApiMethod(methodName = "creator", description="The IpAccessControlList Sid with which to associate the created IpAddress resource"), @ApiMethod(methodName = "deleter", description="The IpAccessControlList Sid that identifies the IpAddress resources to delete"), @ApiMethod(methodName = "deleter", description="The IpAccessControlList Sid with which to associate the created IpAddress resource"), @ApiMethod(methodName = "fetcher", description="The IpAccessControlList Sid that identifies the IpAddress resources to fetch"), @ApiMethod(methodName = "fetcher", description="The IpAccessControlList Sid with which to associate the created IpAddress resource"), @ApiMethod(methodName = "reader", description="The IpAccessControlList Sid that identifies the IpAddress resources to read"), @ApiMethod(methodName = "reader", description="The IpAccessControlList Sid with which to associate the created IpAddress resource"), @ApiMethod(methodName = "updater", description="The IpAccessControlList Sid that identifies the IpAddress resources to update"), @ApiMethod(methodName = "updater", description="The IpAccessControlList Sid with which to associate the created IpAddress resource")})
    private String pathIpAccessControlListSid;
    @UriParam
    @ApiParam(optional = false, apiMethods = {@ApiMethod(methodName = "deleter", description="A string that identifies the resource to delete"), @ApiMethod(methodName = "fetcher", description="A string that identifies the IpAddress resource to fetch"), @ApiMethod(methodName = "updater", description="A string that identifies the IpAddress resource to update")})
    private String pathSid;

    public String getFriendlyName() {
        return friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getPathAccountSid() {
        return pathAccountSid;
    }

    public void setPathAccountSid(String pathAccountSid) {
        this.pathAccountSid = pathAccountSid;
    }

    public String getPathIpAccessControlListSid() {
        return pathIpAccessControlListSid;
    }

    public void setPathIpAccessControlListSid(String pathIpAccessControlListSid) {
        this.pathIpAccessControlListSid = pathIpAccessControlListSid;
    }

    public String getPathSid() {
        return pathSid;
    }

    public void setPathSid(String pathSid) {
        this.pathSid = pathSid;
    }
}
