/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ses;

import java.net.URI;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws2.ses.Ses2Configuration;
import org.apache.camel.component.aws2.ses.Ses2Producer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.ObjectHelper;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.SdkHttpConfigurationOption;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.SesClientBuilder;
import software.amazon.awssdk.utils.AttributeMap;

@UriEndpoint(firstVersion="3.1.0", scheme="aws2-ses", title="AWS 2 Simple Email Service (SES)", syntax="aws2-ses:from", producerOnly=true, category={Category.CLOUD, Category.MAIL})
public class Ses2Endpoint
extends DefaultEndpoint {
    private SesClient sesClient;
    @UriParam
    private Ses2Configuration configuration;

    public Ses2Endpoint(String uri, Component component, Ses2Configuration configuration) {
        super(uri, component);
        this.configuration = configuration;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.sesClient = this.configuration.getAmazonSESClient() != null ? this.configuration.getAmazonSESClient() : this.createSESClient();
    }

    public void doStop() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.configuration.getAmazonSESClient()) && this.sesClient != null) {
            this.sesClient.close();
        }
        super.doStop();
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot receive messages from this endpoint");
    }

    public Producer createProducer() throws Exception {
        return new Ses2Producer((Endpoint)this);
    }

    public Ses2Configuration getConfiguration() {
        return this.configuration;
    }

    public SesClient getSESClient() {
        return this.sesClient;
    }

    private SesClient createSESClient() {
        SesClient client = null;
        SesClientBuilder clientBuilder = SesClient.builder();
        ProxyConfiguration.Builder proxyConfig = null;
        ApacheHttpClient.Builder httpClientBuilder = null;
        boolean isClientConfigFound = false;
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyHost()) && ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
            proxyConfig = ProxyConfiguration.builder();
            URI proxyEndpoint = URI.create(this.configuration.getProxyProtocol() + "://" + this.configuration.getProxyHost() + ":" + this.configuration.getProxyPort());
            proxyConfig.endpoint(proxyEndpoint);
            httpClientBuilder = ApacheHttpClient.builder().proxyConfiguration((ProxyConfiguration)proxyConfig.build());
            isClientConfigFound = true;
        }
        if (this.configuration.getAccessKey() != null && this.configuration.getSecretKey() != null) {
            AwsBasicCredentials cred = AwsBasicCredentials.create((String)this.configuration.getAccessKey(), (String)this.configuration.getSecretKey());
            clientBuilder = isClientConfigFound ? (SesClientBuilder)((SesClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder)).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred)) : (SesClientBuilder)clientBuilder.credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)cred));
        } else if (!isClientConfigFound) {
            clientBuilder = (SesClientBuilder)clientBuilder.httpClientBuilder(httpClientBuilder);
        }
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
            clientBuilder = (SesClientBuilder)clientBuilder.region(Region.of((String)this.configuration.getRegion()));
        }
        if (this.configuration.isTrustAllCertificates()) {
            SdkHttpClient ahc = ApacheHttpClient.builder().buildWithDefaults(AttributeMap.builder().put((AttributeMap.Key)SdkHttpConfigurationOption.TRUST_ALL_CERTIFICATES, (Object)Boolean.TRUE).build());
            clientBuilder.httpClient(ahc);
        }
        client = (SesClient)clientBuilder.build();
        return client;
    }
}

