/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jbpm.workitem;

import java.util.HashMap;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.builder.ExchangeBuilder;
import org.apache.camel.component.jbpm.workitem.AbstractCamelWorkItemHandler;
import org.drools.core.process.instance.impl.WorkItemImpl;
import org.jbpm.process.workitem.core.util.Wid;
import org.jbpm.process.workitem.core.util.WidMavenDepends;
import org.jbpm.process.workitem.core.util.WidParameter;
import org.jbpm.process.workitem.core.util.WidResult;
import org.jbpm.process.workitem.core.util.service.WidAction;
import org.jbpm.process.workitem.core.util.service.WidService;
import org.kie.api.runtime.manager.RuntimeManager;
import org.kie.api.runtime.process.WorkItem;
import org.kie.api.runtime.process.WorkItemManager;

@Wid(widfile="InOutCamelConnector.wid", name="InOutCamelConnector", displayName="InOutCamelConnector", category="Camel", defaultHandler="mvel: new org.apache.camel.component.jbpm.workitem.InOutCamelWorkItemHandler()", documentation="camel-jbpm/index.html", parameters={@WidParameter(name="CamelEndpointId")}, results={@WidResult(name="Response"), @WidResult(name="Message")}, mavenDepends={@WidMavenDepends(group="org.apache.camel", artifact="camel-jbpm", version="3.5.0")}, serviceInfo=@WidService(category="Camel :: JBPM", description="Camel JBPM support", keywords="apache,camel,payload,route,connector", action=@WidAction(title="Send payload to a Camel endpoint")), icon="InOutCamelConnector.png")
public class InOutCamelWorkItemHandler
extends AbstractCamelWorkItemHandler {
    public InOutCamelWorkItemHandler() {
    }

    public InOutCamelWorkItemHandler(String camelEndpointId) {
        super(camelEndpointId);
    }

    public InOutCamelWorkItemHandler(RuntimeManager runtimeManager) {
        super(runtimeManager);
    }

    public InOutCamelWorkItemHandler(RuntimeManager runtimeManager, String camelEndpointId) {
        super(runtimeManager, camelEndpointId);
    }

    @Override
    protected void handleResponse(Exchange responseExchange, WorkItem workItem, WorkItemManager manager) {
        Message outMessage = responseExchange.getOut();
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object response = outMessage.getBody();
        result.put("Response", response);
        result.put("Message", outMessage);
        manager.completeWorkItem(workItem.getId(), result);
    }

    @Override
    protected Exchange buildExchange(ProducerTemplate template, WorkItem workItem) {
        return ExchangeBuilder.anExchange((CamelContext)template.getCamelContext()).withPattern(ExchangePattern.InOut).withHeader("deploymentId", (Object)((WorkItemImpl)workItem).getDeploymentId()).withHeader("processInstanceId", (Object)workItem.getProcessInstanceId()).withHeader("workItemId", (Object)workItem.getId()).withBody((Object)workItem).build();
    }
}

