/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.freemarker;

import freemarker.cache.CacheStorage;
import freemarker.cache.NullCacheStorage;
import freemarker.cache.TemplateLoader;
import freemarker.cache.URLTemplateLoader;
import freemarker.template.Configuration;
import java.net.URL;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.freemarker.FreemarkerEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.ObjectHelper;

@org.apache.camel.spi.annotations.Component(value="freemarker")
public class FreemarkerComponent
extends DefaultComponent {
    @Metadata(defaultValue="false")
    private boolean allowTemplateFromHeader;
    @Metadata(defaultValue="false")
    private boolean allowContextMapAll;
    @Metadata(label="advanced")
    private Configuration configuration;
    private Configuration noCacheConfiguration;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Configuration config;
        String encoding = (String)this.getAndRemoveParameter(parameters, "encoding", String.class);
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        int templateUpdateDelay = (Integer)this.getAndRemoveParameter(parameters, "templateUpdateDelay", Integer.class, 0);
        if (cache) {
            config = this.getConfiguration();
            if (templateUpdateDelay > 0) {
                config.setTemplateUpdateDelay(templateUpdateDelay);
            }
        } else {
            config = this.getNoCacheConfiguration();
        }
        FreemarkerEndpoint endpoint = new FreemarkerEndpoint(uri, (Component)this, remaining);
        if (ObjectHelper.isNotEmpty((Object)encoding)) {
            endpoint.setEncoding(encoding);
        }
        endpoint.setAllowTemplateFromHeader(this.allowTemplateFromHeader);
        endpoint.setAllowContextMapAll(this.allowContextMapAll);
        endpoint.setContentCache(cache);
        endpoint.setConfiguration(config);
        endpoint.setTemplateUpdateDelay(templateUpdateDelay);
        this.setProperties((Endpoint)endpoint, parameters);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            endpoint.setResourceUri(remaining);
        }
        return endpoint;
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
            this.configuration.setTemplateLoader((TemplateLoader)new URLTemplateLoader(){

                protected URL getURL(String name) {
                    try {
                        return ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)FreemarkerComponent.this.getCamelContext().getClassResolver(), (String)name);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
        }
        return (Configuration)this.configuration.clone();
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isAllowTemplateFromHeader() {
        return this.allowTemplateFromHeader;
    }

    public void setAllowTemplateFromHeader(boolean allowTemplateFromHeader) {
        this.allowTemplateFromHeader = allowTemplateFromHeader;
    }

    public boolean isAllowContextMapAll() {
        return this.allowContextMapAll;
    }

    public void setAllowContextMapAll(boolean allowContextMapAll) {
        this.allowContextMapAll = allowContextMapAll;
    }

    private synchronized Configuration getNoCacheConfiguration() {
        if (this.noCacheConfiguration == null) {
            this.noCacheConfiguration = (Configuration)this.getConfiguration().clone();
            this.noCacheConfiguration.setCacheStorage((CacheStorage)new NullCacheStorage());
        }
        return this.noCacheConfiguration;
    }
}

