/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.eks;

import com.amazonaws.Protocol;
import com.amazonaws.services.eks.AmazonEKS;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.eks.EKSComponent;
import org.apache.camel.component.aws.eks.EKSConfiguration;
import org.apache.camel.component.aws.eks.EKSOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class EKSComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private EKSConfiguration getOrCreateConfiguration(EKSComponent target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new EKSConfiguration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        EKSComponent target = (EKSComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)EKSComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)EKSComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((EKSConfiguration)EKSComponentConfigurer.property((CamelContext)camelContext, EKSConfiguration.class, (Object)value));
                return true;
            }
            case "eksclient": 
            case "eksClient": {
                this.getOrCreateConfiguration(target).setEksClient((AmazonEKS)EKSComponentConfigurer.property((CamelContext)camelContext, AmazonEKS.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)EKSComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((EKSOperations)((Object)EKSComponentConfigurer.property((CamelContext)camelContext, EKSOperations.class, (Object)value)));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)EKSComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)EKSComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)EKSComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("autoDiscoverClient", Boolean.TYPE);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("configuration", EKSConfiguration.class);
        answer.put("eksClient", AmazonEKS.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("operation", EKSOperations.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        EKSComponent target = (EKSComponent)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "eksclient": 
            case "eksClient": {
                return this.getOrCreateConfiguration(target).getEksClient();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
        }
        return null;
    }
}

