/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.workday.producer;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.workday.WorkdayConfiguration;
import org.apache.camel.component.workday.WorkdayEndpoint;
import org.apache.camel.component.workday.auth.AuthClientForIntegration;
import org.apache.camel.component.workday.auth.AutheticationClient;
import org.apache.camel.component.workday.producer.WorkdayReportProducer;
import org.apache.camel.support.DefaultProducer;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WorkdayDefaultProducer
extends DefaultProducer {
    public static final String WORKDAY_URL_HEADER = "CamelWorkdayURL";
    private static final Logger LOG = LoggerFactory.getLogger(WorkdayReportProducer.class);
    private WorkdayEndpoint endpoint;
    private AutheticationClient autheticationClient;

    public WorkdayDefaultProducer(WorkdayEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.endpoint = endpoint;
        this.autheticationClient = new AuthClientForIntegration(this.endpoint.getWorkdayConfiguration());
    }

    public WorkdayEndpoint getEndpoint() {
        return (WorkdayEndpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        PoolingHttpClientConnectionManager httpClientConnectionManager = this.endpoint.getWorkdayConfiguration().getHttpConnectionManager();
        CloseableHttpClient httpClient = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager).build();
        String workdayUri = this.prepareUri(this.endpoint.getWorkdayConfiguration());
        HttpGet httpGet = new HttpGet(workdayUri);
        this.autheticationClient.configure(httpClient, (HttpRequestBase)httpGet);
        CloseableHttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpGet);
        if (httpResponse.getStatusLine().getStatusCode() != 200) {
            throw new IllegalStateException("Got the invalid http status value '" + httpResponse.getStatusLine() + "' as the result of the RAAS '" + workdayUri + "'");
        }
        String report = (String)this.getEndpoint().getCamelContext().getTypeConverter().mandatoryConvertTo(String.class, (Object)httpResponse.getEntity().getContent());
        if (report.isEmpty()) {
            throw new IllegalStateException("Got the unexpected value '" + report + "' as the result of the report '" + workdayUri + "'");
        }
        exchange.getIn().setBody((Object)report);
        exchange.getIn().setHeader(WORKDAY_URL_HEADER, (Object)workdayUri);
    }

    public abstract String prepareUri(WorkdayConfiguration var1) throws Exception;
}

