/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import org.apache.camel.component.weather.WeatherApi;
import org.apache.camel.component.weather.WeatherConfiguration;
import org.apache.camel.component.weather.WeatherMode;
import org.apache.camel.component.weather.geolocation.GeoLocation;
import org.apache.camel.util.ObjectHelper;

public class WeatherQuery {
    private final WeatherConfiguration weatherConfiguration;

    public WeatherQuery(WeatherConfiguration weatherConfiguration) {
        this.weatherConfiguration = weatherConfiguration;
    }

    public String getQuery() throws Exception {
        return this.getQuery(this.weatherConfiguration.getLocation());
    }

    public String getQuery(String location) throws Exception {
        String answer = "http://api.openweathermap.org/data/2.5/";
        if (this.weatherConfiguration.getLat() != null && this.weatherConfiguration.getLon() != null && this.weatherConfiguration.getRightLon() == null && this.weatherConfiguration.getTopLat() == null) {
            location = this.createLatLonQueryString();
        } else if (this.weatherConfiguration.getLat() != null && this.weatherConfiguration.getLon() != null && this.weatherConfiguration.getRightLon() != null && this.weatherConfiguration.getTopLat() != null) {
            location = "bbox=" + this.weatherConfiguration.getLon() + "," + this.weatherConfiguration.getLat() + "," + this.weatherConfiguration.getRightLon() + "," + this.weatherConfiguration.getTopLat() + "," + this.weatherConfiguration.getZoom() + "&cluster=yes";
        } else if (!ObjectHelper.isEmpty((Object)this.weatherConfiguration.getZip())) {
            location = "zip=" + this.weatherConfiguration.getZip();
        } else if (this.weatherConfiguration.getIds() != null && this.weatherConfiguration.getIds().size() > 0) {
            location = "id=" + String.join((CharSequence)",", this.weatherConfiguration.getIds());
        } else if (ObjectHelper.isEmpty((Object)location) || "current".equals(location)) {
            GeoLocation geoLocation = this.getCurrentGeoLocation();
            this.weatherConfiguration.setLat(geoLocation.getLatitude());
            this.weatherConfiguration.setLon(geoLocation.getLongitude());
            location = this.createLatLonQueryString();
        } else {
            location = "q=" + location;
        }
        location = location + "&lang=" + (Object)((Object)this.weatherConfiguration.getLanguage());
        String context = this.createContext();
        answer = answer + context + location;
        if (!ObjectHelper.isEmpty((Object)this.weatherConfiguration.getPeriod())) {
            answer = answer + "&cnt=" + this.weatherConfiguration.getPeriod();
        } else if (this.weatherConfiguration.getCnt() != null) {
            answer = answer + "&cnt=" + this.weatherConfiguration.getCnt();
        }
        if (this.weatherConfiguration.getUnits() != null) {
            answer = answer + "&units=" + this.weatherConfiguration.getUnits().name().toLowerCase();
        }
        if (this.weatherConfiguration.getMode() != WeatherMode.JSON) {
            answer = answer + "&mode=" + this.weatherConfiguration.getMode().name().toLowerCase();
        }
        if (this.weatherConfiguration.getAppid() != null) {
            answer = answer + "&APPID=" + this.weatherConfiguration.getAppid();
        }
        return answer;
    }

    private String createContext() {
        String answer = this.isBoxedQuery() ? (this.weatherConfiguration.getWeatherApi() == WeatherApi.Station ? "box/station?" : "box/city?") : (this.isGeoLocation() && this.weatherConfiguration.getCnt() != null ? (this.weatherConfiguration.getWeatherApi() == WeatherApi.Station ? "station/find?" : "find?") : (this.weatherConfiguration.getIds() != null && this.weatherConfiguration.getIds().size() > 0 ? (this.weatherConfiguration.getIds().size() == 1 ? (!ObjectHelper.isEmpty((Object)this.weatherConfiguration.getPeriod()) ? (this.weatherConfiguration.getWeatherApi() == WeatherApi.Hourly ? "forecast?" : "forecast/daily?") : (this.weatherConfiguration.getWeatherApi() == WeatherApi.Station ? "station?" : "weather?")) : "group?") : (ObjectHelper.isEmpty((Object)this.weatherConfiguration.getPeriod()) ? "weather?" : (this.weatherConfiguration.getWeatherApi() == WeatherApi.Hourly ? "forecast?" : "forecast/daily?"))));
        return answer;
    }

    private boolean isGeoLocation() {
        return this.weatherConfiguration.getLat() != null && this.weatherConfiguration.getLon() != null;
    }

    private String createLatLonQueryString() {
        return "lat=" + this.weatherConfiguration.getLat() + "&lon=" + this.weatherConfiguration.getLon();
    }

    private boolean isBoxedQuery() {
        return this.weatherConfiguration.getTopLat() != null && this.weatherConfiguration.getRightLon() != null;
    }

    GeoLocation getCurrentGeoLocation() throws Exception {
        return this.weatherConfiguration.getGeoLocationProvider().getCurrentGeoLocation();
    }
}

