/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.component.sql.ResultSetIterator;
import org.apache.camel.component.sql.ResultSetIteratorCompletion;
import org.apache.camel.component.sql.SqlEndpoint;
import org.apache.camel.component.sql.SqlHelper;
import org.apache.camel.component.sql.SqlOutputType;
import org.apache.camel.component.sql.SqlPrepareStatementStrategy;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCallback;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.support.JdbcUtils;

public class SqlProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(SqlProducer.class);
    private final String query;
    private String resolvedQuery;
    private final JdbcTemplate jdbcTemplate;
    private final boolean batch;
    private final boolean alwaysPopulateStatement;
    private final SqlPrepareStatementStrategy sqlPrepareStatementStrategy;
    private final boolean useMessageBodyForSql;
    private int parametersCount;

    public SqlProducer(SqlEndpoint endpoint, String query, JdbcTemplate jdbcTemplate, SqlPrepareStatementStrategy sqlPrepareStatementStrategy, boolean batch, boolean alwaysPopulateStatement, boolean useMessageBodyForSql) {
        super((Endpoint)endpoint);
        this.jdbcTemplate = jdbcTemplate;
        this.sqlPrepareStatementStrategy = sqlPrepareStatementStrategy;
        this.query = query;
        this.batch = batch;
        this.alwaysPopulateStatement = alwaysPopulateStatement;
        this.useMessageBodyForSql = useMessageBodyForSql;
    }

    public SqlEndpoint getEndpoint() {
        return (SqlEndpoint)super.getEndpoint();
    }

    protected void doInit() throws Exception {
        super.doInit();
        if (ResourceHelper.isClasspathUri((String)this.query)) {
            String placeholder = this.getEndpoint().isUsePlaceholder() ? this.getEndpoint().getPlaceholder() : null;
            this.resolvedQuery = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), this.query, placeholder);
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (!ResourceHelper.isClasspathUri((String)this.query)) {
            String placeholder = this.getEndpoint().isUsePlaceholder() ? this.getEndpoint().getPlaceholder() : null;
            this.resolvedQuery = SqlHelper.resolveQuery(this.getEndpoint().getCamelContext(), this.query, placeholder);
        }
    }

    public void process(final Exchange exchange) throws Exception {
        String queryHeader;
        final String sql = this.useMessageBodyForSql ? (String)exchange.getIn().getBody(String.class) : ((queryHeader = (String)exchange.getIn().getHeader("CamelSqlQuery", String.class)) != null ? queryHeader : this.resolvedQuery);
        final String preparedQuery = this.sqlPrepareStatementStrategy.prepareQuery(sql, this.getEndpoint().isAllowNamedParameters(), exchange);
        final Boolean shouldRetrieveGeneratedKeys = (Boolean)exchange.getIn().getHeader("CamelSqlRetrieveGeneratedKeys", (Object)false, Boolean.class);
        PreparedStatementCreator statementCreator = new PreparedStatementCreator(){

            public PreparedStatement createPreparedStatement(Connection con) throws SQLException {
                if (!shouldRetrieveGeneratedKeys.booleanValue()) {
                    return con.prepareStatement(preparedQuery);
                }
                Object expectedGeneratedColumns = exchange.getIn().getHeader("CamelSqlGeneratedColumns");
                if (expectedGeneratedColumns == null) {
                    return con.prepareStatement(preparedQuery, 1);
                }
                if (expectedGeneratedColumns instanceof String[]) {
                    return con.prepareStatement(preparedQuery, (String[])expectedGeneratedColumns);
                }
                if (expectedGeneratedColumns instanceof int[]) {
                    return con.prepareStatement(preparedQuery, (int[])expectedGeneratedColumns);
                }
                throw new IllegalArgumentException("Header specifying expected returning columns isn't an instance of String[] or int[] but " + expectedGeneratedColumns.getClass());
            }
        };
        SqlOutputType outputType = this.getEndpoint().getOutputType();
        if (outputType == SqlOutputType.StreamList) {
            this.processStreamList(exchange, statementCreator, sql, preparedQuery);
            return;
        }
        LOG.trace("jdbcTemplate.execute: {}", (Object)preparedQuery);
        this.jdbcTemplate.execute(statementCreator, new PreparedStatementCallback<Map<?, ?>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Map<?, ?> doInPreparedStatement(PreparedStatement ps) throws SQLException {
                Map<?, ?> map;
                ResultSet rs = null;
                try {
                    int expected;
                    int n = expected = SqlProducer.this.parametersCount > 0 ? SqlProducer.this.parametersCount : ps.getParameterMetaData().getParameterCount();
                    if (SqlProducer.this.alwaysPopulateStatement || expected > 0) {
                        if (SqlProducer.this.batch) {
                            Iterator iterator = SqlProducer.this.useMessageBodyForSql ? (Iterator)exchange.getIn().getHeader("CamelSqlParameters", Iterator.class) : (Iterator)exchange.getIn().getBody(Iterator.class);
                            while (iterator != null && iterator.hasNext()) {
                                Object value = iterator.next();
                                Iterator<?> i = SqlProducer.this.sqlPrepareStatementStrategy.createPopulateIterator(sql, preparedQuery, expected, exchange, value);
                                SqlProducer.this.sqlPrepareStatementStrategy.populateStatement(ps, i, expected);
                                ps.addBatch();
                            }
                        } else {
                            Object value = SqlProducer.this.useMessageBodyForSql ? exchange.getIn().getHeader("CamelSqlParameters") : exchange.getIn().getBody();
                            Iterator<?> i = SqlProducer.this.sqlPrepareStatementStrategy.createPopulateIterator(sql, preparedQuery, expected, exchange, value);
                            SqlProducer.this.sqlPrepareStatementStrategy.populateStatement(ps, i, expected);
                        }
                    }
                    boolean isResultSet = false;
                    if (SqlProducer.this.batch) {
                        int[] updateCounts = ps.executeBatch();
                        int total = 0;
                        for (int count : updateCounts) {
                            total += count;
                        }
                        exchange.getIn().setHeader("CamelSqlUpdateCount", (Object)total);
                    } else {
                        isResultSet = ps.execute();
                        if (isResultSet) {
                            Object data;
                            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                            rs = ps.getResultSet();
                            SqlOutputType outputType = SqlProducer.this.getEndpoint().getOutputType();
                            LOG.trace("Got result list from query: {}, outputType={}", (Object)rs, (Object)outputType);
                            if (outputType == SqlOutputType.SelectList) {
                                data = SqlProducer.this.getEndpoint().queryForList(rs, true);
                                if (SqlProducer.this.getEndpoint().isNoop()) {
                                    exchange.getOut().setBody(exchange.getIn().getBody());
                                } else if (SqlProducer.this.getEndpoint().getOutputHeader() != null) {
                                    exchange.getOut().setBody(exchange.getIn().getBody());
                                    exchange.getOut().setHeader(SqlProducer.this.getEndpoint().getOutputHeader(), data);
                                } else {
                                    exchange.getOut().setBody(data);
                                }
                                exchange.getOut().setHeader("CamelSqlRowCount", (Object)data.size());
                            } else {
                                if (outputType != SqlOutputType.SelectOne) throw new IllegalArgumentException("Invalid outputType=" + (Object)((Object)outputType));
                                data = SqlProducer.this.getEndpoint().queryForObject(rs);
                                if (data != null) {
                                    if (SqlProducer.this.getEndpoint().isNoop()) {
                                        exchange.getOut().setBody(exchange.getIn().getBody());
                                    } else if (SqlProducer.this.getEndpoint().getOutputHeader() != null) {
                                        exchange.getOut().setBody(exchange.getIn().getBody());
                                        exchange.getOut().setHeader(SqlProducer.this.getEndpoint().getOutputHeader(), data);
                                    } else {
                                        exchange.getOut().setBody(data);
                                    }
                                    exchange.getOut().setHeader("CamelSqlRowCount", (Object)1);
                                } else {
                                    if (SqlProducer.this.getEndpoint().isNoop()) {
                                        exchange.getOut().setBody(exchange.getIn().getBody());
                                    } else if (SqlProducer.this.getEndpoint().getOutputHeader() != null) {
                                        exchange.getOut().setBody(exchange.getIn().getBody());
                                    }
                                    exchange.getOut().setHeader("CamelSqlRowCount", (Object)0);
                                }
                            }
                        } else {
                            exchange.getIn().setHeader("CamelSqlUpdateCount", (Object)ps.getUpdateCount());
                        }
                    }
                    if (shouldRetrieveGeneratedKeys.booleanValue()) {
                        if (!exchange.hasOut()) {
                            exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                        }
                        if (isResultSet) {
                            exchange.getOut().setHeader("CamelSqlGeneratedKeyRows", (Object)Collections.EMPTY_LIST);
                            exchange.getOut().setHeader("CamelSqlGeneratedKeysRowCount", (Object)0);
                        } else {
                            List<?> generatedKeys = SqlProducer.this.getEndpoint().queryForList(ps.getGeneratedKeys(), false);
                            exchange.getOut().setHeader("CamelSqlGeneratedKeyRows", generatedKeys);
                            exchange.getOut().setHeader("CamelSqlGeneratedKeysRowCount", (Object)generatedKeys.size());
                        }
                    }
                    map = null;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeResultSet(rs);
                    throw throwable;
                }
                JdbcUtils.closeResultSet((ResultSet)rs);
                return map;
            }
        });
    }

    protected void processStreamList(Exchange exchange, PreparedStatementCreator statementCreator, String sql, String preparedQuery) throws Exception {
        LOG.trace("processStreamList: {}", (Object)preparedQuery);
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean isResultSet;
            int expected;
            con = this.jdbcTemplate.getDataSource().getConnection();
            ps = statementCreator.createPreparedStatement(con);
            int n = expected = this.parametersCount > 0 ? this.parametersCount : ps.getParameterMetaData().getParameterCount();
            if (this.alwaysPopulateStatement || expected > 0) {
                if (this.batch) {
                    Iterator iterator = this.useMessageBodyForSql ? (Iterator)exchange.getIn().getHeader("CamelSqlParameters", Iterator.class) : (Iterator)exchange.getIn().getBody(Iterator.class);
                    while (iterator != null && iterator.hasNext()) {
                        Object value = iterator.next();
                        Iterator<?> i = this.sqlPrepareStatementStrategy.createPopulateIterator(sql, preparedQuery, expected, exchange, value);
                        this.sqlPrepareStatementStrategy.populateStatement(ps, i, expected);
                        ps.addBatch();
                    }
                } else {
                    Object value = this.useMessageBodyForSql ? exchange.getIn().getHeader("CamelSqlParameters") : exchange.getIn().getBody();
                    Iterator<?> i = this.sqlPrepareStatementStrategy.createPopulateIterator(sql, preparedQuery, expected, exchange, value);
                    this.sqlPrepareStatementStrategy.populateStatement(ps, i, expected);
                }
            }
            if (isResultSet = ps.execute()) {
                rs = ps.getResultSet();
                ResultSetIterator iterator = this.getEndpoint().queryForStreamList(con, ps, rs);
                exchange.getOut().getHeaders().putAll(exchange.getIn().getHeaders());
                if (this.getEndpoint().isNoop()) {
                    exchange.getOut().setBody(exchange.getIn().getBody());
                } else if (this.getEndpoint().getOutputHeader() != null) {
                    exchange.getOut().setBody(exchange.getIn().getBody());
                    exchange.getOut().setHeader(this.getEndpoint().getOutputHeader(), (Object)iterator);
                } else {
                    exchange.getOut().setBody((Object)iterator);
                }
                ((ExtendedExchange)exchange.adapt(ExtendedExchange.class)).addOnCompletion((Synchronization)new ResultSetIteratorCompletion(iterator));
            }
        }
        catch (Exception e) {
            JdbcUtils.closeConnection(con);
            JdbcUtils.closeStatement(ps);
            JdbcUtils.closeResultSet(rs);
            throw e;
        }
    }

    public void setParametersCount(int parametersCount) {
        this.parametersCount = parametersCount;
    }
}

