/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ipfs;

import io.ipfs.multihash.Multihash;
import io.nessus.ipfs.client.IPFSClient;
import io.nessus.ipfs.client.IPFSException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.ipfs.IPFSComponent;
import org.apache.camel.component.ipfs.IPFSConfiguration;
import org.apache.camel.component.ipfs.IPFSEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPFSProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(IPFSComponent.class);
    private static final long DEFAULT_TIMEOUT = 10000L;

    public IPFSProducer(IPFSEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public IPFSEndpoint getEndpoint() {
        return (IPFSEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        IPFSClient client = this.getEndpoint().getIPFSClient();
        try {
            client.connect();
        }
        catch (IPFSException ex) {
            LOG.warn(ex.getMessage());
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public void process(Exchange exchange) throws Exception {
        IPFSEndpoint endpoint = this.getEndpoint();
        IPFSConfiguration.IPFSCommand cmd = this.getCommand();
        if (IPFSConfiguration.IPFSCommand.version == cmd) {
            String resp = this.ipfsVersion();
            exchange.getMessage().setBody((Object)resp);
        } else if (IPFSConfiguration.IPFSCommand.add == cmd) {
            List<String> cids;
            Path path = this.pathFromBody(exchange);
            List<String> resp = cids = this.ipfsAdd(path);
            if (path.toFile().isFile()) {
                resp = cids.size() > 0 ? cids.get(0) : null;
            }
            exchange.getMessage().setBody(resp);
        } else if (IPFSConfiguration.IPFSCommand.cat == cmd) {
            String cid = (String)exchange.getMessage().getBody(String.class);
            InputStream resp = this.ipfsCat(cid);
            exchange.getMessage().setBody((Object)resp);
        } else if (IPFSConfiguration.IPFSCommand.get == cmd) {
            String outdir = endpoint.getConfiguration().getOutdir();
            String cid = (String)exchange.getMessage().getBody(String.class);
            Path resp = this.ipfsGet(cid, new File(outdir).toPath());
            exchange.getMessage().setBody((Object)resp);
        } else {
            throw new UnsupportedOperationException(cmd.toString());
        }
    }

    private Path pathFromBody(Exchange exchange) {
        Object body = exchange.getMessage().getBody();
        if (body instanceof Path) {
            return (Path)body;
        }
        if (body instanceof String) {
            return Paths.get((String)body, new String[0]);
        }
        if (body instanceof File) {
            return ((File)body).toPath();
        }
        throw new IllegalArgumentException("Invalid path: " + body);
    }

    public IPFSConfiguration.IPFSCommand getCommand() {
        String cmd = this.getEndpoint().getConfiguration().getIpfsCmd();
        try {
            return IPFSConfiguration.IPFSCommand.valueOf(cmd);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Unsupported command: " + cmd);
        }
    }

    public String ipfsVersion() throws IOException {
        return this.ipfs().version();
    }

    public List<String> ipfsAdd(Path path) throws IOException {
        List cids = this.ipfs().add(path);
        return cids.stream().map(mh -> mh.toBase58()).collect(Collectors.toList());
    }

    public InputStream ipfsCat(String cid) throws IOException, TimeoutException {
        Multihash mhash = Multihash.fromBase58((String)cid);
        Future future = this.ipfs().cat(mhash);
        try {
            return (InputStream)future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IOException("Cannot obtain: " + cid, ex);
        }
    }

    public Path ipfsGet(String cid, Path outdir) throws IOException, TimeoutException {
        Multihash mhash = Multihash.fromBase58((String)cid);
        Future future = this.ipfs().get(mhash, outdir);
        try {
            return (Path)future.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new IOException("Cannot obtain: " + cid, ex);
        }
    }

    private IPFSClient ipfs() {
        IPFSClient client = this.getEndpoint().getIPFSClient();
        if (!client.hasConnection()) {
            client.connect();
        }
        return client;
    }
}

