/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.guava.eventbus;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.guava.eventbus.CamelEventHandler;
import org.apache.camel.component.guava.eventbus.FilteringCamelEventHandler;
import org.apache.camel.component.guava.eventbus.GuavaEventBusEndpoint;
import org.apache.camel.support.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaEventBusConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(GuavaEventBusConsumer.class);
    private final EventBus eventBus;
    private final Object eventHandler;

    public GuavaEventBusConsumer(GuavaEventBusEndpoint endpoint, Processor processor, EventBus eventBus, Class<?> eventClass, Class<?> listenerInterface) {
        super((Endpoint)endpoint, processor);
        if (eventClass != null && listenerInterface != null) {
            throw new IllegalStateException("You cannot set both 'eventClass' and 'listenerInterface' parameters.");
        }
        this.eventBus = eventBus;
        this.eventHandler = listenerInterface != null ? this.createListenerInterfaceProxy(endpoint, processor, listenerInterface) : new FilteringCamelEventHandler(endpoint, processor, eventClass);
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Registering event handler: {} to EventBus: {}", this.eventHandler, (Object)this.eventBus);
        this.eventBus.register(this.eventHandler);
    }

    protected void doStop() throws Exception {
        LOG.debug("Unregistering event handler: {} from EventBus: {}", this.eventHandler, (Object)this.eventBus);
        this.eventBus.unregister(this.eventHandler);
        super.doStop();
    }

    private Object createListenerInterfaceProxy(GuavaEventBusEndpoint endpoint, Processor processor, Class<?> listenerInterface) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Proxy.newProxyInstance(classLoader, new Class[]{listenerInterface}, (InvocationHandler)new ListenerInterfaceHandler(endpoint, processor));
    }

    private static final class ListenerInterfaceHandler
    implements InvocationHandler {
        private static final Logger LOG = LoggerFactory.getLogger(ListenerInterfaceHandler.class);
        private final CamelEventHandler delegateHandler;

        private ListenerInterfaceHandler(GuavaEventBusEndpoint endpoint, Processor processor) {
            this.delegateHandler = new CamelEventHandler(endpoint, processor);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getAnnotation(Subscribe.class) != null) {
                this.delegateHandler.doEventReceived(args[0]);
            } else {
                LOG.warn("Non @Subscribe method {} called on ListenerInterface proxy.", (Object)method);
            }
            return null;
        }
    }
}

