/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.ecs;

import com.amazonaws.Protocol;
import com.amazonaws.services.ecs.AmazonECS;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.ecs.ECSEndpoint;
import org.apache.camel.component.aws.ecs.ECSOperations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class ECSEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ECSEndpoint target = (ECSEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                target.getConfiguration().setAccessKey((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                target.getConfiguration().setAutoDiscoverClient((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "ecsclient": 
            case "ecsClient": {
                target.getConfiguration().setEcsClient((AmazonECS)ECSEndpointConfigurer.property((CamelContext)camelContext, AmazonECS.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                target.getConfiguration().setOperation((ECSOperations)((Object)ECSEndpointConfigurer.property((CamelContext)camelContext, ECSOperations.class, (Object)value)));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                target.getConfiguration().setProxyHost((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                target.getConfiguration().setProxyPort((Integer)ECSEndpointConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                target.getConfiguration().setProxyProtocol((Protocol)ECSEndpointConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                target.getConfiguration().setRegion((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                target.getConfiguration().setSecretKey((String)ECSEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)ECSEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("autoDiscoverClient", Boolean.TYPE);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("ecsClient", AmazonECS.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("operation", ECSOperations.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("synchronous", Boolean.TYPE);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ECSEndpoint target = (ECSEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return target.getConfiguration().getAccessKey();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return target.getConfiguration().isAutoDiscoverClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "ecsclient": 
            case "ecsClient": {
                return target.getConfiguration().getEcsClient();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "operation": {
                return target.getConfiguration().getOperation();
            }
            case "proxyhost": 
            case "proxyHost": {
                return target.getConfiguration().getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return target.getConfiguration().getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return target.getConfiguration().getProxyProtocol();
            }
            case "region": {
                return target.getConfiguration().getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return target.getConfiguration().getSecretKey();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
        }
        return null;
    }
}

