/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.firehose;

import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Configuration;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Endpoint;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Operations;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.firehose.FirehoseClient;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.CreateDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamRequest;
import software.amazon.awssdk.services.firehose.model.DeleteDeliveryStreamResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordBatchResponse;
import software.amazon.awssdk.services.firehose.model.PutRecordRequest;
import software.amazon.awssdk.services.firehose.model.PutRecordResponse;
import software.amazon.awssdk.services.firehose.model.Record;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationRequest;
import software.amazon.awssdk.services.firehose.model.UpdateDestinationResponse;

public class KinesisFirehose2Producer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisFirehose2Producer.class);

    public KinesisFirehose2Producer(KinesisFirehose2Endpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public KinesisFirehose2Endpoint getEndpoint() {
        return (KinesisFirehose2Endpoint)super.getEndpoint();
    }

    public void process(Exchange exchange) throws Exception {
        KinesisFirehose2Operations operation = this.determineOperation(exchange);
        if (ObjectHelper.isEmpty((Object)((Object)operation))) {
            this.processSingleRecord(exchange);
        } else {
            switch (operation) {
                case sendBatchRecord: {
                    this.sendBatchRecord(this.getClient(), exchange);
                    break;
                }
                case createDeliveryStream: {
                    this.createDeliveryStream(this.getClient(), exchange);
                    break;
                }
                case deleteDeliveryStream: {
                    this.deleteDeliveryStream(this.getClient(), exchange);
                    break;
                }
                case updateDestination: {
                    this.updateDestination(this.getClient(), exchange);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported operation");
                }
            }
        }
    }

    private void createDeliveryStream(FirehoseClient client, Exchange exchange) {
        if (!(exchange.getIn().getBody() instanceof CreateDeliveryStreamRequest)) {
            throw new IllegalArgumentException("The createDeliveryStream operation expects a CreateDeliveryStream instance as body");
        }
        CreateDeliveryStreamRequest req = (CreateDeliveryStreamRequest)exchange.getIn().getBody(CreateDeliveryStreamRequest.class);
        CreateDeliveryStreamResponse result = client.createDeliveryStream(req);
        Message message = KinesisFirehose2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void deleteDeliveryStream(FirehoseClient client, Exchange exchange) {
        if (exchange.getIn().getBody() instanceof DeleteDeliveryStreamRequest) {
            DeleteDeliveryStreamRequest req = (DeleteDeliveryStreamRequest)exchange.getIn().getBody(DeleteDeliveryStreamRequest.class);
            DeleteDeliveryStreamResponse result = client.deleteDeliveryStream(req);
            Message message = KinesisFirehose2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        } else if (ObjectHelper.isNotEmpty((Object)exchange.getIn().getHeader("CamelAwsKinesisFirehoseDeliveryStreamName"))) {
            DeleteDeliveryStreamRequest req = (DeleteDeliveryStreamRequest)DeleteDeliveryStreamRequest.builder().deliveryStreamName((String)exchange.getIn().getHeader("CamelAwsKinesisFirehoseDeliveryStreamName", String.class)).build();
            DeleteDeliveryStreamResponse result = client.deleteDeliveryStream(req);
            Message message = KinesisFirehose2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        } else {
            throw new IllegalArgumentException("The deleteDeliveryStream operation expects at least an delivery stream name header or a DeleteDeliveryStreamRequest instance");
        }
    }

    private void updateDestination(FirehoseClient client, Exchange exchange) {
        if (!(exchange.getIn().getBody() instanceof CreateDeliveryStreamRequest)) {
            throw new IllegalArgumentException("The updateDestination operation expects an UpdateDestinationRequest instance as body");
        }
        UpdateDestinationRequest req = (UpdateDestinationRequest)exchange.getIn().getBody(UpdateDestinationRequest.class);
        UpdateDestinationResponse result = client.updateDestination(req);
        Message message = KinesisFirehose2Producer.getMessageForResponse(exchange);
        message.setBody((Object)result);
    }

    private void sendBatchRecord(FirehoseClient client, Exchange exchange) {
        if (exchange.getIn().getBody() instanceof Iterable) {
            Iterable c = (Iterable)exchange.getIn().getBody(Iterable.class);
            PutRecordBatchRequest.Builder batchRequest = PutRecordBatchRequest.builder();
            batchRequest.deliveryStreamName(this.getEndpoint().getConfiguration().getStreamName());
            batchRequest.records((Collection)c);
            PutRecordBatchResponse result = client.putRecordBatch((PutRecordBatchRequest)batchRequest.build());
            Message message = KinesisFirehose2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        } else {
            PutRecordBatchRequest req = (PutRecordBatchRequest)exchange.getIn().getBody(PutRecordBatchRequest.class);
            PutRecordBatchResponse result = client.putRecordBatch(req);
            Message message = KinesisFirehose2Producer.getMessageForResponse(exchange);
            message.setBody((Object)result);
        }
    }

    public void processSingleRecord(Exchange exchange) {
        PutRecordRequest request = this.createRequest(exchange);
        LOG.trace("Sending request [{}] from exchange [{}]...", (Object)request, (Object)exchange);
        PutRecordResponse putRecordResult = this.getEndpoint().getClient().putRecord(request);
        LOG.trace("Received result [{}]", (Object)putRecordResult);
        Message message = KinesisFirehose2Producer.getMessageForResponse(exchange);
        message.setHeader("CamelAwsKinesisFirehoseRecordId", (Object)putRecordResult.recordId());
    }

    private PutRecordRequest createRequest(Exchange exchange) {
        ByteBuffer body = (ByteBuffer)exchange.getIn().getBody(ByteBuffer.class);
        Record.Builder record = Record.builder();
        record.data(SdkBytes.fromByteBuffer((ByteBuffer)body));
        PutRecordRequest.Builder putRecordRequest = PutRecordRequest.builder();
        putRecordRequest.deliveryStreamName(this.getEndpoint().getConfiguration().getStreamName());
        putRecordRequest.record((Record)record.build());
        return (PutRecordRequest)putRecordRequest.build();
    }

    public static Message getMessageForResponse(Exchange exchange) {
        return exchange.getMessage();
    }

    protected FirehoseClient getClient() {
        return this.getEndpoint().getClient();
    }

    protected KinesisFirehose2Configuration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    private KinesisFirehose2Operations determineOperation(Exchange exchange) {
        KinesisFirehose2Operations operation = (KinesisFirehose2Operations)((Object)exchange.getIn().getHeader("CamelAwsKinesisFirehoseOperation", KinesisFirehose2Operations.class));
        if (operation == null) {
            operation = this.getConfiguration().getOperation();
        }
        return operation;
    }
}

