/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.firehose;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2ComponentVerifierExtension;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Configuration;
import org.apache.camel.component.aws2.firehose.KinesisFirehose2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import software.amazon.awssdk.services.firehose.FirehoseClient;

@Component(value="aws2-kinesis-firehose")
public class KinesisFirehose2Component
extends DefaultComponent {
    @Metadata
    private KinesisFirehose2Configuration configuration = new KinesisFirehose2Configuration();

    public KinesisFirehose2Component() {
        this(null);
    }

    public KinesisFirehose2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new KinesisFirehose2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        KinesisFirehose2Configuration configuration = this.configuration != null ? this.configuration.copy() : new KinesisFirehose2Configuration();
        configuration.setStreamName(remaining);
        KinesisFirehose2Endpoint endpoint = new KinesisFirehose2Endpoint(uri, configuration, this);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration);
        }
        if (configuration.getAmazonKinesisFirehoseClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonKinesisFirehoseClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public KinesisFirehose2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(KinesisFirehose2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(KinesisFirehose2Configuration configuration) {
        Set clients = this.getCamelContext().getRegistry().findByType(FirehoseClient.class);
        if (clients.size() == 1) {
            configuration.setAmazonKinesisFirehoseClient((FirehoseClient)clients.stream().findFirst().get());
        }
    }
}

