/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atmos.core;

import com.emc.atmos.api.AtmosApi;
import com.emc.atmos.api.ObjectId;
import com.emc.atmos.api.ObjectIdentifier;
import com.emc.atmos.api.ObjectPath;
import com.emc.atmos.api.bean.DirectoryEntry;
import com.emc.atmos.api.request.CreateObjectRequest;
import com.emc.atmos.api.request.ListDirectoryRequest;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.atmos.dto.AtmosDelResult;
import org.apache.camel.component.atmos.dto.AtmosFileDownloadResult;
import org.apache.camel.component.atmos.dto.AtmosFileUploadResult;
import org.apache.camel.component.atmos.dto.AtmosMoveResult;
import org.apache.camel.component.atmos.dto.AtmosResult;
import org.apache.camel.component.atmos.util.AtmosException;
import org.apache.camel.component.atmos.util.AtmosResultCode;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AtmosAPIFacade {
    private static final transient Logger LOG = LoggerFactory.getLogger(AtmosAPIFacade.class);
    private static AtmosAPIFacade instance;
    private static AtmosApi client;

    private AtmosAPIFacade() {
    }

    public static AtmosAPIFacade getInstance(AtmosApi client) {
        if (instance == null) {
            instance = new AtmosAPIFacade();
            AtmosAPIFacade.client = client;
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtmosResult put(String localPath, String remotePath) throws AtmosException {
        String atmosPath;
        AtmosFileUploadResult result = new AtmosFileUploadResult();
        HashMap<String, AtmosResultCode> resultEntries = null;
        String string = atmosPath = remotePath == null ? localPath : remotePath;
        if (!atmosPath.endsWith("/")) {
            atmosPath = atmosPath + "/";
        }
        ObjectPath atmosEntry = new ObjectPath(atmosPath);
        if (!atmosPath.equals("/") && client.getSystemMetadata((ObjectIdentifier)atmosEntry, new String[0]) == null) {
            throw new AtmosException(atmosPath + " does not exist or cannot obtain metadata");
        }
        File fileLocalPath = new File(localPath);
        if (fileLocalPath.isFile()) {
            if (!atmosEntry.isDirectory()) {
                throw new AtmosException(atmosPath + " exists on atmos and is not a folder!");
            }
            atmosPath = atmosPath + fileLocalPath.getName();
            resultEntries = new HashMap<String, AtmosResultCode>(1);
            try {
                ObjectId uploadedFile = this.putSingleFile(fileLocalPath, atmosPath);
                if (uploadedFile == null) {
                    resultEntries.put(atmosPath, AtmosResultCode.KO);
                } else {
                    resultEntries.put(atmosPath, AtmosResultCode.OK);
                }
            }
            catch (Exception ex) {
                resultEntries.put(atmosPath, AtmosResultCode.KO);
            }
            finally {
                result.setResultEntries(resultEntries);
            }
            return result;
        }
        LOG.info("uploading a dir...");
        if (!atmosEntry.isDirectory()) {
            throw new AtmosException(atmosPath + " exists on atmos and is not a folder!");
        }
        String oldAtmosPath = atmosPath;
        Collection listFiles = FileUtils.listFiles((File)fileLocalPath, null, (boolean)true);
        if (listFiles == null || listFiles.isEmpty()) {
            throw new AtmosException(localPath + " does not contain any files");
        }
        resultEntries = new HashMap(listFiles.size());
        for (File file : listFiles) {
            String absPath = file.getAbsolutePath();
            int indexRemainingPath = localPath.length();
            if (!localPath.endsWith("/")) {
                ++indexRemainingPath;
            }
            String remainingPath = absPath.substring(indexRemainingPath);
            atmosPath = atmosPath + remainingPath;
            try {
                LOG.debug("uploading: {} to {}", (Object)fileLocalPath, (Object)atmosPath);
                ObjectId uploadedFile = this.putSingleFile(file, atmosPath);
                if (uploadedFile == null) {
                    resultEntries.put(atmosPath, AtmosResultCode.KO);
                } else {
                    resultEntries.put(atmosPath, AtmosResultCode.OK);
                }
            }
            catch (Exception ex) {
                resultEntries.put(atmosPath, AtmosResultCode.KO);
            }
            atmosPath = oldAtmosPath;
        }
        result.setResultEntries(resultEntries);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectId putSingleFile(File inputFile, String atmosPath) throws Exception {
        ObjectId uploadedFile = null;
        try (FileInputStream inputStream = new FileInputStream(inputFile);){
            ObjectPath op = new ObjectPath(atmosPath);
            CreateObjectRequest request = new CreateObjectRequest();
            ((CreateObjectRequest)((CreateObjectRequest)request.identifier((ObjectIdentifier)op)).content((Object)inputStream)).contentLength(inputFile.length());
            ObjectId objectId = uploadedFile = client.createObject(request).getObjectId();
            return objectId;
        }
    }

    public AtmosResult del(String remotePath) throws AtmosException {
        AtmosDelResult result = null;
        ObjectPath op = new ObjectPath(remotePath);
        client.delete((ObjectIdentifier)op);
        result = new AtmosDelResult();
        result.setResultEntries(remotePath);
        return result;
    }

    public AtmosResult move(String remotePath, String newRemotePath) throws AtmosException {
        AtmosMoveResult result = null;
        client.move(new ObjectPath(remotePath), new ObjectPath(newRemotePath), true);
        result = new AtmosMoveResult();
        result.setResultEntries(remotePath + "-" + newRemotePath);
        return result;
    }

    public AtmosResult get(String remotePath) throws AtmosException {
        AtmosFileDownloadResult result = new AtmosFileDownloadResult();
        HashMap<String, ByteArrayOutputStream> resultEntries = new HashMap<String, ByteArrayOutputStream>();
        this.downloadFilesInFolder(remotePath, resultEntries);
        result.setResultEntries(resultEntries);
        return result;
    }

    private void downloadFilesInFolder(String atmosPath, Map<String, ByteArrayOutputStream> resultEntries) throws AtmosException {
        ObjectPath atmosEntry = new ObjectPath(atmosPath);
        if (client.getSystemMetadata((ObjectIdentifier)atmosEntry, new String[0]) == null) {
            throw new AtmosException(atmosPath + " does not exist or cannot obtain metadata");
        }
        if (!atmosEntry.isDirectory()) {
            LOG.debug("downloading a single file...");
            this.downloadSingleFile(atmosPath, resultEntries);
            return;
        }
        ListDirectoryRequest listRequest = new ListDirectoryRequest().path(atmosEntry);
        client.listDirectory(listRequest);
        for (DirectoryEntry entry : client.listDirectory(listRequest).getEntries()) {
            if (!entry.isDirectory()) {
                try {
                    this.downloadSingleFile(atmosEntry.getPath().concat(entry.getFilename()), resultEntries);
                }
                catch (AtmosException e) {
                    LOG.warn("Cannot download from {}", (Object)entry.getFilename());
                }
                continue;
            }
            this.downloadFilesInFolder(atmosEntry.getPath().concat(entry.getFilename()), resultEntries);
        }
    }

    private void downloadSingleFile(String path, Map<String, ByteArrayOutputStream> resultEntries) throws AtmosException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] content = null;
        try {
            content = (byte[])client.readObject((ObjectIdentifier)new ObjectPath(path), byte[].class);
            baos.write(content);
        }
        catch (IOException e) {
            throw new AtmosException(path + " cannot obtain a stream", e);
        }
        if (content != null) {
            resultEntries.put(path, baos);
            LOG.debug("Downloaded path: {} size: {}", (Object)path, (Object)baos.size());
        }
    }
}

