/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.msk;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.msk.MSK2ComponentVerifierExtension;
import org.apache.camel.component.aws2.msk.MSK2Configuration;
import org.apache.camel.component.aws2.msk.MSK2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.kafka.KafkaClient;

@org.apache.camel.spi.annotations.Component(value="aws2-msk")
public class MSK2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MSK2Component.class);
    @Metadata
    private MSK2Configuration configuration = new MSK2Configuration();

    public MSK2Component() {
        this(null);
    }

    public MSK2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new MSK2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MSK2Configuration configuration = this.configuration != null ? this.configuration.copy() : new MSK2Configuration();
        MSK2Endpoint endpoint = new MSK2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration, endpoint);
        }
        if (configuration.getMskClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("Amazon msk client or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public MSK2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MSK2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(MSK2Configuration configuration, MSK2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getMskClient())) {
            LOG.debug("Looking for an KafkaClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(KafkaClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one KafkaClient instance in the registry");
                configuration.setMskClient((KafkaClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No KafkaClient instance in the registry");
            }
        } else {
            LOG.debug("KafkaClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

