/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sns;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.sns.Sns2ComponentVerifierExtension;
import org.apache.camel.component.aws2.sns.Sns2Configuration;
import org.apache.camel.component.aws2.sns.Sns2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sns.SnsClient;

@org.apache.camel.spi.annotations.Component(value="aws2-sns")
public class Sns2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Sns2Component.class);
    @Metadata
    private Sns2Configuration configuration = new Sns2Configuration();

    public Sns2Component() {
        this(null);
    }

    public Sns2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Sns2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Sns2Configuration configuration;
        if (remaining == null || remaining.trim().length() == 0) {
            throw new IllegalArgumentException("Topic name must be specified.");
        }
        Sns2Configuration sns2Configuration = configuration = this.configuration != null ? this.configuration.copy() : new Sns2Configuration();
        if (remaining.startsWith("arn:")) {
            String[] parts = remaining.split(":");
            if (parts.length != 6 || !parts[2].equals("sns")) {
                throw new IllegalArgumentException("Topic arn must be in format arn:aws:sns:region:account:name.");
            }
            configuration.setTopicArn(remaining);
            configuration.setRegion(Region.of((String)parts[3]).toString());
        } else {
            configuration.setTopicName(remaining);
        }
        Sns2Endpoint endpoint = new Sns2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (endpoint.getConfiguration().isAutoDiscoverClient()) {
            this.checkAndSetRegistryClient(configuration, endpoint);
        }
        if (configuration.getAmazonSNSClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("AmazonSNSClient or accessKey and secretKey must be specified");
        }
        return endpoint;
    }

    public Sns2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Sns2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(Sns2Configuration configuration, Sns2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getAmazonSNSClient())) {
            LOG.debug("Looking for an SnsClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(SnsClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one SnsClient instance in the registry");
                configuration.setAmazonSNSClient((SnsClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No SnsClient instance in the registry");
            }
        } else {
            LOG.debug("SnsClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

