/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.storage.blob.operations;

import com.azure.storage.blob.models.ListBlobContainersOptions;
import java.time.Duration;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.storage.blob.BlobConfiguration;
import org.apache.camel.component.azure.storage.blob.BlobConfigurationOptionsProxy;
import org.apache.camel.component.azure.storage.blob.client.BlobServiceClientWrapper;
import org.apache.camel.component.azure.storage.blob.operations.BlobOperationResponse;
import org.apache.camel.util.ObjectHelper;

public class BlobServiceOperations {
    private final BlobServiceClientWrapper client;
    private final BlobConfigurationOptionsProxy configurationProxy;

    public BlobServiceOperations(BlobConfiguration configuration, BlobServiceClientWrapper client) {
        ObjectHelper.notNull((Object)client, (String)"client cannot be null");
        this.client = client;
        this.configurationProxy = new BlobConfigurationOptionsProxy(configuration);
    }

    public BlobOperationResponse listBlobContainers(Exchange exchange) {
        if (exchange == null) {
            return new BlobOperationResponse(this.client.listBlobContainers(null, null));
        }
        ListBlobContainersOptions listBlobContainersOptions = this.configurationProxy.getListBlobContainersOptions(exchange);
        Duration timeout = this.configurationProxy.getTimeout(exchange);
        return new BlobOperationResponse(this.client.listBlobContainers(listBlobContainersOptions, timeout));
    }
}

