/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.debezium.configuration;

import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnector;
import org.apache.camel.component.debezium.configuration.ConfigurationValidation;
import org.apache.camel.component.debezium.configuration.EmbeddedDebeziumConfiguration;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class SqlServerConnectorEmbeddedDebeziumConfiguration
extends EmbeddedDebeziumConfiguration {
    private static final String LABEL_NAME = "consumer,sqlserver";
    @UriParam(label="consumer,sqlserver")
    private String messageKeyColumns;
    @UriParam(label="consumer,sqlserver", defaultValue="8192")
    private int maxQueueSize = 8192;
    @UriParam(label="consumer,sqlserver")
    private String databaseHistoryKafkaTopic;
    @UriParam(label="consumer,sqlserver")
    private String columnBlacklist;
    @UriParam(label="consumer,sqlserver", defaultValue="0ms", javaType="java.time.Duration")
    private long snapshotDelayMs = 0L;
    @UriParam(label="consumer,sqlserver", defaultValue="100")
    private int databaseHistoryKafkaRecoveryAttempts = 100;
    @UriParam(label="consumer,sqlserver")
    private String tableBlacklist;
    @UriParam(label="consumer,sqlserver", defaultValue="false")
    private boolean provideTransactionMetadata = false;
    @UriParam(label="consumer,sqlserver", defaultValue="true")
    private boolean includeSchemaChanges = true;
    @UriParam(label="consumer,sqlserver")
    private String tableWhitelist;
    @UriParam(label="consumer,sqlserver")
    private String databaseServerTimezone;
    @UriParam(label="consumer,sqlserver", defaultValue="false")
    private boolean tombstonesOnDelete = false;
    @UriParam(label="consumer,sqlserver", defaultValue="precise")
    private String decimalHandlingMode = "precise";
    @UriParam(label="consumer,sqlserver", defaultValue="500ms", javaType="java.time.Duration")
    private long pollIntervalMs = 500L;
    @UriParam(label="consumer,sqlserver", defaultValue="100ms", javaType="java.time.Duration")
    private int databaseHistoryKafkaRecoveryPollIntervalMs = 100;
    @UriParam(label="consumer,sqlserver")
    private String converters;
    @UriParam(label="consumer,sqlserver", defaultValue="__debezium-heartbeat")
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    @UriParam(label="consumer,sqlserver", defaultValue="true")
    private boolean tableIgnoreBuiltin = true;
    @UriParam(label="consumer,sqlserver")
    private int snapshotFetchSize;
    @UriParam(label="consumer,sqlserver", defaultValue="10s", javaType="java.time.Duration")
    private long snapshotLockTimeoutMs = 10000L;
    @UriParam(label="consumer,sqlserver", defaultValue="commit")
    private String sourceTimestampMode = "commit";
    @UriParam(label="consumer,sqlserver")
    private String databaseHistoryFileFilename;
    @UriParam(label="consumer,sqlserver")
    private String databaseDbname;
    @UriParam(label="consumer,sqlserver")
    private String databaseUser;
    @UriParam(label="consumer,sqlserver", defaultValue="false")
    private boolean sanitizeFieldNames = false;
    @UriParam(label="consumer,sqlserver")
    private String snapshotSelectStatementOverrides;
    @UriParam(label="consumer,sqlserver")
    private String databaseHistoryKafkaBootstrapServers;
    @UriParam(label="consumer,sqlserver", defaultValue="adaptive")
    private String timePrecisionMode = "adaptive";
    @UriParam(label="consumer,sqlserver")
    @Metadata(required=true)
    private String databaseServerName;
    @UriParam(label="consumer,sqlserver", defaultValue="fail")
    private String eventProcessingFailureHandlingMode = "fail";
    @UriParam(label="consumer,sqlserver", defaultValue="repeatable_read")
    private String snapshotIsolationMode = "repeatable_read";
    @UriParam(label="consumer,sqlserver", defaultValue="v2")
    private String sourceStructVersion = "v2";
    @UriParam(label="consumer,sqlserver", defaultValue="0ms", javaType="java.time.Duration")
    private int heartbeatIntervalMs = 0;
    @UriParam(label="consumer,sqlserver")
    private String columnWhitelist;
    @UriParam(label="consumer,sqlserver", defaultValue="1433")
    private int databasePort = 1433;
    @UriParam(label="consumer,sqlserver")
    private String databaseHostname;
    @UriParam(label="consumer,sqlserver")
    @Metadata(required=true)
    private String databasePassword;
    @UriParam(label="consumer,sqlserver", defaultValue="2048")
    private int maxBatchSize = 2048;
    @UriParam(label="consumer,sqlserver")
    private String skippedOperations;
    @UriParam(label="consumer,sqlserver", defaultValue="initial")
    private String snapshotMode = "initial";
    @UriParam(label="consumer,sqlserver", defaultValue="io.debezium.relational.history.FileDatabaseHistory")
    private String databaseHistory = "io.debezium.relational.history.FileDatabaseHistory";

    public void setMessageKeyColumns(String messageKeyColumns) {
        this.messageKeyColumns = messageKeyColumns;
    }

    public String getMessageKeyColumns() {
        return this.messageKeyColumns;
    }

    public void setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public void setDatabaseHistoryKafkaTopic(String databaseHistoryKafkaTopic) {
        this.databaseHistoryKafkaTopic = databaseHistoryKafkaTopic;
    }

    public String getDatabaseHistoryKafkaTopic() {
        return this.databaseHistoryKafkaTopic;
    }

    public void setColumnBlacklist(String columnBlacklist) {
        this.columnBlacklist = columnBlacklist;
    }

    public String getColumnBlacklist() {
        return this.columnBlacklist;
    }

    public void setSnapshotDelayMs(long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public long getSnapshotDelayMs() {
        return this.snapshotDelayMs;
    }

    public void setDatabaseHistoryKafkaRecoveryAttempts(int databaseHistoryKafkaRecoveryAttempts) {
        this.databaseHistoryKafkaRecoveryAttempts = databaseHistoryKafkaRecoveryAttempts;
    }

    public int getDatabaseHistoryKafkaRecoveryAttempts() {
        return this.databaseHistoryKafkaRecoveryAttempts;
    }

    public void setTableBlacklist(String tableBlacklist) {
        this.tableBlacklist = tableBlacklist;
    }

    public String getTableBlacklist() {
        return this.tableBlacklist;
    }

    public void setProvideTransactionMetadata(boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public boolean isProvideTransactionMetadata() {
        return this.provideTransactionMetadata;
    }

    public void setIncludeSchemaChanges(boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
    }

    public boolean isIncludeSchemaChanges() {
        return this.includeSchemaChanges;
    }

    public void setTableWhitelist(String tableWhitelist) {
        this.tableWhitelist = tableWhitelist;
    }

    public String getTableWhitelist() {
        return this.tableWhitelist;
    }

    public void setDatabaseServerTimezone(String databaseServerTimezone) {
        this.databaseServerTimezone = databaseServerTimezone;
    }

    public String getDatabaseServerTimezone() {
        return this.databaseServerTimezone;
    }

    public void setTombstonesOnDelete(boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public boolean isTombstonesOnDelete() {
        return this.tombstonesOnDelete;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getDecimalHandlingMode() {
        return this.decimalHandlingMode;
    }

    public void setPollIntervalMs(long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public long getPollIntervalMs() {
        return this.pollIntervalMs;
    }

    public void setDatabaseHistoryKafkaRecoveryPollIntervalMs(int databaseHistoryKafkaRecoveryPollIntervalMs) {
        this.databaseHistoryKafkaRecoveryPollIntervalMs = databaseHistoryKafkaRecoveryPollIntervalMs;
    }

    public int getDatabaseHistoryKafkaRecoveryPollIntervalMs() {
        return this.databaseHistoryKafkaRecoveryPollIntervalMs;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getConverters() {
        return this.converters;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public String getHeartbeatTopicsPrefix() {
        return this.heartbeatTopicsPrefix;
    }

    public void setTableIgnoreBuiltin(boolean tableIgnoreBuiltin) {
        this.tableIgnoreBuiltin = tableIgnoreBuiltin;
    }

    public boolean isTableIgnoreBuiltin() {
        return this.tableIgnoreBuiltin;
    }

    public void setSnapshotFetchSize(int snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public int getSnapshotFetchSize() {
        return this.snapshotFetchSize;
    }

    public void setSnapshotLockTimeoutMs(long snapshotLockTimeoutMs) {
        this.snapshotLockTimeoutMs = snapshotLockTimeoutMs;
    }

    public long getSnapshotLockTimeoutMs() {
        return this.snapshotLockTimeoutMs;
    }

    public void setSourceTimestampMode(String sourceTimestampMode) {
        this.sourceTimestampMode = sourceTimestampMode;
    }

    public String getSourceTimestampMode() {
        return this.sourceTimestampMode;
    }

    public void setDatabaseHistoryFileFilename(String databaseHistoryFileFilename) {
        this.databaseHistoryFileFilename = databaseHistoryFileFilename;
    }

    public String getDatabaseHistoryFileFilename() {
        return this.databaseHistoryFileFilename;
    }

    public void setDatabaseDbname(String databaseDbname) {
        this.databaseDbname = databaseDbname;
    }

    public String getDatabaseDbname() {
        return this.databaseDbname;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatabaseUser() {
        return this.databaseUser;
    }

    public void setSanitizeFieldNames(boolean sanitizeFieldNames) {
        this.sanitizeFieldNames = sanitizeFieldNames;
    }

    public boolean isSanitizeFieldNames() {
        return this.sanitizeFieldNames;
    }

    public void setSnapshotSelectStatementOverrides(String snapshotSelectStatementOverrides) {
        this.snapshotSelectStatementOverrides = snapshotSelectStatementOverrides;
    }

    public String getSnapshotSelectStatementOverrides() {
        return this.snapshotSelectStatementOverrides;
    }

    public void setDatabaseHistoryKafkaBootstrapServers(String databaseHistoryKafkaBootstrapServers) {
        this.databaseHistoryKafkaBootstrapServers = databaseHistoryKafkaBootstrapServers;
    }

    public String getDatabaseHistoryKafkaBootstrapServers() {
        return this.databaseHistoryKafkaBootstrapServers;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public String getTimePrecisionMode() {
        return this.timePrecisionMode;
    }

    public void setDatabaseServerName(String databaseServerName) {
        this.databaseServerName = databaseServerName;
    }

    public String getDatabaseServerName() {
        return this.databaseServerName;
    }

    public void setEventProcessingFailureHandlingMode(String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return this.eventProcessingFailureHandlingMode;
    }

    public void setSnapshotIsolationMode(String snapshotIsolationMode) {
        this.snapshotIsolationMode = snapshotIsolationMode;
    }

    public String getSnapshotIsolationMode() {
        return this.snapshotIsolationMode;
    }

    public void setSourceStructVersion(String sourceStructVersion) {
        this.sourceStructVersion = sourceStructVersion;
    }

    public String getSourceStructVersion() {
        return this.sourceStructVersion;
    }

    public void setHeartbeatIntervalMs(int heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public int getHeartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    public void setColumnWhitelist(String columnWhitelist) {
        this.columnWhitelist = columnWhitelist;
    }

    public String getColumnWhitelist() {
        return this.columnWhitelist;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public void setDatabaseHostname(String databaseHostname) {
        this.databaseHostname = databaseHostname;
    }

    public String getDatabaseHostname() {
        return this.databaseHostname;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public int getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public String getSkippedOperations() {
        return this.skippedOperations;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotMode() {
        return this.snapshotMode;
    }

    public void setDatabaseHistory(String databaseHistory) {
        this.databaseHistory = databaseHistory;
    }

    public String getDatabaseHistory() {
        return this.databaseHistory;
    }

    protected Configuration createConnectorConfiguration() {
        Configuration.Builder configBuilder = Configuration.create();
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"message.key.columns", (Object)this.messageKeyColumns);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.queue.size", (Object)this.maxQueueSize);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.topic", (Object)this.databaseHistoryKafkaTopic);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.blacklist", (Object)this.columnBlacklist);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.delay.ms", (Object)this.snapshotDelayMs);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.recovery.attempts", (Object)this.databaseHistoryKafkaRecoveryAttempts);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.blacklist", (Object)this.tableBlacklist);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"provide.transaction.metadata", (Object)this.provideTransactionMetadata);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"include.schema.changes", (Object)this.includeSchemaChanges);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.whitelist", (Object)this.tableWhitelist);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.server.timezone", (Object)this.databaseServerTimezone);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"tombstones.on.delete", (Object)this.tombstonesOnDelete);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"decimal.handling.mode", (Object)this.decimalHandlingMode);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"poll.interval.ms", (Object)this.pollIntervalMs);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.recovery.poll.interval.ms", (Object)this.databaseHistoryKafkaRecoveryPollIntervalMs);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"converters", (Object)this.converters);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.topics.prefix", (Object)this.heartbeatTopicsPrefix);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"table.ignore.builtin", (Object)this.tableIgnoreBuiltin);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.fetch.size", (Object)this.snapshotFetchSize);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.lock.timeout.ms", (Object)this.snapshotLockTimeoutMs);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"source.timestamp.mode", (Object)this.sourceTimestampMode);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.file.filename", (Object)this.databaseHistoryFileFilename);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.dbname", (Object)this.databaseDbname);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.user", (Object)this.databaseUser);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"sanitize.field.names", (Object)this.sanitizeFieldNames);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.select.statement.overrides", (Object)this.snapshotSelectStatementOverrides);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history.kafka.bootstrap.servers", (Object)this.databaseHistoryKafkaBootstrapServers);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"time.precision.mode", (Object)this.timePrecisionMode);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.server.name", (Object)this.databaseServerName);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"event.processing.failure.handling.mode", (Object)this.eventProcessingFailureHandlingMode);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.isolation.mode", (Object)this.snapshotIsolationMode);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"source.struct.version", (Object)this.sourceStructVersion);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"heartbeat.interval.ms", (Object)this.heartbeatIntervalMs);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"column.whitelist", (Object)this.columnWhitelist);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.port", (Object)this.databasePort);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.hostname", (Object)this.databaseHostname);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.password", (Object)this.databasePassword);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"max.batch.size", (Object)this.maxBatchSize);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"skipped.operations", (Object)this.skippedOperations);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"snapshot.mode", (Object)this.snapshotMode);
        SqlServerConnectorEmbeddedDebeziumConfiguration.addPropertyIfNotNull((Configuration.Builder)configBuilder, (String)"database.history", (Object)this.databaseHistory);
        return configBuilder.build();
    }

    protected Class configureConnectorClass() {
        return SqlServerConnector.class;
    }

    protected ConfigurationValidation validateConnectorConfiguration() {
        if (SqlServerConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.databaseServerName)) {
            return ConfigurationValidation.notValid((String)"Required field 'databaseServerName' must be set.");
        }
        if (SqlServerConnectorEmbeddedDebeziumConfiguration.isFieldValueNotSet((Object)this.databasePassword)) {
            return ConfigurationValidation.notValid((String)"Required field 'databasePassword' must be set.");
        }
        return ConfigurationValidation.valid();
    }

    public String getConnectorDatabaseType() {
        return "sqlserver";
    }
}

