/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk.internal;

import java.io.File;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;
import org.asynchttpclient.ListenableFuture;
import org.zendesk.client.v2.Zendesk;
import org.zendesk.client.v2.model.Attachment;
import org.zendesk.client.v2.model.Audit;
import org.zendesk.client.v2.model.Automation;
import org.zendesk.client.v2.model.Comment;
import org.zendesk.client.v2.model.Field;
import org.zendesk.client.v2.model.Forum;
import org.zendesk.client.v2.model.Group;
import org.zendesk.client.v2.model.GroupMembership;
import org.zendesk.client.v2.model.Identity;
import org.zendesk.client.v2.model.JobStatus;
import org.zendesk.client.v2.model.Macro;
import org.zendesk.client.v2.model.Metric;
import org.zendesk.client.v2.model.Organization;
import org.zendesk.client.v2.model.OrganizationMembership;
import org.zendesk.client.v2.model.Request;
import org.zendesk.client.v2.model.SatisfactionRating;
import org.zendesk.client.v2.model.SuspendedTicket;
import org.zendesk.client.v2.model.Ticket;
import org.zendesk.client.v2.model.TicketForm;
import org.zendesk.client.v2.model.TicketImport;
import org.zendesk.client.v2.model.Topic;
import org.zendesk.client.v2.model.Trigger;
import org.zendesk.client.v2.model.User;
import org.zendesk.client.v2.model.hc.Article;
import org.zendesk.client.v2.model.hc.ArticleAttachments;
import org.zendesk.client.v2.model.hc.Category;
import org.zendesk.client.v2.model.hc.Section;
import org.zendesk.client.v2.model.hc.Translation;
import org.zendesk.client.v2.model.schedules.Schedule;
import org.zendesk.client.v2.model.targets.Target;

public enum ZendeskApiMethod implements ApiMethod
{
    ADDTAGTOORGANISATIONS(List.class, "addTagToOrganisations", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    ADDTAGTOTICKET(List.class, "addTagToTicket", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    ADDTAGTOTOPICS(List.class, "addTagToTopics", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    ASSOCIATEATTACHMENTSTOARTICLE(Void.TYPE, "associateAttachmentsToArticle", ApiMethodArg.arg((String)"idArticle", String.class), ApiMethodArg.arg((String)"attachments", List.class)),
    CHANGEUSERPASSWORD(Void.TYPE, "changeUserPassword", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"oldPassword", String.class), ApiMethodArg.arg((String)"newPassword", String.class)),
    CREATEARTICLE(Article.class, "createArticle", ApiMethodArg.arg((String)"article", Article.class)),
    CREATEARTICLETRANSLATION(Translation.class, "createArticleTranslation", ApiMethodArg.arg((String)"articleId", Long.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    CREATEAUTOMATION(Automation.class, "createAutomation", ApiMethodArg.arg((String)"automation", Automation.class)),
    CREATECATEGORY(Category.class, "createCategory", ApiMethodArg.arg((String)"category", Category.class)),
    CREATECATEGORYTRANSLATION(Translation.class, "createCategoryTranslation", ApiMethodArg.arg((String)"categoryId", Long.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    CREATECOMMENT(Ticket.class, "createComment", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"comment", Comment.class)),
    CREATEFORUM(Forum.class, "createForum", ApiMethodArg.arg((String)"forum", Forum.class)),
    CREATEGROUP(Group.class, "createGroup", ApiMethodArg.arg((String)"group", Group.class)),
    CREATEGROUPMEMBERSHIP(GroupMembership.class, "createGroupMembership", ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    CREATEGROUPMEMBERSHIP_1(GroupMembership.class, "createGroupMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    CREATEMACRO(Macro.class, "createMacro", ApiMethodArg.arg((String)"macro", Macro.class)),
    CREATEORUPDATEUSER(User.class, "createOrUpdateUser", ApiMethodArg.arg((String)"user", User.class)),
    CREATEORGANIZATION(Organization.class, "createOrganization", ApiMethodArg.arg((String)"organization", Organization.class)),
    CREATEORGANIZATIONMEMBERSHIP(OrganizationMembership.class, "createOrganizationMembership", ApiMethodArg.arg((String)"organizationMembership", OrganizationMembership.class)),
    CREATEORGANIZATIONMEMBERSHIP_1(OrganizationMembership.class, "createOrganizationMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organizationMembership", OrganizationMembership.class)),
    CREATEORGANIZATIONS(JobStatus.class, "createOrganizations", ApiMethodArg.arg((String)"organizationList", List.class)),
    CREATEORGANIZATIONS_1(JobStatus.class, "createOrganizations", ApiMethodArg.arg((String)"organizations", new Organization[0].getClass())),
    CREATEORGANIZATIONSASYNC(ListenableFuture.class, "createOrganizationsAsync", ApiMethodArg.arg((String)"organizationList", List.class)),
    CREATEREQUEST(Request.class, "createRequest", ApiMethodArg.arg((String)"request", Request.class)),
    CREATESATISFACTIONRATING(SatisfactionRating.class, "createSatisfactionRating", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"satisfactionRating", SatisfactionRating.class)),
    CREATESATISFACTIONRATING_1(SatisfactionRating.class, "createSatisfactionRating", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"satisfactionRating", SatisfactionRating.class)),
    CREATESECTION(Section.class, "createSection", ApiMethodArg.arg((String)"section", Section.class)),
    CREATESECTIONTRANSLATION(Translation.class, "createSectionTranslation", ApiMethodArg.arg((String)"sectionId", Long.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    CREATETARGET(Target.class, "createTarget", ApiMethodArg.arg((String)"target", Target.class)),
    CREATETICKET(Ticket.class, "createTicket", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    CREATETICKETASYNC(ListenableFuture.class, "createTicketAsync", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    CREATETICKETFIELD(Field.class, "createTicketField", ApiMethodArg.arg((String)"field", Field.class)),
    CREATETICKETFORM(TicketForm.class, "createTicketForm", ApiMethodArg.arg((String)"ticketForm", TicketForm.class)),
    CREATETICKETFROMTWEET(Ticket.class, "createTicketFromTweet", ApiMethodArg.arg((String)"tweetId", Long.TYPE), ApiMethodArg.arg((String)"monitorId", Long.TYPE)),
    CREATETICKETS(JobStatus.class, "createTickets", ApiMethodArg.arg((String)"ticketList", List.class)),
    CREATETICKETS_1(JobStatus.class, "createTickets", ApiMethodArg.arg((String)"tickets", new Ticket[0].getClass())),
    CREATETICKETSASYNC(ListenableFuture.class, "createTicketsAsync", ApiMethodArg.arg((String)"ticketList", List.class)),
    CREATETOPIC(Topic.class, "createTopic", ApiMethodArg.arg((String)"topic", Topic.class)),
    CREATETRIGGER(Trigger.class, "createTrigger", ApiMethodArg.arg((String)"trigger", Trigger.class)),
    CREATEUPLOAD(Attachment.Upload.class, "createUpload", ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"content", new byte[0].getClass())),
    CREATEUPLOAD_1(Attachment.Upload.class, "createUpload", ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"contentType", String.class), ApiMethodArg.arg((String)"content", new byte[0].getClass())),
    CREATEUPLOAD_2(Attachment.Upload.class, "createUpload", ApiMethodArg.arg((String)"token", String.class), ApiMethodArg.arg((String)"fileName", String.class), ApiMethodArg.arg((String)"contentType", String.class), ApiMethodArg.arg((String)"content", new byte[0].getClass())),
    CREATEUPLOADARTICLE(ArticleAttachments.class, "createUploadArticle", ApiMethodArg.arg((String)"articleId0", Long.TYPE), ApiMethodArg.arg((String)"file", File.class)),
    CREATEUPLOADARTICLE_1(ArticleAttachments.class, "createUploadArticle", ApiMethodArg.arg((String)"articleId0", Long.TYPE), ApiMethodArg.arg((String)"file", File.class), ApiMethodArg.arg((String)"inline", Boolean.TYPE)),
    CREATEUSER(User.class, "createUser", ApiMethodArg.arg((String)"user", User.class)),
    CREATEUSERIDENTITY(Identity.class, "createUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    CREATEUSERIDENTITY_1(Identity.class, "createUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identity", Identity.class)),
    CREATEUSERS(JobStatus.class, "createUsers", ApiMethodArg.arg((String)"userList", List.class)),
    CREATEUSERS_1(JobStatus.class, "createUsers", ApiMethodArg.arg((String)"users", new User[0].getClass())),
    CREATEUSERSASYNC(ListenableFuture.class, "createUsersAsync", ApiMethodArg.arg((String)"userList", List.class)),
    DELETEARTICLE(Void.TYPE, "deleteArticle", ApiMethodArg.arg((String)"article", Article.class)),
    DELETEARTICLEATTACHMENT(Void.TYPE, "deleteArticleAttachment", ApiMethodArg.arg((String)"articleAttachments", ArticleAttachments.class)),
    DELETEARTICLEATTACHMENT_1(Void.TYPE, "deleteArticleAttachment", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETEATTACHMENT(Void.TYPE, "deleteAttachment", ApiMethodArg.arg((String)"attachment", Attachment.class)),
    DELETEATTACHMENT_1(Void.TYPE, "deleteAttachment", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETEAUTOMATION(Void.TYPE, "deleteAutomation", ApiMethodArg.arg((String)"automationId0", Long.TYPE)),
    DELETECATEGORY(Void.TYPE, "deleteCategory", ApiMethodArg.arg((String)"category", Category.class)),
    DELETEFORUM(Void.TYPE, "deleteForum", ApiMethodArg.arg((String)"forum", Forum.class)),
    DELETEGROUP(Void.TYPE, "deleteGroup", ApiMethodArg.arg((String)"group", Group.class)),
    DELETEGROUP_1(Void.TYPE, "deleteGroup", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETEGROUPMEMBERSHIP(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    DELETEGROUPMEMBERSHIP_1(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETEGROUPMEMBERSHIP_2(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    DELETEGROUPMEMBERSHIP_3(Void.TYPE, "deleteGroupMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"group_membership_id", Long.TYPE)),
    DELETEORGANIZATION(Void.TYPE, "deleteOrganization", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETEORGANIZATION_1(Void.TYPE, "deleteOrganization", ApiMethodArg.arg((String)"organization", Organization.class)),
    DELETEORGANIZATIONMEMBERSHIP(Void.TYPE, "deleteOrganizationMembership", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETEORGANIZATIONMEMBERSHIP_1(Void.TYPE, "deleteOrganizationMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organizationMembership", OrganizationMembership.class)),
    DELETEORGANIZATIONMEMBERSHIP_2(Void.TYPE, "deleteOrganizationMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organization_membership_id", Long.TYPE)),
    DELETESECTION(Void.TYPE, "deleteSection", ApiMethodArg.arg((String)"section", Section.class)),
    DELETESUSPENDEDTICKET(Void.TYPE, "deleteSuspendedTicket", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETESUSPENDEDTICKET_1(Void.TYPE, "deleteSuspendedTicket", ApiMethodArg.arg((String)"suspendedTicket", SuspendedTicket.class)),
    DELETETARGET(Void.TYPE, "deleteTarget", ApiMethodArg.arg((String)"targetId", Long.TYPE)),
    DELETETICKET(Void.TYPE, "deleteTicket", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETETICKET_1(Void.TYPE, "deleteTicket", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    DELETETICKETFIELD(Void.TYPE, "deleteTicketField", ApiMethodArg.arg((String)"field", Field.class)),
    DELETETICKETFIELD_1(Void.TYPE, "deleteTicketField", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETETICKETS(Void.TYPE, "deleteTickets", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", new long[0].getClass())),
    DELETETOPIC(Void.TYPE, "deleteTopic", ApiMethodArg.arg((String)"topic", Topic.class)),
    DELETETRIGGER(Void.TYPE, "deleteTrigger", ApiMethodArg.arg((String)"triggerId", Long.TYPE)),
    DELETEUPLOAD(Void.TYPE, "deleteUpload", ApiMethodArg.arg((String)"token", String.class)),
    DELETEUPLOAD_1(Void.TYPE, "deleteUpload", ApiMethodArg.arg((String)"upload", Attachment.Upload.class)),
    DELETEUSER(Void.TYPE, "deleteUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    DELETEUSER_1(Void.TYPE, "deleteUser", ApiMethodArg.arg((String)"user", User.class)),
    DELETEUSERIDENTITY(Void.TYPE, "deleteUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    DELETEUSERIDENTITY_1(Void.TYPE, "deleteUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    DELETEUSERIDENTITY_2(Void.TYPE, "deleteUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    GETARTICLE(Article.class, "getArticle", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETARTICLEFROMSEARCH(Iterable.class, "getArticleFromSearch", ApiMethodArg.arg((String)"searchTerm", String.class)),
    GETARTICLEFROMSEARCH_1(Iterable.class, "getArticleFromSearch", ApiMethodArg.arg((String)"searchTerm", String.class), ApiMethodArg.arg((String)"sectionId", Long.class)),
    GETARTICLESUBSCRIPTIONS(Iterable.class, "getArticleSubscriptions", ApiMethodArg.arg((String)"articleId", Long.class)),
    GETARTICLESUBSCRIPTIONS_1(Iterable.class, "getArticleSubscriptions", ApiMethodArg.arg((String)"articleId", Long.class), ApiMethodArg.arg((String)"locale", String.class)),
    GETARTICLETRANSLATIONS(Iterable.class, "getArticleTranslations", ApiMethodArg.arg((String)"articleId", Long.class)),
    GETARTICLES(Iterable.class, "getArticles", new ApiMethodArg[0]),
    GETARTICLES_1(Iterable.class, "getArticles", ApiMethodArg.arg((String)"category", Category.class)),
    GETARTICLESFROMPAGE(List.class, "getArticlesFromPage", ApiMethodArg.arg((String)"page", Integer.TYPE)),
    GETARTICLESINCREMENTALLY(Iterable.class, "getArticlesIncrementally", ApiMethodArg.arg((String)"startTime", Date.class)),
    GETASSIGNABLEGROUPMEMBERSHIPS(Iterable.class, "getAssignableGroupMemberships", new ApiMethodArg[0]),
    GETASSIGNABLEGROUPMEMBERSHIPS_1(List.class, "getAssignableGroupMemberships", ApiMethodArg.arg((String)"group_id", Long.TYPE)),
    GETASSIGNABLEGROUPS(Iterable.class, "getAssignableGroups", new ApiMethodArg[0]),
    GETATTACHMENT(Attachment.class, "getAttachment", ApiMethodArg.arg((String)"attachment", Attachment.class)),
    GETATTACHMENT_1(Attachment.class, "getAttachment", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETATTACHMENTSFROMARTICLE(List.class, "getAttachmentsFromArticle", ApiMethodArg.arg((String)"articleId", Long.class)),
    GETAUTHENTICATEDUSER(User.class, "getAuthenticatedUser", new ApiMethodArg[0]),
    GETAUTOCOMPLETEORGANIZATIONS(Iterable.class, "getAutoCompleteOrganizations", ApiMethodArg.arg((String)"name", String.class)),
    GETAUTOMATION(Automation.class, "getAutomation", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETAUTOMATIONS(Iterable.class, "getAutomations", new ApiMethodArg[0]),
    GETBRANDS(List.class, "getBrands", new ApiMethodArg[0]),
    GETCCREQUESTS(Iterable.class, "getCCRequests", new ApiMethodArg[0]),
    GETCATEGORIES(Iterable.class, "getCategories", new ApiMethodArg[0]),
    GETCATEGORY(Category.class, "getCategory", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETCATEGORYTRANSLATIONS(Iterable.class, "getCategoryTranslations", ApiMethodArg.arg((String)"categoryId", Long.class)),
    GETCURRENTUSER(User.class, "getCurrentUser", new ApiMethodArg[0]),
    GETCUSTOMAGENTROLES(Iterable.class, "getCustomAgentRoles", new ApiMethodArg[0]),
    GETFORUM(Forum.class, "getForum", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETFORUMS(Iterable.class, "getForums", new ApiMethodArg[0]),
    GETFORUMS_1(List.class, "getForums", ApiMethodArg.arg((String)"category_id", Long.TYPE)),
    GETGROUP(Group.class, "getGroup", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETGROUPMEMBERSHIP(GroupMembership.class, "getGroupMembership", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETGROUPMEMBERSHIP_1(GroupMembership.class, "getGroupMembership", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"group_membership_id", Long.TYPE)),
    GETGROUPMEMBERSHIPBYUSER(List.class, "getGroupMembershipByUser", ApiMethodArg.arg((String)"user_id", Long.TYPE)),
    GETGROUPMEMBERSHIPS(Iterable.class, "getGroupMemberships", new ApiMethodArg[0]),
    GETGROUPMEMBERSHIPS_1(List.class, "getGroupMemberships", ApiMethodArg.arg((String)"group_id", Long.TYPE)),
    GETGROUPORGANIZATION(OrganizationMembership.class, "getGroupOrganization", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organization_membership_id", Long.TYPE)),
    GETGROUPUSERS(Iterable.class, "getGroupUsers", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETGROUPS(Iterable.class, "getGroups", new ApiMethodArg[0]),
    GETHOLIDAYSFORSCHEDULE(Iterable.class, "getHolidaysForSchedule", ApiMethodArg.arg((String)"schedule", Schedule.class)),
    GETHOLIDAYSFORSCHEDULE_1(Iterable.class, "getHolidaysForSchedule", ApiMethodArg.arg((String)"scheduleId", Long.class)),
    GETINCREMENTALTICKETSRESULT(Map.class, "getIncrementalTicketsResult", ApiMethodArg.arg((String)"unixEpochTime", Long.TYPE)),
    GETJOBSTATUS(JobStatus.class, "getJobStatus", ApiMethodArg.arg((String)"status", JobStatus.class)),
    GETJOBSTATUSASYNC(ListenableFuture.class, "getJobStatusAsync", ApiMethodArg.arg((String)"status", JobStatus.class)),
    GETJOBSTATUSES(List.class, "getJobStatuses", ApiMethodArg.arg((String)"statuses", List.class)),
    GETJOBSTATUSESASYNC(ListenableFuture.class, "getJobStatusesAsync", ApiMethodArg.arg((String)"statuses", List.class)),
    GETMACRO(Macro.class, "getMacro", ApiMethodArg.arg((String)"macroId", Long.TYPE)),
    GETMACROS(Iterable.class, "getMacros", new ApiMethodArg[0]),
    GETOPENREQUESTS(Iterable.class, "getOpenRequests", new ApiMethodArg[0]),
    GETORGANIZATION(Organization.class, "getOrganization", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETORGANIZATIONFIELDS(Iterable.class, "getOrganizationFields", new ApiMethodArg[0]),
    GETORGANIZATIONMEMBERSHIP(OrganizationMembership.class, "getOrganizationMembership", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETORGANIZATIONMEMBERSHIPBYUSER(List.class, "getOrganizationMembershipByUser", ApiMethodArg.arg((String)"user_id", Long.TYPE)),
    GETORGANIZATIONMEMBERSHIPFORUSER(OrganizationMembership.class, "getOrganizationMembershipForUser", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETORGANIZATIONMEMBERSHIPS(Iterable.class, "getOrganizationMemberships", new ApiMethodArg[0]),
    GETORGANIZATIONMEMBERSHIPSFORORG(Iterable.class, "getOrganizationMembershipsForOrg", ApiMethodArg.arg((String)"organization_id", Long.TYPE)),
    GETORGANIZATIONMEMBERSHIPSFORUSER(Iterable.class, "getOrganizationMembershipsForUser", ApiMethodArg.arg((String)"user_id", Long.TYPE)),
    GETORGANIZATIONTICKETS(Iterable.class, "getOrganizationTickets", ApiMethodArg.arg((String)"organizationId", Long.TYPE)),
    GETORGANIZATIONUSERS(Iterable.class, "getOrganizationUsers", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETORGANIZATIONS(Iterable.class, "getOrganizations", new ApiMethodArg[0]),
    GETORGANIZATIONSINCREMENTALLY(Iterable.class, "getOrganizationsIncrementally", ApiMethodArg.arg((String)"startTime", Date.class)),
    GETRECENTTICKETS(Iterable.class, "getRecentTickets", new ApiMethodArg[0]),
    GETREQUEST(Request.class, "getRequest", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETREQUESTCOMMENT(Comment.class, "getRequestComment", ApiMethodArg.arg((String)"request", Request.class), ApiMethodArg.arg((String)"comment", Comment.class)),
    GETREQUESTCOMMENT_1(Comment.class, "getRequestComment", ApiMethodArg.arg((String)"request", Request.class), ApiMethodArg.arg((String)"commentId", Long.TYPE)),
    GETREQUESTCOMMENT_2(Comment.class, "getRequestComment", ApiMethodArg.arg((String)"requestId", Long.TYPE), ApiMethodArg.arg((String)"commentId", Long.TYPE)),
    GETREQUESTCOMMENTS(Iterable.class, "getRequestComments", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETREQUESTCOMMENTS_1(Iterable.class, "getRequestComments", ApiMethodArg.arg((String)"request", Request.class)),
    GETREQUESTS(Iterable.class, "getRequests", new ApiMethodArg[0]),
    GETSATISFACTIONRATING(SatisfactionRating.class, "getSatisfactionRating", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETSATISFACTIONRATINGS(Iterable.class, "getSatisfactionRatings", new ApiMethodArg[0]),
    GETSCHEDULE(Schedule.class, "getSchedule", ApiMethodArg.arg((String)"schedule", Schedule.class)),
    GETSCHEDULE_1(Schedule.class, "getSchedule", ApiMethodArg.arg((String)"scheduleId", Long.class)),
    GETSCHEDULES(Iterable.class, "getSchedules", new ApiMethodArg[0]),
    GETSEARCHRESULTS(Iterable.class, "getSearchResults", ApiMethodArg.arg((String)"query", String.class)),
    GETSEARCHRESULTS_1(Iterable.class, "getSearchResults", ApiMethodArg.arg((String)"type", Class.class), ApiMethodArg.arg((String)"query", String.class)),
    GETSEARCHRESULTS_2(Iterable.class, "getSearchResults", ApiMethodArg.arg((String)"type", Class.class), ApiMethodArg.arg((String)"query", String.class), ApiMethodArg.arg((String)"params", String.class)),
    GETSECTION(Section.class, "getSection", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETSECTIONSUBSCRIPTIONS(Iterable.class, "getSectionSubscriptions", ApiMethodArg.arg((String)"sectionId", Long.class)),
    GETSECTIONSUBSCRIPTIONS_1(Iterable.class, "getSectionSubscriptions", ApiMethodArg.arg((String)"sectionId", Long.class), ApiMethodArg.arg((String)"locale", String.class)),
    GETSECTIONTRANSLATIONS(Iterable.class, "getSectionTranslations", ApiMethodArg.arg((String)"sectionId", Long.class)),
    GETSECTIONS(Iterable.class, "getSections", new ApiMethodArg[0]),
    GETSECTIONS_1(Iterable.class, "getSections", ApiMethodArg.arg((String)"category", Category.class)),
    GETSOLVEDREQUESTS(Iterable.class, "getSolvedRequests", new ApiMethodArg[0]),
    GETSUSPENDEDTICKETS(Iterable.class, "getSuspendedTickets", new ApiMethodArg[0]),
    GETTARGET(Target.class, "getTarget", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTARGETS(Iterable.class, "getTargets", new ApiMethodArg[0]),
    GETTICKET(Ticket.class, "getTicket", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTICKETAUDIT(Audit.class, "getTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"audit", Audit.class)),
    GETTICKETAUDIT_1(Audit.class, "getTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTICKETAUDIT_2(Audit.class, "getTicketAudit", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"auditId", Long.TYPE)),
    GETTICKETAUDITS(Iterable.class, "getTicketAudits", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    GETTICKETAUDITS_1(Iterable.class, "getTicketAudits", ApiMethodArg.arg((String)"ticketId0", Long.class)),
    GETTICKETCOLLABORATORS(List.class, "getTicketCollaborators", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTICKETCOMMENTS(Iterable.class, "getTicketComments", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTICKETFIELD(Field.class, "getTicketField", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTICKETFIELDS(List.class, "getTicketFields", new ApiMethodArg[0]),
    GETTICKETFORM(TicketForm.class, "getTicketForm", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTICKETFORMS(List.class, "getTicketForms", new ApiMethodArg[0]),
    GETTICKETINCIDENTS(List.class, "getTicketIncidents", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTICKETMETRIC(Metric.class, "getTicketMetric", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTICKETMETRICBYTICKET(Metric.class, "getTicketMetricByTicket", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTICKETMETRICS(Iterable.class, "getTicketMetrics", new ApiMethodArg[0]),
    GETTICKETS(Iterable.class, "getTickets", new ApiMethodArg[0]),
    GETTICKETS_1(List.class, "getTickets", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", new long[0].getClass())),
    GETTICKETSBYEXTERNALID(Iterable.class, "getTicketsByExternalId", ApiMethodArg.arg((String)"externalId", String.class)),
    GETTICKETSBYEXTERNALID_1(Iterable.class, "getTicketsByExternalId", ApiMethodArg.arg((String)"externalId", String.class), ApiMethodArg.arg((String)"includeArchived", Boolean.TYPE)),
    GETTICKETSFROMSEARCH(Iterable.class, "getTicketsFromSearch", ApiMethodArg.arg((String)"searchTerm", String.class)),
    GETTICKETSINCREMENTALLY(Iterable.class, "getTicketsIncrementally", ApiMethodArg.arg((String)"startTime", Date.class)),
    GETTICKETSINCREMENTALLY_1(Iterable.class, "getTicketsIncrementally", ApiMethodArg.arg((String)"startTime", Date.class), ApiMethodArg.arg((String)"endTime", Date.class)),
    GETTOPIC(Topic.class, "getTopic", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTOPICS(Iterable.class, "getTopics", new ApiMethodArg[0]),
    GETTOPICS_1(List.class, "getTopics", ApiMethodArg.arg((String)"forum_id", Long.TYPE)),
    GETTOPICS_2(List.class, "getTopics", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"ids", new long[0].getClass())),
    GETTOPICSBYUSER(List.class, "getTopicsByUser", ApiMethodArg.arg((String)"user_id", Long.TYPE)),
    GETTRIGGER(Trigger.class, "getTrigger", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETTRIGGERS(Iterable.class, "getTriggers", new ApiMethodArg[0]),
    GETTWITTERMONITORS(Iterable.class, "getTwitterMonitors", new ApiMethodArg[0]),
    GETUSER(User.class, "getUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETUSERCCDTICKETS(Iterable.class, "getUserCCDTickets", ApiMethodArg.arg((String)"userId", Long.TYPE)),
    GETUSERFIELDS(Iterable.class, "getUserFields", new ApiMethodArg[0]),
    GETUSERIDENTITIES(List.class, "getUserIdentities", ApiMethodArg.arg((String)"user", User.class)),
    GETUSERIDENTITIES_1(List.class, "getUserIdentities", ApiMethodArg.arg((String)"userId", Long.TYPE)),
    GETUSERIDENTITY(Identity.class, "getUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    GETUSERIDENTITY_1(Identity.class, "getUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    GETUSERIDENTITY_2(Identity.class, "getUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    GETUSERREQUESTEDTICKETS(Iterable.class, "getUserRequestedTickets", ApiMethodArg.arg((String)"userId", Long.TYPE)),
    GETUSERREQUESTS(Iterable.class, "getUserRequests", ApiMethodArg.arg((String)"id", Long.TYPE)),
    GETUSERREQUESTS_1(Iterable.class, "getUserRequests", ApiMethodArg.arg((String)"user", User.class)),
    GETUSERSUBSCRIPTIONS(Iterable.class, "getUserSubscriptions", ApiMethodArg.arg((String)"user", User.class)),
    GETUSERSUBSCRIPTIONS_1(Iterable.class, "getUserSubscriptions", ApiMethodArg.arg((String)"userId0", Long.class)),
    GETUSERS(Iterable.class, "getUsers", new ApiMethodArg[0]),
    GETUSERSBYROLE(Iterable.class, "getUsersByRole", ApiMethodArg.arg((String)"role", String.class), ApiMethodArg.arg((String)"roles", new String[0].getClass())),
    GETUSERSINCREMENTALLY(Iterable.class, "getUsersIncrementally", ApiMethodArg.arg((String)"startTime", Date.class)),
    IMPORTTICKET(Ticket.class, "importTicket", ApiMethodArg.arg((String)"ticketImport", TicketImport.class)),
    IMPORTTOPIC(Topic.class, "importTopic", ApiMethodArg.arg((String)"topic", Topic.class)),
    LOOKUPORGANIZATIONSBYEXTERNALID(Iterable.class, "lookupOrganizationsByExternalId", ApiMethodArg.arg((String)"externalId", String.class)),
    LOOKUPUSERBYEMAIL(Iterable.class, "lookupUserByEmail", ApiMethodArg.arg((String)"email", String.class)),
    LOOKUPUSERBYEXTERNALID(Iterable.class, "lookupUserByExternalId", ApiMethodArg.arg((String)"externalId", String.class)),
    MACROSSHOWCHANGESTOTICKET(Ticket.class, "macrosShowChangesToTicket", ApiMethodArg.arg((String)"macroId", Long.TYPE)),
    MACROSSHOWTICKETAFTERCHANGES(Ticket.class, "macrosShowTicketAfterChanges", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"macroId", Long.TYPE)),
    MAKEPRIVATETICKETAUDIT(Void.TYPE, "makePrivateTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"audit", Audit.class)),
    MAKEPRIVATETICKETAUDIT_1(Void.TYPE, "makePrivateTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"id", Long.TYPE)),
    MAKEPRIVATETICKETAUDIT_2(Void.TYPE, "makePrivateTicketAudit", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"auditId", Long.TYPE)),
    MARKTICKETASSPAM(Void.TYPE, "markTicketAsSpam", ApiMethodArg.arg((String)"id", Long.TYPE)),
    MARKTICKETASSPAM_1(Void.TYPE, "markTicketAsSpam", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    NOTIFYAPP(Void.TYPE, "notifyApp", ApiMethodArg.arg((String)"json", String.class)),
    QUEUECREATETICKETASYNC(ListenableFuture.class, "queueCreateTicketAsync", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    REMOVETAGFROMORGANISATIONS(List.class, "removeTagFromOrganisations", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    REMOVETAGFROMTICKET(List.class, "removeTagFromTicket", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    REMOVETAGFROMTOPICS(List.class, "removeTagFromTopics", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    REQUESTVERIFYUSERIDENTITY(Identity.class, "requestVerifyUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    REQUESTVERIFYUSERIDENTITY_1(Identity.class, "requestVerifyUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    REQUESTVERIFYUSERIDENTITY_2(Identity.class, "requestVerifyUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    RESETUSERPASSWORD(Void.TYPE, "resetUserPassword", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"password", String.class)),
    RESETUSERPASSWORD_1(Void.TYPE, "resetUserPassword", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"password", String.class)),
    SETGROUPMEMBERSHIPASDEFAULT(List.class, "setGroupMembershipAsDefault", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"groupMembership", GroupMembership.class)),
    SETORGANIZATIONMEMBERSHIPASDEFAULT(List.class, "setOrganizationMembershipAsDefault", ApiMethodArg.arg((String)"user_id", Long.TYPE), ApiMethodArg.arg((String)"organizationMembership", OrganizationMembership.class)),
    SETTAGONORGANISATIONS(List.class, "setTagOnOrganisations", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    SETTAGONTICKET(List.class, "setTagOnTicket", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    SETTAGONTOPICS(List.class, "setTagOnTopics", ApiMethodArg.arg((String)"id", Long.TYPE), ApiMethodArg.arg((String)"tags", new String[0].getClass())),
    SETUSERPRIMARYIDENTITY(List.class, "setUserPrimaryIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    SETUSERPRIMARYIDENTITY_1(List.class, "setUserPrimaryIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    SETUSERPRIMARYIDENTITY_2(List.class, "setUserPrimaryIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    SUSPENDUSER(User.class, "suspendUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    TRUSTTICKETAUDIT(Void.TYPE, "trustTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"audit", Audit.class)),
    TRUSTTICKETAUDIT_1(Void.TYPE, "trustTicketAudit", ApiMethodArg.arg((String)"ticket", Ticket.class), ApiMethodArg.arg((String)"id", Long.TYPE)),
    TRUSTTICKETAUDIT_2(Void.TYPE, "trustTicketAudit", ApiMethodArg.arg((String)"ticketId", Long.TYPE), ApiMethodArg.arg((String)"auditId", Long.TYPE)),
    UNSUSPENDUSER(User.class, "unsuspendUser", ApiMethodArg.arg((String)"id", Long.TYPE)),
    UPDATEARTICLE(Article.class, "updateArticle", ApiMethodArg.arg((String)"article", Article.class)),
    UPDATEARTICLETRANSLATION(Translation.class, "updateArticleTranslation", ApiMethodArg.arg((String)"articleId", Long.class), ApiMethodArg.arg((String)"locale", String.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    UPDATEAUTOMATION(Automation.class, "updateAutomation", ApiMethodArg.arg((String)"automationId", Long.class), ApiMethodArg.arg((String)"automation", Automation.class)),
    UPDATECATEGORY(Category.class, "updateCategory", ApiMethodArg.arg((String)"category", Category.class)),
    UPDATECATEGORYTRANSLATION(Translation.class, "updateCategoryTranslation", ApiMethodArg.arg((String)"categoryId", Long.class), ApiMethodArg.arg((String)"locale", String.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    UPDATEFORUM(Forum.class, "updateForum", ApiMethodArg.arg((String)"forum", Forum.class)),
    UPDATEGROUP(Group.class, "updateGroup", ApiMethodArg.arg((String)"group", Group.class)),
    UPDATEINSTALLATION(Void.TYPE, "updateInstallation", ApiMethodArg.arg((String)"installationId", Integer.TYPE), ApiMethodArg.arg((String)"json", String.class)),
    UPDATEMACRO(Macro.class, "updateMacro", ApiMethodArg.arg((String)"macroId0", Long.class), ApiMethodArg.arg((String)"macro", Macro.class)),
    UPDATEORGANIZATION(Organization.class, "updateOrganization", ApiMethodArg.arg((String)"organization", Organization.class)),
    UPDATEREQUEST(Request.class, "updateRequest", ApiMethodArg.arg((String)"request", Request.class)),
    UPDATESECTION(Section.class, "updateSection", ApiMethodArg.arg((String)"section", Section.class)),
    UPDATESECTIONTRANSLATION(Translation.class, "updateSectionTranslation", ApiMethodArg.arg((String)"sectionId", Long.class), ApiMethodArg.arg((String)"locale", String.class), ApiMethodArg.arg((String)"translation", Translation.class)),
    UPDATETICKET(Ticket.class, "updateTicket", ApiMethodArg.arg((String)"ticket", Ticket.class)),
    UPDATETICKETFIELD(Field.class, "updateTicketField", ApiMethodArg.arg((String)"field", Field.class)),
    UPDATETOPIC(Topic.class, "updateTopic", ApiMethodArg.arg((String)"topic", Topic.class)),
    UPDATETRIGGER(Trigger.class, "updateTrigger", ApiMethodArg.arg((String)"triggerId0", Long.class), ApiMethodArg.arg((String)"trigger", Trigger.class)),
    UPDATEUSER(User.class, "updateUser", ApiMethodArg.arg((String)"user", User.class)),
    UPDATEUSERIDENTITY(Identity.class, "updateUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    UPDATEUSERIDENTITY_1(Identity.class, "updateUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identity", Identity.class)),
    VERIFYUSERIDENTITY(Identity.class, "verifyUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identity", Identity.class)),
    VERIFYUSERIDENTITY_1(Identity.class, "verifyUserIdentity", ApiMethodArg.arg((String)"user", User.class), ApiMethodArg.arg((String)"identityId", Long.TYPE)),
    VERIFYUSERIDENTITY_2(Identity.class, "verifyUserIdentity", ApiMethodArg.arg((String)"userId", Long.TYPE), ApiMethodArg.arg((String)"identityId", Long.TYPE));

    private final ApiMethod apiMethod;

    private ZendeskApiMethod(Class<?> resultType, String name, ApiMethodArg ... args) {
        this.apiMethod = new ApiMethodImpl(Zendesk.class, resultType, name, args);
    }

    public String getName() {
        return this.apiMethod.getName();
    }

    public Class<?> getResultType() {
        return this.apiMethod.getResultType();
    }

    public List<String> getArgNames() {
        return this.apiMethod.getArgNames();
    }

    public List<Class<?>> getArgTypes() {
        return this.apiMethod.getArgTypes();
    }

    public Method getMethod() {
        return this.apiMethod.getMethod();
    }
}

