/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.ExchangePattern;
import org.apache.camel.LoggingLevel;
import org.apache.camel.component.zendesk.ZendeskConfiguration;
import org.apache.camel.component.zendesk.ZendeskEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PollingConsumerPollStrategy;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class ZendeskEndpointConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        ZendeskEndpoint target = (ZendeskEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                target.setBackoffErrorThreshold((Integer)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                target.setBackoffIdleThreshold((Integer)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                target.setBackoffMultiplier((Integer)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delay": {
                target.setDelay((Long)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                target.setExceptionHandler((ExceptionHandler)ZendeskEndpointConfigurer.property((CamelContext)camelContext, ExceptionHandler.class, (Object)value));
                return true;
            }
            case "exchangepattern": 
            case "exchangePattern": {
                target.setExchangePattern((ExchangePattern)ZendeskEndpointConfigurer.property((CamelContext)camelContext, ExchangePattern.class, (Object)value));
                return true;
            }
            case "greedy": {
                target.setGreedy((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "inbody": 
            case "inBody": {
                target.setInBody((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                target.setInitialDelay((Long)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "oauthtoken": 
            case "oauthToken": {
                ((ZendeskConfiguration)target.getConfiguration()).setOauthToken((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "password": {
                ((ZendeskConfiguration)target.getConfiguration()).setPassword((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "pollstrategy": 
            case "pollStrategy": {
                target.setPollStrategy((PollingConsumerPollStrategy)ZendeskEndpointConfigurer.property((CamelContext)camelContext, PollingConsumerPollStrategy.class, (Object)value));
                return true;
            }
            case "repeatcount": 
            case "repeatCount": {
                target.setRepeatCount((Long)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                target.setRunLoggingLevel((LoggingLevel)ZendeskEndpointConfigurer.property((CamelContext)camelContext, LoggingLevel.class, (Object)value));
                return true;
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                target.setScheduledExecutorService((ScheduledExecutorService)ZendeskEndpointConfigurer.property((CamelContext)camelContext, ScheduledExecutorService.class, (Object)value));
                return true;
            }
            case "scheduler": {
                target.setScheduler(ZendeskEndpointConfigurer.property((CamelContext)camelContext, Object.class, (Object)value));
                return true;
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                target.setSchedulerProperties((Map)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Map.class, (Object)value));
                return true;
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                target.setSendEmptyMessageWhenIdle((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "serverurl": 
            case "serverUrl": {
                ((ZendeskConfiguration)target.getConfiguration()).setServerUrl((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "startscheduler": 
            case "startScheduler": {
                target.setStartScheduler((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "synchronous": {
                target.setSynchronous((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "timeunit": 
            case "timeUnit": {
                target.setTimeUnit((TimeUnit)((Object)ZendeskEndpointConfigurer.property((CamelContext)camelContext, TimeUnit.class, (Object)value)));
                return true;
            }
            case "token": {
                ((ZendeskConfiguration)target.getConfiguration()).setToken((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                target.setUseFixedDelay((Boolean)ZendeskEndpointConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "username": {
                ((ZendeskConfiguration)target.getConfiguration()).setUsername((String)ZendeskEndpointConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("backoffErrorThreshold", Integer.TYPE);
        answer.put("backoffIdleThreshold", Integer.TYPE);
        answer.put("backoffMultiplier", Integer.TYPE);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("delay", Long.TYPE);
        answer.put("exceptionHandler", ExceptionHandler.class);
        answer.put("exchangePattern", ExchangePattern.class);
        answer.put("greedy", Boolean.TYPE);
        answer.put("inBody", String.class);
        answer.put("initialDelay", Long.TYPE);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("oauthToken", String.class);
        answer.put("password", String.class);
        answer.put("pollStrategy", PollingConsumerPollStrategy.class);
        answer.put("repeatCount", Long.TYPE);
        answer.put("runLoggingLevel", LoggingLevel.class);
        answer.put("scheduledExecutorService", ScheduledExecutorService.class);
        answer.put("scheduler", Object.class);
        answer.put("schedulerProperties", Map.class);
        answer.put("sendEmptyMessageWhenIdle", Boolean.TYPE);
        answer.put("serverUrl", String.class);
        answer.put("startScheduler", Boolean.TYPE);
        answer.put("synchronous", Boolean.TYPE);
        answer.put("timeUnit", TimeUnit.class);
        answer.put("token", String.class);
        answer.put("useFixedDelay", Boolean.TYPE);
        answer.put("username", String.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        ZendeskEndpoint target = (ZendeskEndpoint)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "backofferrorthreshold": 
            case "backoffErrorThreshold": {
                return target.getBackoffErrorThreshold();
            }
            case "backoffidlethreshold": 
            case "backoffIdleThreshold": {
                return target.getBackoffIdleThreshold();
            }
            case "backoffmultiplier": 
            case "backoffMultiplier": {
                return target.getBackoffMultiplier();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "delay": {
                return target.getDelay();
            }
            case "exceptionhandler": 
            case "exceptionHandler": {
                return target.getExceptionHandler();
            }
            case "exchangepattern": 
            case "exchangePattern": {
                return target.getExchangePattern();
            }
            case "greedy": {
                return target.isGreedy();
            }
            case "inbody": 
            case "inBody": {
                return target.getInBody();
            }
            case "initialdelay": 
            case "initialDelay": {
                return target.getInitialDelay();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "oauthtoken": 
            case "oauthToken": {
                return ((ZendeskConfiguration)target.getConfiguration()).getOauthToken();
            }
            case "password": {
                return ((ZendeskConfiguration)target.getConfiguration()).getPassword();
            }
            case "pollstrategy": 
            case "pollStrategy": {
                return target.getPollStrategy();
            }
            case "repeatcount": 
            case "repeatCount": {
                return target.getRepeatCount();
            }
            case "runlogginglevel": 
            case "runLoggingLevel": {
                return target.getRunLoggingLevel();
            }
            case "scheduledexecutorservice": 
            case "scheduledExecutorService": {
                return target.getScheduledExecutorService();
            }
            case "scheduler": {
                return target.getScheduler();
            }
            case "schedulerproperties": 
            case "schedulerProperties": {
                return target.getSchedulerProperties();
            }
            case "sendemptymessagewhenidle": 
            case "sendEmptyMessageWhenIdle": {
                return target.isSendEmptyMessageWhenIdle();
            }
            case "serverurl": 
            case "serverUrl": {
                return ((ZendeskConfiguration)target.getConfiguration()).getServerUrl();
            }
            case "startscheduler": 
            case "startScheduler": {
                return target.isStartScheduler();
            }
            case "synchronous": {
                return target.isSynchronous();
            }
            case "timeunit": 
            case "timeUnit": {
                return target.getTimeUnit();
            }
            case "token": {
                return ((ZendeskConfiguration)target.getConfiguration()).getToken();
            }
            case "usefixeddelay": 
            case "useFixedDelay": {
                return target.isUseFixedDelay();
            }
            case "username": {
                return ((ZendeskConfiguration)target.getConfiguration()).getUsername();
            }
        }
        return null;
    }
}

