/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zendesk;

import java.io.Closeable;
import java.util.Map;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.zendesk.ZendeskComponent;
import org.apache.camel.component.zendesk.ZendeskConfiguration;
import org.apache.camel.component.zendesk.ZendeskConsumer;
import org.apache.camel.component.zendesk.ZendeskProducer;
import org.apache.camel.component.zendesk.internal.ZendeskApiCollection;
import org.apache.camel.component.zendesk.internal.ZendeskApiName;
import org.apache.camel.component.zendesk.internal.ZendeskHelper;
import org.apache.camel.component.zendesk.internal.ZendeskPropertiesHelper;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.component.AbstractApiEndpoint;
import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodPropertiesHelper;
import org.apache.camel.support.component.ApiName;
import org.apache.camel.util.IOHelper;
import org.zendesk.client.v2.Zendesk;

@UriEndpoint(firstVersion="2.19.0", scheme="zendesk", title="Zendesk", syntax="zendesk:methodName", consumerPrefix="consumer", category={Category.CLOUD, Category.API, Category.SUPPORT}, lenientProperties=true)
public class ZendeskEndpoint
extends AbstractApiEndpoint<ZendeskApiName, ZendeskConfiguration> {
    @UriParam
    private ZendeskConfiguration configuration;
    private Zendesk apiProxy;

    public ZendeskEndpoint(String uri, ZendeskComponent component, ZendeskApiName apiName, String methodName, ZendeskConfiguration endpointConfiguration) {
        super(uri, (Component)component, (ApiName)apiName, methodName, ZendeskApiCollection.getCollection().getHelper(apiName), (Object)endpointConfiguration);
        this.configuration = endpointConfiguration;
    }

    public ZendeskComponent getComponent() {
        return (ZendeskComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        return new ZendeskProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.inBody != null) {
            throw new IllegalArgumentException("Option inBody is not supported for consumer endpoint");
        }
        ZendeskConsumer consumer = new ZendeskConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.getZendesk();
    }

    public void doStop() throws Exception {
        IOHelper.close((Closeable)this.apiProxy);
        super.doStop();
    }

    protected ApiMethodPropertiesHelper<ZendeskConfiguration> getPropertiesHelper() {
        return ZendeskPropertiesHelper.getHelper(this.getCamelContext());
    }

    protected String getThreadProfileName() {
        return "CamelZendesk";
    }

    protected void afterConfigureProperties() {
    }

    public Object getApiProxy(ApiMethod method, Map<String, Object> args) {
        return this.getZendesk();
    }

    private Zendesk getZendesk() {
        if (this.apiProxy == null) {
            this.apiProxy = ((ZendeskConfiguration)this.getConfiguration()).equals(this.getComponent().getConfiguration()) ? this.getComponent().getZendesk() : ZendeskHelper.create((ZendeskConfiguration)this.getConfiguration());
        }
        return this.apiProxy;
    }
}

