/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.s3;

import com.amazonaws.Protocol;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws.s3.S3Component;
import org.apache.camel.component.aws.s3.S3Configuration;
import org.apache.camel.component.aws.s3.S3Operations;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;

public class S3ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private S3Configuration getOrCreateConfiguration(S3Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new S3Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        S3Component target = (S3Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceleratemodeenabled": 
            case "accelerateModeEnabled": {
                this.getOrCreateConfiguration(target).setAccelerateModeEnabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazons3client": 
            case "amazonS3Client": {
                this.getOrCreateConfiguration(target).setAmazonS3Client((AmazonS3)S3ComponentConfigurer.property((CamelContext)camelContext, AmazonS3.class, (Object)value));
                return true;
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                this.getOrCreateConfiguration(target).setAutoCreateBucket((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                this.getOrCreateConfiguration(target).setAutoDiscoverClient((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "autoclosebody": 
            case "autocloseBody": {
                this.getOrCreateConfiguration(target).setAutocloseBody((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                this.getOrCreateConfiguration(target).setAwsKMSKeyId((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                target.setBridgeErrorHandler((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "chunkedencodingdisabled": 
            case "chunkedEncodingDisabled": {
                this.getOrCreateConfiguration(target).setChunkedEncodingDisabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((S3Configuration)S3ComponentConfigurer.property((CamelContext)camelContext, S3Configuration.class, (Object)value));
                return true;
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                this.getOrCreateConfiguration(target).setDeleteAfterRead((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                this.getOrCreateConfiguration(target).setDeleteAfterWrite((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "delimiter": {
                this.getOrCreateConfiguration(target).setDelimiter((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "dualstackenabled": 
            case "dualstackEnabled": {
                this.getOrCreateConfiguration(target).setDualstackEnabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "encryptionmaterials": 
            case "encryptionMaterials": {
                this.getOrCreateConfiguration(target).setEncryptionMaterials((EncryptionMaterials)S3ComponentConfigurer.property((CamelContext)camelContext, EncryptionMaterials.class, (Object)value));
                return true;
            }
            case "endpointconfiguration": 
            case "endpointConfiguration": {
                this.getOrCreateConfiguration(target).setEndpointConfiguration((AwsClientBuilder.EndpointConfiguration)S3ComponentConfigurer.property((CamelContext)camelContext, AwsClientBuilder.EndpointConfiguration.class, (Object)value));
                return true;
            }
            case "filename": 
            case "fileName": {
                this.getOrCreateConfiguration(target).setFileName((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "forceglobalbucketaccessenabled": 
            case "forceGlobalBucketAccessEnabled": {
                this.getOrCreateConfiguration(target).setForceGlobalBucketAccessEnabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "includebody": 
            case "includeBody": {
                this.getOrCreateConfiguration(target).setIncludeBody((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "keyname": 
            case "keyName": {
                this.getOrCreateConfiguration(target).setKeyName((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "multipartupload": 
            case "multiPartUpload": {
                this.getOrCreateConfiguration(target).setMultiPartUpload((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((S3Operations)((Object)S3ComponentConfigurer.property((CamelContext)camelContext, S3Operations.class, (Object)value)));
                return true;
            }
            case "partsize": 
            case "partSize": {
                this.getOrCreateConfiguration(target).setPartSize((Long)S3ComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "pathstyleaccess": 
            case "pathStyleAccess": {
                this.getOrCreateConfiguration(target).setPathStyleAccess((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "payloadsigningenabled": 
            case "payloadSigningEnabled": {
                this.getOrCreateConfiguration(target).setPayloadSigningEnabled((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "policy": {
                this.getOrCreateConfiguration(target).setPolicy((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "prefix": {
                this.getOrCreateConfiguration(target).setPrefix((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)S3ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)S3ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "serversideencryption": 
            case "serverSideEncryption": {
                this.getOrCreateConfiguration(target).setServerSideEncryption((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "storageclass": 
            case "storageClass": {
                this.getOrCreateConfiguration(target).setStorageClass((String)S3ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "useawskms": 
            case "useAwsKMS": {
                this.getOrCreateConfiguration(target).setUseAwsKMS((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useencryption": 
            case "useEncryption": {
                this.getOrCreateConfiguration(target).setUseEncryption((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "useiamcredentials": 
            case "useIAMCredentials": {
                this.getOrCreateConfiguration(target).setUseIAMCredentials((Boolean)S3ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accelerateModeEnabled", Boolean.TYPE);
        answer.put("accessKey", String.class);
        answer.put("amazonS3Client", AmazonS3.class);
        answer.put("autoCreateBucket", Boolean.TYPE);
        answer.put("autoDiscoverClient", Boolean.TYPE);
        answer.put("autocloseBody", Boolean.TYPE);
        answer.put("awsKMSKeyId", String.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("bridgeErrorHandler", Boolean.TYPE);
        answer.put("chunkedEncodingDisabled", Boolean.TYPE);
        answer.put("configuration", S3Configuration.class);
        answer.put("deleteAfterRead", Boolean.TYPE);
        answer.put("deleteAfterWrite", Boolean.TYPE);
        answer.put("delimiter", String.class);
        answer.put("dualstackEnabled", Boolean.TYPE);
        answer.put("encryptionMaterials", EncryptionMaterials.class);
        answer.put("endpointConfiguration", AwsClientBuilder.EndpointConfiguration.class);
        answer.put("fileName", String.class);
        answer.put("forceGlobalBucketAccessEnabled", Boolean.TYPE);
        answer.put("includeBody", Boolean.TYPE);
        answer.put("keyName", String.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("multiPartUpload", Boolean.TYPE);
        answer.put("operation", S3Operations.class);
        answer.put("partSize", Long.TYPE);
        answer.put("pathStyleAccess", Boolean.TYPE);
        answer.put("payloadSigningEnabled", Boolean.TYPE);
        answer.put("policy", String.class);
        answer.put("prefix", String.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("region", String.class);
        answer.put("secretKey", String.class);
        answer.put("serverSideEncryption", String.class);
        answer.put("storageClass", String.class);
        answer.put("useAwsKMS", Boolean.TYPE);
        answer.put("useEncryption", Boolean.TYPE);
        answer.put("useIAMCredentials", Boolean.TYPE);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        S3Component target = (S3Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "acceleratemodeenabled": 
            case "accelerateModeEnabled": {
                return this.getOrCreateConfiguration(target).isAccelerateModeEnabled();
            }
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazons3client": 
            case "amazonS3Client": {
                return this.getOrCreateConfiguration(target).getAmazonS3Client();
            }
            case "autocreatebucket": 
            case "autoCreateBucket": {
                return this.getOrCreateConfiguration(target).isAutoCreateBucket();
            }
            case "autodiscoverclient": 
            case "autoDiscoverClient": {
                return this.getOrCreateConfiguration(target).isAutoDiscoverClient();
            }
            case "autoclosebody": 
            case "autocloseBody": {
                return this.getOrCreateConfiguration(target).isAutocloseBody();
            }
            case "awskmskeyid": 
            case "awsKMSKeyId": {
                return this.getOrCreateConfiguration(target).getAwsKMSKeyId();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "bridgeerrorhandler": 
            case "bridgeErrorHandler": {
                return target.isBridgeErrorHandler();
            }
            case "chunkedencodingdisabled": 
            case "chunkedEncodingDisabled": {
                return this.getOrCreateConfiguration(target).isChunkedEncodingDisabled();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "deleteafterread": 
            case "deleteAfterRead": {
                return this.getOrCreateConfiguration(target).isDeleteAfterRead();
            }
            case "deleteafterwrite": 
            case "deleteAfterWrite": {
                return this.getOrCreateConfiguration(target).isDeleteAfterWrite();
            }
            case "delimiter": {
                return this.getOrCreateConfiguration(target).getDelimiter();
            }
            case "dualstackenabled": 
            case "dualstackEnabled": {
                return this.getOrCreateConfiguration(target).isDualstackEnabled();
            }
            case "encryptionmaterials": 
            case "encryptionMaterials": {
                return this.getOrCreateConfiguration(target).getEncryptionMaterials();
            }
            case "endpointconfiguration": 
            case "endpointConfiguration": {
                return this.getOrCreateConfiguration(target).getEndpointConfiguration();
            }
            case "filename": 
            case "fileName": {
                return this.getOrCreateConfiguration(target).getFileName();
            }
            case "forceglobalbucketaccessenabled": 
            case "forceGlobalBucketAccessEnabled": {
                return this.getOrCreateConfiguration(target).isForceGlobalBucketAccessEnabled();
            }
            case "includebody": 
            case "includeBody": {
                return this.getOrCreateConfiguration(target).isIncludeBody();
            }
            case "keyname": 
            case "keyName": {
                return this.getOrCreateConfiguration(target).getKeyName();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "multipartupload": 
            case "multiPartUpload": {
                return this.getOrCreateConfiguration(target).isMultiPartUpload();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "partsize": 
            case "partSize": {
                return this.getOrCreateConfiguration(target).getPartSize();
            }
            case "pathstyleaccess": 
            case "pathStyleAccess": {
                return this.getOrCreateConfiguration(target).isPathStyleAccess();
            }
            case "payloadsigningenabled": 
            case "payloadSigningEnabled": {
                return this.getOrCreateConfiguration(target).isPayloadSigningEnabled();
            }
            case "policy": {
                return this.getOrCreateConfiguration(target).getPolicy();
            }
            case "prefix": {
                return this.getOrCreateConfiguration(target).getPrefix();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "serversideencryption": 
            case "serverSideEncryption": {
                return this.getOrCreateConfiguration(target).getServerSideEncryption();
            }
            case "storageclass": 
            case "storageClass": {
                return this.getOrCreateConfiguration(target).getStorageClass();
            }
            case "useawskms": 
            case "useAwsKMS": {
                return this.getOrCreateConfiguration(target).isUseAwsKMS();
            }
            case "useencryption": 
            case "useEncryption": {
                return this.getOrCreateConfiguration(target).isUseEncryption();
            }
            case "useiamcredentials": 
            case "useIAMCredentials": {
                return this.getOrCreateConfiguration(target).isUseIAMCredentials();
            }
        }
        return null;
    }
}

