/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio.client;

import io.minio.MinioClient;
import org.apache.camel.component.minio.MinioConfiguration;
import org.apache.camel.component.minio.client.MinioCamelInternalClient;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioRemoteClientImpl
implements MinioCamelInternalClient {
    private static final Logger LOG = LoggerFactory.getLogger(MinioRemoteClientImpl.class);
    private final MinioConfiguration configuration;

    public MinioRemoteClientImpl(MinioConfiguration configuration) {
        LOG.trace("Creating an Minio client.");
        this.configuration = configuration;
    }

    @Override
    public MinioClient getMinioClient() {
        if (ObjectHelper.isNotEmpty((Object)this.configuration.getEndpoint())) {
            MinioClient.Builder minioClientRequest = MinioClient.builder();
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getProxyPort())) {
                minioClientRequest.endpoint(this.configuration.getEndpoint(), this.configuration.getProxyPort().intValue(), this.configuration.isSecure());
            } else {
                minioClientRequest.endpoint(this.configuration.getEndpoint());
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getAccessKey()) && ObjectHelper.isNotEmpty((Object)this.configuration.getSecretKey())) {
                minioClientRequest.credentials(this.configuration.getAccessKey(), this.configuration.getSecretKey());
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getRegion())) {
                minioClientRequest.region(this.configuration.getRegion());
            }
            if (ObjectHelper.isNotEmpty((Object)this.configuration.getCustomHttpClient())) {
                minioClientRequest.httpClient(this.configuration.getCustomHttpClient());
            }
            return minioClientRequest.build();
        }
        throw new IllegalArgumentException("Endpoint must be specified");
    }
}

