
/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.zendesk.internal;

import java.lang.reflect.Method;
import java.util.List;

import org.zendesk.client.v2.Zendesk;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for org.zendesk.client.v2.Zendesk
 */
public enum ZendeskApiMethod implements ApiMethod {

    ADDTAGTOORGANISATIONS(
        java.util.List.class,
        "addTagToOrganisations",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    ADDTAGTOTICKET(
        java.util.List.class,
        "addTagToTicket",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    ADDTAGTOTOPICS(
        java.util.List.class,
        "addTagToTopics",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    ASSOCIATEATTACHMENTSTOARTICLE(
        void.class,
        "associateAttachmentsToArticle",
        arg("idArticle", String.class),
        arg("attachments", java.util.List.class)),

    CHANGEUSERPASSWORD(
        void.class,
        "changeUserPassword",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("oldPassword", String.class),
        arg("newPassword", String.class)),

    CREATEARTICLE(
        org.zendesk.client.v2.model.hc.Article.class,
        "createArticle",
        arg("article", org.zendesk.client.v2.model.hc.Article.class)),

    CREATEARTICLETRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "createArticleTranslation",
        arg("articleId", Long.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    CREATEAUTOMATION(
        org.zendesk.client.v2.model.Automation.class,
        "createAutomation",
        arg("automation", org.zendesk.client.v2.model.Automation.class)),

    CREATECATEGORY(
        org.zendesk.client.v2.model.hc.Category.class,
        "createCategory",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    CREATECATEGORYTRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "createCategoryTranslation",
        arg("categoryId", Long.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    CREATECOMMENT(
        org.zendesk.client.v2.model.Ticket.class,
        "createComment",
        arg("ticketId", long.class),
        arg("comment", org.zendesk.client.v2.model.Comment.class)),

    CREATEFORUM(
        org.zendesk.client.v2.model.Forum.class,
        "createForum",
        arg("forum", org.zendesk.client.v2.model.Forum.class)),

    CREATEGROUP(
        org.zendesk.client.v2.model.Group.class,
        "createGroup",
        arg("group", org.zendesk.client.v2.model.Group.class)),

    CREATEGROUPMEMBERSHIP(
        org.zendesk.client.v2.model.GroupMembership.class,
        "createGroupMembership",
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    CREATEGROUPMEMBERSHIP_1(
        org.zendesk.client.v2.model.GroupMembership.class,
        "createGroupMembership",
        arg("user_id", long.class),
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    CREATEMACRO(
        org.zendesk.client.v2.model.Macro.class,
        "createMacro",
        arg("macro", org.zendesk.client.v2.model.Macro.class)),

    CREATEORUPDATEUSER(
        org.zendesk.client.v2.model.User.class,
        "createOrUpdateUser",
        arg("user", org.zendesk.client.v2.model.User.class)),

    CREATEORGANIZATION(
        org.zendesk.client.v2.model.Organization.class,
        "createOrganization",
        arg("organization", org.zendesk.client.v2.model.Organization.class)),

    CREATEORGANIZATIONMEMBERSHIP(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "createOrganizationMembership",
        arg("organizationMembership", org.zendesk.client.v2.model.OrganizationMembership.class)),

    CREATEORGANIZATIONMEMBERSHIP_1(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "createOrganizationMembership",
        arg("user_id", long.class),
        arg("organizationMembership", org.zendesk.client.v2.model.OrganizationMembership.class)),

    CREATEORGANIZATIONS(
        org.zendesk.client.v2.model.JobStatus.class,
        "createOrganizations",
        arg("organizationList", java.util.List.class)),

    CREATEORGANIZATIONS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "createOrganizations",
        arg("organizations", new org.zendesk.client.v2.model.Organization[0].getClass())),

    CREATEORGANIZATIONSASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createOrganizationsAsync",
        arg("organizationList", java.util.List.class)),

    CREATEREQUEST(
        org.zendesk.client.v2.model.Request.class,
        "createRequest",
        arg("request", org.zendesk.client.v2.model.Request.class)),

    CREATESATISFACTIONRATING(
        org.zendesk.client.v2.model.SatisfactionRating.class,
        "createSatisfactionRating",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("satisfactionRating", org.zendesk.client.v2.model.SatisfactionRating.class)),

    CREATESATISFACTIONRATING_1(
        org.zendesk.client.v2.model.SatisfactionRating.class,
        "createSatisfactionRating",
        arg("ticketId", long.class),
        arg("satisfactionRating", org.zendesk.client.v2.model.SatisfactionRating.class)),

    CREATESECTION(
        org.zendesk.client.v2.model.hc.Section.class,
        "createSection",
        arg("section", org.zendesk.client.v2.model.hc.Section.class)),

    CREATESECTIONTRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "createSectionTranslation",
        arg("sectionId", Long.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    CREATETARGET(
        org.zendesk.client.v2.model.targets.Target.class,
        "createTarget",
        arg("target", org.zendesk.client.v2.model.targets.Target.class)),

    CREATETICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "createTicket",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    CREATETICKETASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createTicketAsync",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    CREATETICKETFIELD(
        org.zendesk.client.v2.model.Field.class,
        "createTicketField",
        arg("field", org.zendesk.client.v2.model.Field.class)),

    CREATETICKETFORM(
        org.zendesk.client.v2.model.TicketForm.class,
        "createTicketForm",
        arg("ticketForm", org.zendesk.client.v2.model.TicketForm.class)),

    CREATETICKETFROMTWEET(
        org.zendesk.client.v2.model.Ticket.class,
        "createTicketFromTweet",
        arg("tweetId", long.class),
        arg("monitorId", long.class)),

    CREATETICKETS(
        org.zendesk.client.v2.model.JobStatus.class,
        "createTickets",
        arg("ticketList", java.util.List.class)),

    CREATETICKETS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "createTickets",
        arg("tickets", new org.zendesk.client.v2.model.Ticket[0].getClass())),

    CREATETICKETSASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createTicketsAsync",
        arg("ticketList", java.util.List.class)),

    CREATETOPIC(
        org.zendesk.client.v2.model.Topic.class,
        "createTopic",
        arg("topic", org.zendesk.client.v2.model.Topic.class)),

    CREATETRIGGER(
        org.zendesk.client.v2.model.Trigger.class,
        "createTrigger",
        arg("trigger", org.zendesk.client.v2.model.Trigger.class)),

    CREATEUPLOAD(
        org.zendesk.client.v2.model.Attachment.Upload.class,
        "createUpload",
        arg("fileName", String.class),
        arg("content", new byte[0].getClass())),

    CREATEUPLOAD_1(
        org.zendesk.client.v2.model.Attachment.Upload.class,
        "createUpload",
        arg("fileName", String.class),
        arg("contentType", String.class),
        arg("content", new byte[0].getClass())),

    CREATEUPLOAD_2(
        org.zendesk.client.v2.model.Attachment.Upload.class,
        "createUpload",
        arg("token", String.class),
        arg("fileName", String.class),
        arg("contentType", String.class),
        arg("content", new byte[0].getClass())),

    CREATEUPLOADARTICLE(
        org.zendesk.client.v2.model.hc.ArticleAttachments.class,
        "createUploadArticle",
        arg("articleId0", long.class),
        arg("file", java.io.File.class)),

    CREATEUPLOADARTICLE_1(
        org.zendesk.client.v2.model.hc.ArticleAttachments.class,
        "createUploadArticle",
        arg("articleId0", long.class),
        arg("file", java.io.File.class),
        arg("inline", boolean.class)),

    CREATEUSER(
        org.zendesk.client.v2.model.User.class,
        "createUser",
        arg("user", org.zendesk.client.v2.model.User.class)),

    CREATEUSERIDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "createUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    CREATEUSERIDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "createUserIdentity",
        arg("userId", long.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    CREATEUSERS(
        org.zendesk.client.v2.model.JobStatus.class,
        "createUsers",
        arg("userList", java.util.List.class)),

    CREATEUSERS_1(
        org.zendesk.client.v2.model.JobStatus.class,
        "createUsers",
        arg("users", new org.zendesk.client.v2.model.User[0].getClass())),

    CREATEUSERSASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "createUsersAsync",
        arg("userList", java.util.List.class)),

    DELETEARTICLE(
        void.class,
        "deleteArticle",
        arg("article", org.zendesk.client.v2.model.hc.Article.class)),

    DELETEARTICLEATTACHMENT(
        void.class,
        "deleteArticleAttachment",
        arg("articleAttachments", org.zendesk.client.v2.model.hc.ArticleAttachments.class)),

    DELETEARTICLEATTACHMENT_1(
        void.class,
        "deleteArticleAttachment",
        arg("id", long.class)),

    DELETEATTACHMENT(
        void.class,
        "deleteAttachment",
        arg("attachment", org.zendesk.client.v2.model.Attachment.class)),

    DELETEATTACHMENT_1(
        void.class,
        "deleteAttachment",
        arg("id", long.class)),

    DELETEAUTOMATION(
        void.class,
        "deleteAutomation",
        arg("automationId0", long.class)),

    DELETECATEGORY(
        void.class,
        "deleteCategory",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    DELETEFORUM(
        void.class,
        "deleteForum",
        arg("forum", org.zendesk.client.v2.model.Forum.class)),

    DELETEGROUP(
        void.class,
        "deleteGroup",
        arg("group", org.zendesk.client.v2.model.Group.class)),

    DELETEGROUP_1(
        void.class,
        "deleteGroup",
        arg("id", long.class)),

    DELETEGROUPMEMBERSHIP(
        void.class,
        "deleteGroupMembership",
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    DELETEGROUPMEMBERSHIP_1(
        void.class,
        "deleteGroupMembership",
        arg("id", long.class)),

    DELETEGROUPMEMBERSHIP_2(
        void.class,
        "deleteGroupMembership",
        arg("user_id", long.class),
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    DELETEGROUPMEMBERSHIP_3(
        void.class,
        "deleteGroupMembership",
        arg("user_id", long.class),
        arg("group_membership_id", long.class)),

    DELETEORGANIZATION(
        void.class,
        "deleteOrganization",
        arg("id", long.class)),

    DELETEORGANIZATION_1(
        void.class,
        "deleteOrganization",
        arg("organization", org.zendesk.client.v2.model.Organization.class)),

    DELETEORGANIZATIONMEMBERSHIP(
        void.class,
        "deleteOrganizationMembership",
        arg("id", long.class)),

    DELETEORGANIZATIONMEMBERSHIP_1(
        void.class,
        "deleteOrganizationMembership",
        arg("user_id", long.class),
        arg("organizationMembership", org.zendesk.client.v2.model.OrganizationMembership.class)),

    DELETEORGANIZATIONMEMBERSHIP_2(
        void.class,
        "deleteOrganizationMembership",
        arg("user_id", long.class),
        arg("organization_membership_id", long.class)),

    DELETESECTION(
        void.class,
        "deleteSection",
        arg("section", org.zendesk.client.v2.model.hc.Section.class)),

    DELETESUSPENDEDTICKET(
        void.class,
        "deleteSuspendedTicket",
        arg("id", long.class)),

    DELETESUSPENDEDTICKET_1(
        void.class,
        "deleteSuspendedTicket",
        arg("suspendedTicket", org.zendesk.client.v2.model.SuspendedTicket.class)),

    DELETETARGET(
        void.class,
        "deleteTarget",
        arg("targetId", long.class)),

    DELETETICKET(
        void.class,
        "deleteTicket",
        arg("id", long.class)),

    DELETETICKET_1(
        void.class,
        "deleteTicket",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    DELETETICKETFIELD(
        void.class,
        "deleteTicketField",
        arg("field", org.zendesk.client.v2.model.Field.class)),

    DELETETICKETFIELD_1(
        void.class,
        "deleteTicketField",
        arg("id", long.class)),

    DELETETICKETS(
        void.class,
        "deleteTickets",
        arg("id", long.class),
        arg("ids", new long[0].getClass())),

    DELETETOPIC(
        void.class,
        "deleteTopic",
        arg("topic", org.zendesk.client.v2.model.Topic.class)),

    DELETETRIGGER(
        void.class,
        "deleteTrigger",
        arg("triggerId", long.class)),

    DELETEUPLOAD(
        void.class,
        "deleteUpload",
        arg("token", String.class)),

    DELETEUPLOAD_1(
        void.class,
        "deleteUpload",
        arg("upload", org.zendesk.client.v2.model.Attachment.Upload.class)),

    DELETEUSER(
        void.class,
        "deleteUser",
        arg("id", long.class)),

    DELETEUSER_1(
        void.class,
        "deleteUser",
        arg("user", org.zendesk.client.v2.model.User.class)),

    DELETEUSERIDENTITY(
        void.class,
        "deleteUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    DELETEUSERIDENTITY_1(
        void.class,
        "deleteUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    DELETEUSERIDENTITY_2(
        void.class,
        "deleteUserIdentity",
        arg("userId", long.class),
        arg("identityId", long.class)),

    GETARTICLE(
        org.zendesk.client.v2.model.hc.Article.class,
        "getArticle",
        arg("id", long.class)),

    GETARTICLEFROMSEARCH(
        Iterable.class,
        "getArticleFromSearch",
        arg("searchTerm", String.class)),

    GETARTICLEFROMSEARCH_1(
        Iterable.class,
        "getArticleFromSearch",
        arg("searchTerm", String.class),
        arg("sectionId", Long.class)),

    GETARTICLESUBSCRIPTIONS(
        Iterable.class,
        "getArticleSubscriptions",
        arg("articleId", Long.class)),

    GETARTICLESUBSCRIPTIONS_1(
        Iterable.class,
        "getArticleSubscriptions",
        arg("articleId", Long.class),
        arg("locale", String.class)),

    GETARTICLETRANSLATIONS(
        Iterable.class,
        "getArticleTranslations",
        arg("articleId", Long.class)),

    GETARTICLES(
        Iterable.class,
        "getArticles"),

    GETARTICLES_1(
        Iterable.class,
        "getArticles",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    GETARTICLESFROMPAGE(
        java.util.List.class,
        "getArticlesFromPage",
        arg("page", int.class)),

    GETARTICLESINCREMENTALLY(
        Iterable.class,
        "getArticlesIncrementally",
        arg("startTime", java.util.Date.class)),

    GETASSIGNABLEGROUPMEMBERSHIPS(
        Iterable.class,
        "getAssignableGroupMemberships"),

    GETASSIGNABLEGROUPMEMBERSHIPS_1(
        java.util.List.class,
        "getAssignableGroupMemberships",
        arg("group_id", long.class)),

    GETASSIGNABLEGROUPS(
        Iterable.class,
        "getAssignableGroups"),

    GETATTACHMENT(
        org.zendesk.client.v2.model.Attachment.class,
        "getAttachment",
        arg("attachment", org.zendesk.client.v2.model.Attachment.class)),

    GETATTACHMENT_1(
        org.zendesk.client.v2.model.Attachment.class,
        "getAttachment",
        arg("id", long.class)),

    GETATTACHMENTSFROMARTICLE(
        java.util.List.class,
        "getAttachmentsFromArticle",
        arg("articleId", Long.class)),

    GETAUTHENTICATEDUSER(
        org.zendesk.client.v2.model.User.class,
        "getAuthenticatedUser"),

    GETAUTOCOMPLETEORGANIZATIONS(
        Iterable.class,
        "getAutoCompleteOrganizations",
        arg("name", String.class)),

    GETAUTOMATION(
        org.zendesk.client.v2.model.Automation.class,
        "getAutomation",
        arg("id", long.class)),

    GETAUTOMATIONS(
        Iterable.class,
        "getAutomations"),

    GETBRANDS(
        java.util.List.class,
        "getBrands"),

    GETCCREQUESTS(
        Iterable.class,
        "getCCRequests"),

    GETCATEGORIES(
        Iterable.class,
        "getCategories"),

    GETCATEGORY(
        org.zendesk.client.v2.model.hc.Category.class,
        "getCategory",
        arg("id", long.class)),

    GETCATEGORYTRANSLATIONS(
        Iterable.class,
        "getCategoryTranslations",
        arg("categoryId", Long.class)),

    GETCURRENTUSER(
        org.zendesk.client.v2.model.User.class,
        "getCurrentUser"),

    GETCUSTOMAGENTROLES(
        Iterable.class,
        "getCustomAgentRoles"),

    GETFORUM(
        org.zendesk.client.v2.model.Forum.class,
        "getForum",
        arg("id", long.class)),

    GETFORUMS(
        Iterable.class,
        "getForums"),

    GETFORUMS_1(
        java.util.List.class,
        "getForums",
        arg("category_id", long.class)),

    GETGROUP(
        org.zendesk.client.v2.model.Group.class,
        "getGroup",
        arg("id", long.class)),

    GETGROUPMEMBERSHIP(
        org.zendesk.client.v2.model.GroupMembership.class,
        "getGroupMembership",
        arg("id", long.class)),

    GETGROUPMEMBERSHIP_1(
        org.zendesk.client.v2.model.GroupMembership.class,
        "getGroupMembership",
        arg("user_id", long.class),
        arg("group_membership_id", long.class)),

    GETGROUPMEMBERSHIPBYUSER(
        java.util.List.class,
        "getGroupMembershipByUser",
        arg("user_id", long.class)),

    GETGROUPMEMBERSHIPS(
        Iterable.class,
        "getGroupMemberships"),

    GETGROUPMEMBERSHIPS_1(
        java.util.List.class,
        "getGroupMemberships",
        arg("group_id", long.class)),

    GETGROUPORGANIZATION(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "getGroupOrganization",
        arg("user_id", long.class),
        arg("organization_membership_id", long.class)),

    GETGROUPUSERS(
        Iterable.class,
        "getGroupUsers",
        arg("id", long.class)),

    GETGROUPS(
        Iterable.class,
        "getGroups"),

    GETHOLIDAYSFORSCHEDULE(
        Iterable.class,
        "getHolidaysForSchedule",
        arg("schedule", org.zendesk.client.v2.model.schedules.Schedule.class)),

    GETHOLIDAYSFORSCHEDULE_1(
        Iterable.class,
        "getHolidaysForSchedule",
        arg("scheduleId", Long.class)),

    GETINCREMENTALTICKETSRESULT(
        java.util.Map.class,
        "getIncrementalTicketsResult",
        arg("unixEpochTime", long.class)),

    GETJOBSTATUS(
        org.zendesk.client.v2.model.JobStatus.class,
        "getJobStatus",
        arg("status", org.zendesk.client.v2.model.JobStatus.class)),

    GETJOBSTATUSASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "getJobStatusAsync",
        arg("status", org.zendesk.client.v2.model.JobStatus.class)),

    GETJOBSTATUSES(
        java.util.List.class,
        "getJobStatuses",
        arg("statuses", java.util.List.class)),

    GETJOBSTATUSESASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "getJobStatusesAsync",
        arg("statuses", java.util.List.class)),

    GETMACRO(
        org.zendesk.client.v2.model.Macro.class,
        "getMacro",
        arg("macroId", long.class)),

    GETMACROS(
        Iterable.class,
        "getMacros"),

    GETOPENREQUESTS(
        Iterable.class,
        "getOpenRequests"),

    GETORGANIZATION(
        org.zendesk.client.v2.model.Organization.class,
        "getOrganization",
        arg("id", long.class)),

    GETORGANIZATIONFIELDS(
        Iterable.class,
        "getOrganizationFields"),

    GETORGANIZATIONMEMBERSHIP(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "getOrganizationMembership",
        arg("id", long.class)),

    GETORGANIZATIONMEMBERSHIPBYUSER(
        java.util.List.class,
        "getOrganizationMembershipByUser",
        arg("user_id", long.class)),

    GETORGANIZATIONMEMBERSHIPFORUSER(
        org.zendesk.client.v2.model.OrganizationMembership.class,
        "getOrganizationMembershipForUser",
        arg("user_id", long.class),
        arg("id", long.class)),

    GETORGANIZATIONMEMBERSHIPS(
        Iterable.class,
        "getOrganizationMemberships"),

    GETORGANIZATIONMEMBERSHIPSFORORG(
        Iterable.class,
        "getOrganizationMembershipsForOrg",
        arg("organization_id", long.class)),

    GETORGANIZATIONMEMBERSHIPSFORUSER(
        Iterable.class,
        "getOrganizationMembershipsForUser",
        arg("user_id", long.class)),

    GETORGANIZATIONTICKETS(
        Iterable.class,
        "getOrganizationTickets",
        arg("organizationId", long.class)),

    GETORGANIZATIONUSERS(
        Iterable.class,
        "getOrganizationUsers",
        arg("id", long.class)),

    GETORGANIZATIONS(
        Iterable.class,
        "getOrganizations"),

    GETORGANIZATIONSINCREMENTALLY(
        Iterable.class,
        "getOrganizationsIncrementally",
        arg("startTime", java.util.Date.class)),

    GETRECENTTICKETS(
        Iterable.class,
        "getRecentTickets"),

    GETREQUEST(
        org.zendesk.client.v2.model.Request.class,
        "getRequest",
        arg("id", long.class)),

    GETREQUESTCOMMENT(
        org.zendesk.client.v2.model.Comment.class,
        "getRequestComment",
        arg("request", org.zendesk.client.v2.model.Request.class),
        arg("comment", org.zendesk.client.v2.model.Comment.class)),

    GETREQUESTCOMMENT_1(
        org.zendesk.client.v2.model.Comment.class,
        "getRequestComment",
        arg("request", org.zendesk.client.v2.model.Request.class),
        arg("commentId", long.class)),

    GETREQUESTCOMMENT_2(
        org.zendesk.client.v2.model.Comment.class,
        "getRequestComment",
        arg("requestId", long.class),
        arg("commentId", long.class)),

    GETREQUESTCOMMENTS(
        Iterable.class,
        "getRequestComments",
        arg("id", long.class)),

    GETREQUESTCOMMENTS_1(
        Iterable.class,
        "getRequestComments",
        arg("request", org.zendesk.client.v2.model.Request.class)),

    GETREQUESTS(
        Iterable.class,
        "getRequests"),

    GETSATISFACTIONRATING(
        org.zendesk.client.v2.model.SatisfactionRating.class,
        "getSatisfactionRating",
        arg("id", long.class)),

    GETSATISFACTIONRATINGS(
        Iterable.class,
        "getSatisfactionRatings"),

    GETSCHEDULE(
        org.zendesk.client.v2.model.schedules.Schedule.class,
        "getSchedule",
        arg("schedule", org.zendesk.client.v2.model.schedules.Schedule.class)),

    GETSCHEDULE_1(
        org.zendesk.client.v2.model.schedules.Schedule.class,
        "getSchedule",
        arg("scheduleId", Long.class)),

    GETSCHEDULES(
        Iterable.class,
        "getSchedules"),

    GETSEARCHRESULTS(
        Iterable.class,
        "getSearchResults",
        arg("query", String.class)),

    GETSEARCHRESULTS_1(
        Iterable.class,
        "getSearchResults",
        arg("type", Class.class),
        arg("query", String.class)),

    GETSEARCHRESULTS_2(
        Iterable.class,
        "getSearchResults",
        arg("type", Class.class),
        arg("query", String.class),
        arg("params", String.class)),

    GETSECTION(
        org.zendesk.client.v2.model.hc.Section.class,
        "getSection",
        arg("id", long.class)),

    GETSECTIONSUBSCRIPTIONS(
        Iterable.class,
        "getSectionSubscriptions",
        arg("sectionId", Long.class)),

    GETSECTIONSUBSCRIPTIONS_1(
        Iterable.class,
        "getSectionSubscriptions",
        arg("sectionId", Long.class),
        arg("locale", String.class)),

    GETSECTIONTRANSLATIONS(
        Iterable.class,
        "getSectionTranslations",
        arg("sectionId", Long.class)),

    GETSECTIONS(
        Iterable.class,
        "getSections"),

    GETSECTIONS_1(
        Iterable.class,
        "getSections",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    GETSOLVEDREQUESTS(
        Iterable.class,
        "getSolvedRequests"),

    GETSUSPENDEDTICKETS(
        Iterable.class,
        "getSuspendedTickets"),

    GETTARGET(
        org.zendesk.client.v2.model.targets.Target.class,
        "getTarget",
        arg("id", long.class)),

    GETTARGETS(
        Iterable.class,
        "getTargets"),

    GETTICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "getTicket",
        arg("id", long.class)),

    GETTICKETAUDIT(
        org.zendesk.client.v2.model.Audit.class,
        "getTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("audit", org.zendesk.client.v2.model.Audit.class)),

    GETTICKETAUDIT_1(
        org.zendesk.client.v2.model.Audit.class,
        "getTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("id", long.class)),

    GETTICKETAUDIT_2(
        org.zendesk.client.v2.model.Audit.class,
        "getTicketAudit",
        arg("ticketId", long.class),
        arg("auditId", long.class)),

    GETTICKETAUDITS(
        Iterable.class,
        "getTicketAudits",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    GETTICKETAUDITS_1(
        Iterable.class,
        "getTicketAudits",
        arg("ticketId0", Long.class)),

    GETTICKETCOLLABORATORS(
        java.util.List.class,
        "getTicketCollaborators",
        arg("id", long.class)),

    GETTICKETCOMMENTS(
        Iterable.class,
        "getTicketComments",
        arg("id", long.class)),

    GETTICKETFIELD(
        org.zendesk.client.v2.model.Field.class,
        "getTicketField",
        arg("id", long.class)),

    GETTICKETFIELDS(
        java.util.List.class,
        "getTicketFields"),

    GETTICKETFORM(
        org.zendesk.client.v2.model.TicketForm.class,
        "getTicketForm",
        arg("id", long.class)),

    GETTICKETFORMS(
        java.util.List.class,
        "getTicketForms"),

    GETTICKETINCIDENTS(
        java.util.List.class,
        "getTicketIncidents",
        arg("id", long.class)),

    GETTICKETMETRIC(
        org.zendesk.client.v2.model.Metric.class,
        "getTicketMetric",
        arg("id", long.class)),

    GETTICKETMETRICBYTICKET(
        org.zendesk.client.v2.model.Metric.class,
        "getTicketMetricByTicket",
        arg("id", long.class)),

    GETTICKETMETRICS(
        Iterable.class,
        "getTicketMetrics"),

    GETTICKETS(
        Iterable.class,
        "getTickets"),

    GETTICKETS_1(
        java.util.List.class,
        "getTickets",
        arg("id", long.class),
        arg("ids", new long[0].getClass())),

    GETTICKETSBYEXTERNALID(
        Iterable.class,
        "getTicketsByExternalId",
        arg("externalId", String.class)),

    GETTICKETSBYEXTERNALID_1(
        Iterable.class,
        "getTicketsByExternalId",
        arg("externalId", String.class),
        arg("includeArchived", boolean.class)),

    GETTICKETSFROMSEARCH(
        Iterable.class,
        "getTicketsFromSearch",
        arg("searchTerm", String.class)),

    GETTICKETSINCREMENTALLY(
        Iterable.class,
        "getTicketsIncrementally",
        arg("startTime", java.util.Date.class)),

    GETTICKETSINCREMENTALLY_1(
        Iterable.class,
        "getTicketsIncrementally",
        arg("startTime", java.util.Date.class),
        arg("endTime", java.util.Date.class)),

    GETTOPIC(
        org.zendesk.client.v2.model.Topic.class,
        "getTopic",
        arg("id", long.class)),

    GETTOPICS(
        Iterable.class,
        "getTopics"),

    GETTOPICS_1(
        java.util.List.class,
        "getTopics",
        arg("forum_id", long.class)),

    GETTOPICS_2(
        java.util.List.class,
        "getTopics",
        arg("id", long.class),
        arg("ids", new long[0].getClass())),

    GETTOPICSBYUSER(
        java.util.List.class,
        "getTopicsByUser",
        arg("user_id", long.class)),

    GETTRIGGER(
        org.zendesk.client.v2.model.Trigger.class,
        "getTrigger",
        arg("id", long.class)),

    GETTRIGGERS(
        Iterable.class,
        "getTriggers"),

    GETTWITTERMONITORS(
        Iterable.class,
        "getTwitterMonitors"),

    GETUSER(
        org.zendesk.client.v2.model.User.class,
        "getUser",
        arg("id", long.class)),

    GETUSERCCDTICKETS(
        Iterable.class,
        "getUserCCDTickets",
        arg("userId", long.class)),

    GETUSERFIELDS(
        Iterable.class,
        "getUserFields"),

    GETUSERIDENTITIES(
        java.util.List.class,
        "getUserIdentities",
        arg("user", org.zendesk.client.v2.model.User.class)),

    GETUSERIDENTITIES_1(
        java.util.List.class,
        "getUserIdentities",
        arg("userId", long.class)),

    GETUSERIDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "getUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    GETUSERIDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "getUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    GETUSERIDENTITY_2(
        org.zendesk.client.v2.model.Identity.class,
        "getUserIdentity",
        arg("userId", long.class),
        arg("identityId", long.class)),

    GETUSERREQUESTEDTICKETS(
        Iterable.class,
        "getUserRequestedTickets",
        arg("userId", long.class)),

    GETUSERREQUESTS(
        Iterable.class,
        "getUserRequests",
        arg("id", long.class)),

    GETUSERREQUESTS_1(
        Iterable.class,
        "getUserRequests",
        arg("user", org.zendesk.client.v2.model.User.class)),

    GETUSERSUBSCRIPTIONS(
        Iterable.class,
        "getUserSubscriptions",
        arg("user", org.zendesk.client.v2.model.User.class)),

    GETUSERSUBSCRIPTIONS_1(
        Iterable.class,
        "getUserSubscriptions",
        arg("userId0", Long.class)),

    GETUSERS(
        Iterable.class,
        "getUsers"),

    GETUSERSBYROLE(
        Iterable.class,
        "getUsersByRole",
        arg("role", String.class),
        arg("roles", new String[0].getClass())),

    GETUSERSINCREMENTALLY(
        Iterable.class,
        "getUsersIncrementally",
        arg("startTime", java.util.Date.class)),

    IMPORTTICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "importTicket",
        arg("ticketImport", org.zendesk.client.v2.model.TicketImport.class)),

    IMPORTTOPIC(
        org.zendesk.client.v2.model.Topic.class,
        "importTopic",
        arg("topic", org.zendesk.client.v2.model.Topic.class)),

    LOOKUPORGANIZATIONSBYEXTERNALID(
        Iterable.class,
        "lookupOrganizationsByExternalId",
        arg("externalId", String.class)),

    LOOKUPUSERBYEMAIL(
        Iterable.class,
        "lookupUserByEmail",
        arg("email", String.class)),

    LOOKUPUSERBYEXTERNALID(
        Iterable.class,
        "lookupUserByExternalId",
        arg("externalId", String.class)),

    MACROSSHOWCHANGESTOTICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "macrosShowChangesToTicket",
        arg("macroId", long.class)),

    MACROSSHOWTICKETAFTERCHANGES(
        org.zendesk.client.v2.model.Ticket.class,
        "macrosShowTicketAfterChanges",
        arg("ticketId", long.class),
        arg("macroId", long.class)),

    MAKEPRIVATETICKETAUDIT(
        void.class,
        "makePrivateTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("audit", org.zendesk.client.v2.model.Audit.class)),

    MAKEPRIVATETICKETAUDIT_1(
        void.class,
        "makePrivateTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("id", long.class)),

    MAKEPRIVATETICKETAUDIT_2(
        void.class,
        "makePrivateTicketAudit",
        arg("ticketId", long.class),
        arg("auditId", long.class)),

    MARKTICKETASSPAM(
        void.class,
        "markTicketAsSpam",
        arg("id", long.class)),

    MARKTICKETASSPAM_1(
        void.class,
        "markTicketAsSpam",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    NOTIFYAPP(
        void.class,
        "notifyApp",
        arg("json", String.class)),

    QUEUECREATETICKETASYNC(
        org.asynchttpclient.ListenableFuture.class,
        "queueCreateTicketAsync",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    REMOVETAGFROMORGANISATIONS(
        java.util.List.class,
        "removeTagFromOrganisations",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    REMOVETAGFROMTICKET(
        java.util.List.class,
        "removeTagFromTicket",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    REMOVETAGFROMTOPICS(
        java.util.List.class,
        "removeTagFromTopics",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    REQUESTVERIFYUSERIDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "requestVerifyUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    REQUESTVERIFYUSERIDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "requestVerifyUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    REQUESTVERIFYUSERIDENTITY_2(
        org.zendesk.client.v2.model.Identity.class,
        "requestVerifyUserIdentity",
        arg("userId", long.class),
        arg("identityId", long.class)),

    RESETUSERPASSWORD(
        void.class,
        "resetUserPassword",
        arg("id", long.class),
        arg("password", String.class)),

    RESETUSERPASSWORD_1(
        void.class,
        "resetUserPassword",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("password", String.class)),

    SETGROUPMEMBERSHIPASDEFAULT(
        java.util.List.class,
        "setGroupMembershipAsDefault",
        arg("user_id", long.class),
        arg("groupMembership", org.zendesk.client.v2.model.GroupMembership.class)),

    SETORGANIZATIONMEMBERSHIPASDEFAULT(
        java.util.List.class,
        "setOrganizationMembershipAsDefault",
        arg("user_id", long.class),
        arg("organizationMembership", org.zendesk.client.v2.model.OrganizationMembership.class)),

    SETTAGONORGANISATIONS(
        java.util.List.class,
        "setTagOnOrganisations",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    SETTAGONTICKET(
        java.util.List.class,
        "setTagOnTicket",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    SETTAGONTOPICS(
        java.util.List.class,
        "setTagOnTopics",
        arg("id", long.class),
        arg("tags", new String[0].getClass())),

    SETUSERPRIMARYIDENTITY(
        java.util.List.class,
        "setUserPrimaryIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    SETUSERPRIMARYIDENTITY_1(
        java.util.List.class,
        "setUserPrimaryIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    SETUSERPRIMARYIDENTITY_2(
        java.util.List.class,
        "setUserPrimaryIdentity",
        arg("userId", long.class),
        arg("identityId", long.class)),

    SUSPENDUSER(
        org.zendesk.client.v2.model.User.class,
        "suspendUser",
        arg("id", long.class)),

    TRUSTTICKETAUDIT(
        void.class,
        "trustTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("audit", org.zendesk.client.v2.model.Audit.class)),

    TRUSTTICKETAUDIT_1(
        void.class,
        "trustTicketAudit",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class),
        arg("id", long.class)),

    TRUSTTICKETAUDIT_2(
        void.class,
        "trustTicketAudit",
        arg("ticketId", long.class),
        arg("auditId", long.class)),

    UNSUSPENDUSER(
        org.zendesk.client.v2.model.User.class,
        "unsuspendUser",
        arg("id", long.class)),

    UPDATEARTICLE(
        org.zendesk.client.v2.model.hc.Article.class,
        "updateArticle",
        arg("article", org.zendesk.client.v2.model.hc.Article.class)),

    UPDATEARTICLETRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "updateArticleTranslation",
        arg("articleId", Long.class),
        arg("locale", String.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    UPDATEAUTOMATION(
        org.zendesk.client.v2.model.Automation.class,
        "updateAutomation",
        arg("automationId", Long.class),
        arg("automation", org.zendesk.client.v2.model.Automation.class)),

    UPDATECATEGORY(
        org.zendesk.client.v2.model.hc.Category.class,
        "updateCategory",
        arg("category", org.zendesk.client.v2.model.hc.Category.class)),

    UPDATECATEGORYTRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "updateCategoryTranslation",
        arg("categoryId", Long.class),
        arg("locale", String.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    UPDATEFORUM(
        org.zendesk.client.v2.model.Forum.class,
        "updateForum",
        arg("forum", org.zendesk.client.v2.model.Forum.class)),

    UPDATEGROUP(
        org.zendesk.client.v2.model.Group.class,
        "updateGroup",
        arg("group", org.zendesk.client.v2.model.Group.class)),

    UPDATEINSTALLATION(
        void.class,
        "updateInstallation",
        arg("installationId", int.class),
        arg("json", String.class)),

    UPDATEMACRO(
        org.zendesk.client.v2.model.Macro.class,
        "updateMacro",
        arg("macroId0", Long.class),
        arg("macro", org.zendesk.client.v2.model.Macro.class)),

    UPDATEORGANIZATION(
        org.zendesk.client.v2.model.Organization.class,
        "updateOrganization",
        arg("organization", org.zendesk.client.v2.model.Organization.class)),

    UPDATEREQUEST(
        org.zendesk.client.v2.model.Request.class,
        "updateRequest",
        arg("request", org.zendesk.client.v2.model.Request.class)),

    UPDATESECTION(
        org.zendesk.client.v2.model.hc.Section.class,
        "updateSection",
        arg("section", org.zendesk.client.v2.model.hc.Section.class)),

    UPDATESECTIONTRANSLATION(
        org.zendesk.client.v2.model.hc.Translation.class,
        "updateSectionTranslation",
        arg("sectionId", Long.class),
        arg("locale", String.class),
        arg("translation", org.zendesk.client.v2.model.hc.Translation.class)),

    UPDATETICKET(
        org.zendesk.client.v2.model.Ticket.class,
        "updateTicket",
        arg("ticket", org.zendesk.client.v2.model.Ticket.class)),

    UPDATETICKETFIELD(
        org.zendesk.client.v2.model.Field.class,
        "updateTicketField",
        arg("field", org.zendesk.client.v2.model.Field.class)),

    UPDATETOPIC(
        org.zendesk.client.v2.model.Topic.class,
        "updateTopic",
        arg("topic", org.zendesk.client.v2.model.Topic.class)),

    UPDATETRIGGER(
        org.zendesk.client.v2.model.Trigger.class,
        "updateTrigger",
        arg("triggerId0", Long.class),
        arg("trigger", org.zendesk.client.v2.model.Trigger.class)),

    UPDATEUSER(
        org.zendesk.client.v2.model.User.class,
        "updateUser",
        arg("user", org.zendesk.client.v2.model.User.class)),

    UPDATEUSERIDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "updateUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    UPDATEUSERIDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "updateUserIdentity",
        arg("userId", long.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    VERIFYUSERIDENTITY(
        org.zendesk.client.v2.model.Identity.class,
        "verifyUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identity", org.zendesk.client.v2.model.Identity.class)),

    VERIFYUSERIDENTITY_1(
        org.zendesk.client.v2.model.Identity.class,
        "verifyUserIdentity",
        arg("user", org.zendesk.client.v2.model.User.class),
        arg("identityId", long.class)),

    VERIFYUSERIDENTITY_2(
        org.zendesk.client.v2.model.Identity.class,
        "verifyUserIdentity",
        arg("userId", long.class),
        arg("identityId", long.class));

    

    private final ApiMethod apiMethod;

    private ZendeskApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(Zendesk.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
