/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.athena.Athena2Component;
import org.apache.camel.component.aws2.athena.Athena2Configuration;
import org.apache.camel.component.aws2.athena.Athena2Operations;
import org.apache.camel.component.aws2.athena.Athena2OutputType;
import org.apache.camel.spi.GeneratedPropertyConfigurer;
import org.apache.camel.spi.PropertyConfigurerGetter;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.CaseInsensitiveMap;
import software.amazon.awssdk.core.Protocol;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.EncryptionOption;

public class Athena2ComponentConfigurer
extends PropertyConfigurerSupport
implements GeneratedPropertyConfigurer,
PropertyConfigurerGetter {
    private Athena2Configuration getOrCreateConfiguration(Athena2Component target) {
        if (target.getConfiguration() == null) {
            target.setConfiguration(new Athena2Configuration());
        }
        return target.getConfiguration();
    }

    public boolean configure(CamelContext camelContext, Object obj, String name, Object value, boolean ignoreCase) {
        Athena2Component target = (Athena2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                this.getOrCreateConfiguration(target).setAccessKey((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "amazonathenaclient": 
            case "amazonAthenaClient": {
                this.getOrCreateConfiguration(target).setAmazonAthenaClient((AthenaClient)Athena2ComponentConfigurer.property((CamelContext)camelContext, AthenaClient.class, (Object)value));
                return true;
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                target.setBasicPropertyBinding((Boolean)Athena2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "clientrequesttoken": 
            case "clientRequestToken": {
                this.getOrCreateConfiguration(target).setClientRequestToken((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "configuration": {
                target.setConfiguration((Athena2Configuration)Athena2ComponentConfigurer.property((CamelContext)camelContext, Athena2Configuration.class, (Object)value));
                return true;
            }
            case "database": {
                this.getOrCreateConfiguration(target).setDatabase((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "delay": {
                this.getOrCreateConfiguration(target).setDelay((Long)Athena2ComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "encryptionoption": 
            case "encryptionOption": {
                this.getOrCreateConfiguration(target).setEncryptionOption((EncryptionOption)Athena2ComponentConfigurer.property((CamelContext)camelContext, EncryptionOption.class, (Object)value));
                return true;
            }
            case "includetrace": 
            case "includeTrace": {
                this.getOrCreateConfiguration(target).setIncludeTrace((Boolean)Athena2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "initialdelay": 
            case "initialDelay": {
                this.getOrCreateConfiguration(target).setInitialDelay((Long)Athena2ComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "kmskey": 
            case "kmsKey": {
                this.getOrCreateConfiguration(target).setKmsKey((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                target.setLazyStartProducer((Boolean)Athena2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "maxattempts": 
            case "maxAttempts": {
                this.getOrCreateConfiguration(target).setMaxAttempts((Integer)Athena2ComponentConfigurer.property((CamelContext)camelContext, Integer.TYPE, (Object)value));
                return true;
            }
            case "maxresults": 
            case "maxResults": {
                this.getOrCreateConfiguration(target).setMaxResults((Integer)Athena2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "nexttoken": 
            case "nextToken": {
                this.getOrCreateConfiguration(target).setNextToken((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "operation": {
                this.getOrCreateConfiguration(target).setOperation((Athena2Operations)((Object)Athena2ComponentConfigurer.property((CamelContext)camelContext, Athena2Operations.class, (Object)value)));
                return true;
            }
            case "outputlocation": 
            case "outputLocation": {
                this.getOrCreateConfiguration(target).setOutputLocation((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "outputtype": 
            case "outputType": {
                this.getOrCreateConfiguration(target).setOutputType((Athena2OutputType)((Object)Athena2ComponentConfigurer.property((CamelContext)camelContext, Athena2OutputType.class, (Object)value)));
                return true;
            }
            case "proxyhost": 
            case "proxyHost": {
                this.getOrCreateConfiguration(target).setProxyHost((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "proxyport": 
            case "proxyPort": {
                this.getOrCreateConfiguration(target).setProxyPort((Integer)Athena2ComponentConfigurer.property((CamelContext)camelContext, Integer.class, (Object)value));
                return true;
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                this.getOrCreateConfiguration(target).setProxyProtocol((Protocol)Athena2ComponentConfigurer.property((CamelContext)camelContext, Protocol.class, (Object)value));
                return true;
            }
            case "queryexecutionid": 
            case "queryExecutionId": {
                this.getOrCreateConfiguration(target).setQueryExecutionId((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "querystring": 
            case "queryString": {
                this.getOrCreateConfiguration(target).setQueryString((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "region": {
                this.getOrCreateConfiguration(target).setRegion((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "resetwaittimeoutonretry": 
            case "resetWaitTimeoutOnRetry": {
                this.getOrCreateConfiguration(target).setResetWaitTimeoutOnRetry((Boolean)Athena2ComponentConfigurer.property((CamelContext)camelContext, Boolean.TYPE, (Object)value));
                return true;
            }
            case "retry": {
                this.getOrCreateConfiguration(target).setRetry((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "secretkey": 
            case "secretKey": {
                this.getOrCreateConfiguration(target).setSecretKey((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
            case "waittimeout": 
            case "waitTimeout": {
                this.getOrCreateConfiguration(target).setWaitTimeout((Long)Athena2ComponentConfigurer.property((CamelContext)camelContext, Long.TYPE, (Object)value));
                return true;
            }
            case "workgroup": 
            case "workGroup": {
                this.getOrCreateConfiguration(target).setWorkGroup((String)Athena2ComponentConfigurer.property((CamelContext)camelContext, String.class, (Object)value));
                return true;
            }
        }
        return false;
    }

    public Map<String, Object> getAllOptions(Object target) {
        CaseInsensitiveMap answer = new CaseInsensitiveMap();
        answer.put("accessKey", String.class);
        answer.put("amazonAthenaClient", AthenaClient.class);
        answer.put("basicPropertyBinding", Boolean.TYPE);
        answer.put("clientRequestToken", String.class);
        answer.put("configuration", Athena2Configuration.class);
        answer.put("database", String.class);
        answer.put("delay", Long.TYPE);
        answer.put("encryptionOption", EncryptionOption.class);
        answer.put("includeTrace", Boolean.TYPE);
        answer.put("initialDelay", Long.TYPE);
        answer.put("kmsKey", String.class);
        answer.put("lazyStartProducer", Boolean.TYPE);
        answer.put("maxAttempts", Integer.TYPE);
        answer.put("maxResults", Integer.class);
        answer.put("nextToken", String.class);
        answer.put("operation", Athena2Operations.class);
        answer.put("outputLocation", String.class);
        answer.put("outputType", Athena2OutputType.class);
        answer.put("proxyHost", String.class);
        answer.put("proxyPort", Integer.class);
        answer.put("proxyProtocol", Protocol.class);
        answer.put("queryExecutionId", String.class);
        answer.put("queryString", String.class);
        answer.put("region", String.class);
        answer.put("resetWaitTimeoutOnRetry", Boolean.TYPE);
        answer.put("retry", String.class);
        answer.put("secretKey", String.class);
        answer.put("waitTimeout", Long.TYPE);
        answer.put("workGroup", String.class);
        return answer;
    }

    public Object getOptionValue(Object obj, String name, boolean ignoreCase) {
        Athena2Component target = (Athena2Component)((Object)obj);
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "accesskey": 
            case "accessKey": {
                return this.getOrCreateConfiguration(target).getAccessKey();
            }
            case "amazonathenaclient": 
            case "amazonAthenaClient": {
                return this.getOrCreateConfiguration(target).getAmazonAthenaClient();
            }
            case "basicpropertybinding": 
            case "basicPropertyBinding": {
                return target.isBasicPropertyBinding();
            }
            case "clientrequesttoken": 
            case "clientRequestToken": {
                return this.getOrCreateConfiguration(target).getClientRequestToken();
            }
            case "configuration": {
                return target.getConfiguration();
            }
            case "database": {
                return this.getOrCreateConfiguration(target).getDatabase();
            }
            case "delay": {
                return this.getOrCreateConfiguration(target).getDelay();
            }
            case "encryptionoption": 
            case "encryptionOption": {
                return this.getOrCreateConfiguration(target).getEncryptionOption();
            }
            case "includetrace": 
            case "includeTrace": {
                return this.getOrCreateConfiguration(target).isIncludeTrace();
            }
            case "initialdelay": 
            case "initialDelay": {
                return this.getOrCreateConfiguration(target).getInitialDelay();
            }
            case "kmskey": 
            case "kmsKey": {
                return this.getOrCreateConfiguration(target).getKmsKey();
            }
            case "lazystartproducer": 
            case "lazyStartProducer": {
                return target.isLazyStartProducer();
            }
            case "maxattempts": 
            case "maxAttempts": {
                return this.getOrCreateConfiguration(target).getMaxAttempts();
            }
            case "maxresults": 
            case "maxResults": {
                return this.getOrCreateConfiguration(target).getMaxResults();
            }
            case "nexttoken": 
            case "nextToken": {
                return this.getOrCreateConfiguration(target).getNextToken();
            }
            case "operation": {
                return this.getOrCreateConfiguration(target).getOperation();
            }
            case "outputlocation": 
            case "outputLocation": {
                return this.getOrCreateConfiguration(target).getOutputLocation();
            }
            case "outputtype": 
            case "outputType": {
                return this.getOrCreateConfiguration(target).getOutputType();
            }
            case "proxyhost": 
            case "proxyHost": {
                return this.getOrCreateConfiguration(target).getProxyHost();
            }
            case "proxyport": 
            case "proxyPort": {
                return this.getOrCreateConfiguration(target).getProxyPort();
            }
            case "proxyprotocol": 
            case "proxyProtocol": {
                return this.getOrCreateConfiguration(target).getProxyProtocol();
            }
            case "queryexecutionid": 
            case "queryExecutionId": {
                return this.getOrCreateConfiguration(target).getQueryExecutionId();
            }
            case "querystring": 
            case "queryString": {
                return this.getOrCreateConfiguration(target).getQueryString();
            }
            case "region": {
                return this.getOrCreateConfiguration(target).getRegion();
            }
            case "resetwaittimeoutonretry": 
            case "resetWaitTimeoutOnRetry": {
                return this.getOrCreateConfiguration(target).isResetWaitTimeoutOnRetry();
            }
            case "retry": {
                return this.getOrCreateConfiguration(target).getRetry();
            }
            case "secretkey": 
            case "secretKey": {
                return this.getOrCreateConfiguration(target).getSecretKey();
            }
            case "waittimeout": 
            case "waitTimeout": {
                return this.getOrCreateConfiguration(target).getWaitTimeout();
            }
            case "workgroup": 
            case "workGroup": {
                return this.getOrCreateConfiguration(target).getWorkGroup();
            }
        }
        return null;
    }
}

