/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.athena;

import java.util.Map;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.aws2.athena.Athena2ComponentVerifierExtension;
import org.apache.camel.component.aws2.athena.Athena2Configuration;
import org.apache.camel.component.aws2.athena.Athena2Endpoint;
import org.apache.camel.component.extension.ComponentExtension;
import org.apache.camel.spi.Metadata;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.athena.AthenaClient;

@org.apache.camel.spi.annotations.Component(value="aws2-athena")
public class Athena2Component
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(Athena2Component.class);
    @Metadata
    private Athena2Configuration configuration = new Athena2Configuration();

    public Athena2Component() {
        this(null);
    }

    public Athena2Component(CamelContext context) {
        super(context);
        this.registerExtension((ComponentExtension)new Athena2ComponentVerifierExtension());
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Athena2Configuration configuration = this.configuration != null ? this.configuration.copy() : new Athena2Configuration();
        Athena2Endpoint endpoint = new Athena2Endpoint(uri, (Component)this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        this.checkAndSetRegistryClient(configuration, endpoint);
        if (configuration.getAmazonAthenaClient() == null && (configuration.getAccessKey() == null || configuration.getSecretKey() == null)) {
            throw new IllegalArgumentException("accessKey/secretKey or amazonAthenaClient must be specified");
        }
        return endpoint;
    }

    public Athena2Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Athena2Configuration configuration) {
        this.configuration = configuration;
    }

    private void checkAndSetRegistryClient(Athena2Configuration configuration, Athena2Endpoint endpoint) {
        if (ObjectHelper.isEmpty((Object)endpoint.getConfiguration().getAmazonAthenaClient())) {
            LOG.debug("Looking for an AthenaClient instance in the registry");
            Set clients = this.getCamelContext().getRegistry().findByType(AthenaClient.class);
            if (clients.size() == 1) {
                LOG.debug("Found exactly one AthenaClient instance in the registry");
                configuration.setAmazonAthenaClient((AthenaClient)clients.stream().findFirst().get());
            } else {
                LOG.debug("No AthenaClient instance in the registry");
            }
        } else {
            LOG.debug("AthenaClient instance is already set at endpoint level: skipping the check in the registry");
        }
    }
}

