/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.service;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.cloud.DiscoverableService;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceRegistry;
import org.apache.camel.component.service.ServiceComponent;
import org.apache.camel.component.service.ServiceConsumer;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;

@ManagedResource(description="Managed Service Endpoint")
@UriEndpoint(firstVersion="2.22.0", scheme="service", syntax="service:delegateUri", consumerOnly=true, title="Service", lenientProperties=true, category={Category.CLOUD})
public class ServiceEndpoint
extends DefaultEndpoint
implements DelegateEndpoint {
    private final Endpoint delegateEndpoint;
    private final ServiceRegistry serviceRegistry;
    private final Map<String, String> serviceParameters;
    private final ServiceDefinition serviceDefinition;
    @UriPath(description="The endpoint uri to expose as service")
    @Metadata(required=true)
    private final String delegateUri;

    public ServiceEndpoint(String uri, ServiceComponent component, ServiceRegistry serviceRegistry, Map<String, String> serviceParameters, String delegateUri) {
        super(uri, (Component)component);
        this.serviceRegistry = serviceRegistry;
        this.serviceParameters = serviceParameters;
        this.delegateUri = delegateUri;
        this.delegateEndpoint = this.getCamelContext().getEndpoint(delegateUri);
        this.serviceDefinition = this.computeServiceDefinition(component.getCamelContext(), this.delegateEndpoint);
    }

    public Endpoint getEndpoint() {
        return this.delegateEndpoint;
    }

    @ManagedAttribute(description="The consumer endpoint to expose as a service", mask=true)
    public String getDelegateEndpointUri() {
        return this.delegateEndpoint.getEndpointUri();
    }

    public ServiceDefinition getServiceDefinition() {
        return this.serviceDefinition;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new ServiceConsumer(this, processor, this.serviceRegistry);
    }

    public boolean isLenientProperties() {
        return true;
    }

    private ServiceDefinition computeServiceDefinition(CamelContext context, Endpoint delegateEndpoint) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (delegateEndpoint instanceof DiscoverableService) {
            parameters.putAll(((DiscoverableService)delegateEndpoint).getServiceProperties());
        }
        parameters.putAll(this.serviceParameters);
        parameters.computeIfAbsent("service.id", k -> context.getUuidGenerator().generateUuid());
        return DefaultServiceDefinition.builder().from(parameters).build();
    }
}

